/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.ConstantFieldInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.HostMethodInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.PartialEvaluationMethodInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilable;

public interface TruffleCompilerRuntime {
    public void onCodeInstallation(TruffleCompilable var1, InstalledCode var2);

    public PartialEvaluationMethodInfo getPartialEvaluationMethodInfo(ResolvedJavaMethod var1);

    public HostMethodInfo getHostMethodInfo(ResolvedJavaMethod var1);

    public ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField var1);

    public TruffleCompilable asCompilableTruffleAST(JavaConstant var1);

    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant var1);

    default public void logEvent(TruffleCompilable compilable, int depth, String event, Map<String, Object> properties) {
        this.logEvent(compilable, depth, event, compilable.toString(), properties, null);
    }

    default public void logEvent(TruffleCompilable compilable, int depth, String event, String subject, Map<String, Object> properties, String message) {
        String formattedMessage = this.formatEvent(depth, event, 12, subject, 60, properties, 0);
        if (message != null) {
            formattedMessage = String.format("%s%n%s", formattedMessage, message);
        }
        this.log(compilable, formattedMessage);
    }

    default public void log(TruffleCompilable compilable, String message) {
        this.log("engine", compilable, message);
    }

    public void log(String var1, TruffleCompilable var2, String var3);

    default public String formatEvent(int depth, String event, int eventWidth, String subject, int subjectWidth, Map<String, Object> properties, int propertyWidth) {
        if (depth < 0) {
            throw new IllegalArgumentException("depth is negative: " + depth);
        }
        if (eventWidth < 0) {
            throw new IllegalArgumentException("eventWidth is negative: " + eventWidth);
        }
        if (subjectWidth < 0) {
            throw new IllegalArgumentException("subjectWidth is negative: " + subjectWidth);
        }
        if (propertyWidth < 0) {
            throw new IllegalArgumentException("propertyWidth is negative: " + propertyWidth);
        }
        int subjectIndent = depth * 2;
        StringBuilder sb = new StringBuilder();
        String format = "%-" + eventWidth + "s%" + (1 + subjectIndent) + "s%-" + Math.max(1, subjectWidth - subjectIndent) + "s";
        sb.append(String.format(format, event, "", subject));
        if (properties != null) {
            for (String property : properties.keySet()) {
                Object value = properties.get(property);
                if (value == null) continue;
                sb.append("|");
                sb.append(property);
                String valueString = value instanceof Integer ? String.format("%6d", value) : (value instanceof Double ? String.format("%8.2f", value) : String.valueOf(value));
                int length = Math.max(1, propertyWidth - property.length());
                sb.append(String.format(" %" + length + "s", valueString));
            }
        }
        return sb.toString();
    }

    default public ResolvedJavaType resolveType(MetaAccessProvider metaAccess, String className) {
        return this.resolveType(metaAccess, className, true);
    }

    public ResolvedJavaType resolveType(MetaAccessProvider var1, String var2, boolean var3);

    public boolean isValueType(ResolvedJavaType var1);

    public boolean isSuppressedFailure(TruffleCompilable var1, Supplier<String> var2);

    public static enum InlineKind {
        INLINE(true),
        DO_NOT_INLINE_WITH_EXCEPTION(false),
        DO_NOT_INLINE_NO_EXCEPTION(false),
        DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION(false),
        DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION(false);

        private final boolean allowsInlining;

        private InlineKind(boolean allowsInlining) {
            this.allowsInlining = allowsInlining;
        }

        public boolean allowsInlining() {
            return this.allowsInlining;
        }
    }

    public static enum LoopExplosionKind {
        NONE,
        FULL_UNROLL,
        FULL_UNROLL_UNTIL_RETURN,
        FULL_EXPLODE,
        FULL_EXPLODE_UNTIL_RETURN,
        MERGE_EXPLODE;

    }
}

