/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import java.lang.reflect.Field;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringOps;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import sun.misc.Unsafe;

final class TStringUnsafe {
    static final int JAVA_SPEC = TStringUnsafe.getJavaSpecificationVersion();
    private static final Unsafe UNSAFE = TStringUnsafe.getUnsafe();
    private static final long javaStringValueFieldOffset;
    private static final long javaStringCoderFieldOffset;
    private static final long javaStringHashFieldOffset;
    private static final long javaStringHashIsZeroFieldOffset;
    static final boolean COMPACT_STRINGS_ENABLED;

    TStringUnsafe() {
    }

    @CompilerDirectives.TruffleBoundary
    private static int getJavaSpecificationVersion() {
        return Runtime.version().feature();
    }

    private static Object getStaticFieldBase(Field field) {
        return UNSAFE.staticFieldBase(field);
    }

    private static long getStaticFieldOffset(Field field) {
        return UNSAFE.staticFieldOffset(field);
    }

    private static long getObjectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    @CompilerDirectives.TruffleBoundary
    private static Field getStringDeclaredField(String name) {
        try {
            return String.class.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("failed to get " + name + " field offset", e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException e1) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e2) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e2);
            }
        }
    }

    static int byteArrayBaseOffset() {
        return Unsafe.ARRAY_BYTE_BASE_OFFSET;
    }

    static int charArrayBaseOffset() {
        return Unsafe.ARRAY_CHAR_BASE_OFFSET;
    }

    static int intArrayBaseOffset() {
        return Unsafe.ARRAY_INT_BASE_OFFSET;
    }

    static byte[] getJavaStringArray(String str) {
        assert (JAVA_SPEC > 8);
        Object value = UNSAFE.getObject(str, javaStringValueFieldOffset);
        assert (value instanceof byte[]);
        return (byte[])value;
    }

    static int getJavaStringStride(String s) {
        return UNSAFE.getByte(s, javaStringCoderFieldOffset);
    }

    static int getJavaStringHash(String s) {
        return UNSAFE.getInt(s, javaStringHashFieldOffset);
    }

    static boolean getJavaStringHashIsZero(String s) {
        return UNSAFE.getBoolean(s, javaStringHashIsZeroFieldOffset);
    }

    static int getJavaStringHashMasked(String s) {
        int hash = TStringUnsafe.getJavaStringHash(s);
        if (CompilerDirectives.injectBranchProbability(0.25, hash == 0 && TStringUnsafe.getJavaStringHashIsZero(s))) {
            return TruffleString.HashCodeNode.maskZero(hash);
        }
        return hash;
    }

    @CompilerDirectives.TruffleBoundary
    private static String allocateJavaString() {
        try {
            return (String)UNSAFE.allocateInstance(String.class);
        }
        catch (InstantiationException e) {
            throw CompilerDirectives.shouldNotReachHere("unsafe string allocation failed", e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static String createJavaString(byte[] bytes, int stride, int hash) {
        if (stride < (COMPACT_STRINGS_ENABLED ? 0 : 1) || stride > 1) {
            throw new IllegalArgumentException("illegal stride!");
        }
        String ret = TStringUnsafe.allocateJavaString();
        UNSAFE.putInt(ret, javaStringHashFieldOffset, hash);
        UNSAFE.putByte(ret, javaStringCoderFieldOffset, (byte)stride);
        UNSAFE.putObjectVolatile(ret, javaStringValueFieldOffset, bytes);
        assert (TStringUnsafe.checkUnsafeStringResult(bytes, stride, ret));
        return ret;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean checkUnsafeStringResult(byte[] bytes, int stride, String ret) {
        int length = bytes.length >> stride;
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)TStringOps.readFromByteArray(bytes, stride, i);
        }
        return new String(chars).equals(ret);
    }

    static byte getByte(byte[] array, long byteOffset) {
        return UNSAFE.getByte(array, byteOffset);
    }

    static char getChar(byte[] array, long byteOffset) {
        return UNSAFE.getChar(array, byteOffset);
    }

    static int getInt(byte[] array, long byteOffset) {
        return UNSAFE.getInt(array, byteOffset);
    }

    static long getLong(byte[] array, long byteOffset) {
        return UNSAFE.getLong(array, byteOffset);
    }

    static void putByte(byte[] array, long byteOffset, byte value) {
        UNSAFE.putByte(array, byteOffset, value);
    }

    static void putChar(byte[] array, long byteOffset, char value) {
        UNSAFE.putChar(array, byteOffset, value);
    }

    static void putInt(byte[] array, long byteOffset, int value) {
        UNSAFE.putInt(array, byteOffset, value);
    }

    static void copyFromNative(long arraySrc, int offsetSrc, byte[] arrayDst, long offsetDst, int byteLength) {
        UNSAFE.copyMemory(null, arraySrc + (long)offsetSrc, arrayDst, (long)TStringUnsafe.byteArrayBaseOffset() + offsetDst, byteLength);
    }

    static {
        if (JAVA_SPEC <= 8) {
            throw new RuntimeException("TruffleString requires Java version > 8");
        }
        Field valueField = TStringUnsafe.getStringDeclaredField("value");
        Field coderField = TStringUnsafe.getStringDeclaredField("coder");
        Field hashField = TStringUnsafe.getStringDeclaredField("hash");
        Field hashIsZeroField = TStringUnsafe.getStringDeclaredField("hashIsZero");
        Field compactStringsField = TStringUnsafe.getStringDeclaredField("COMPACT_STRINGS");
        javaStringValueFieldOffset = TStringUnsafe.getObjectFieldOffset(valueField);
        javaStringCoderFieldOffset = TStringUnsafe.getObjectFieldOffset(coderField);
        javaStringHashFieldOffset = TStringUnsafe.getObjectFieldOffset(hashField);
        javaStringHashIsZeroFieldOffset = TStringUnsafe.getObjectFieldOffset(hashIsZeroField);
        COMPACT_STRINGS_ENABLED = UNSAFE.getBoolean(TStringUnsafe.getStaticFieldBase(compactStringsField), TStringUnsafe.getStaticFieldOffset(compactStringsField));
    }
}

