/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.AbstractInternalNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.AbstractTruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringOps;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;

final class TStringOpsNodes {
    static final String LIMIT_STRIDE = "9";

    TStringOpsNodes() {
    }

    static int memcmp(Node location, AbstractTruffleString a, byte[] arrayA, long offsetA, AbstractTruffleString b, byte[] arrayB, long offsetB) {
        int cmp = TStringOps.memcmpWithStride(location, a, arrayA, offsetA, a.stride(), b, arrayB, offsetB, b.stride(), Math.min(a.length(), b.length()));
        return TStringOpsNodes.memCmpTail(cmp, a.length(), b.length());
    }

    static int memcmpBytes(Node location, AbstractTruffleString a, byte[] arrayA, long offsetA, AbstractTruffleString b, byte[] arrayB, long offsetB) {
        int cmp = TStringOps.memcmpBytesWithStride(location, a, arrayA, offsetA, a.stride(), b, arrayB, offsetB, b.stride(), Math.min(a.length(), b.length()));
        return TStringOpsNodes.memCmpTail(cmp, a.length(), b.length());
    }

    static int memCmpTail(int cmp, int lengthA, int lengthB) {
        return cmp == 0 ? lengthA - lengthB : cmp;
    }

    private static char[] removeValuesGreaterThan(Node location, char[] values, int max) {
        int n = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= max) {
                ++n;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (n == values.length) {
            return values;
        }
        char[] clampedValues = new char[n];
        n = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= max) {
                clampedValues[n++] = values[i];
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return clampedValues;
    }

    private static int[] removeValuesGreaterThan(Node location, int[] values, int max) {
        int n = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= max) {
                ++n;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (n == values.length) {
            return values;
        }
        int[] clampedValues = new int[n];
        n = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= max) {
                clampedValues[n++] = values[i];
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return clampedValues;
    }

    static abstract class CalculateHashCodeNode
    extends AbstractInternalNode {
        CalculateHashCodeNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4);

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static int cached(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction) {
            return TStringOps.hashCodeWithStride(node, a, arrayA, offsetA, cachedCompaction.getStride());
        }
    }

    static abstract class RawLastIndexOfStringNode
    extends AbstractInternalNode {
        RawLastIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, AbstractTruffleString var6, byte[] var7, long var8, int var10, int var11, byte[] var12);

        @Specialization(guards={"compactionA == cachedCompactionA", "compactionB == cachedCompactionB"}, limit="9")
        static int cachedLen1(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, AbstractTruffleString b, byte[] arrayB, long offsetB, int fromIndex, int toIndex, byte[] mask, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compactionA, @Cached(value="compactionA") TruffleString.CompactionLevel cachedCompactionA, @Bind(value="fromStride(b.stride())") TruffleString.CompactionLevel compactionB, @Cached(value="compactionB") TruffleString.CompactionLevel cachedCompactionB, @Cached InlinedConditionProfile oneLength) {
            int strideA = cachedCompactionA.getStride();
            int strideB = cachedCompactionB.getStride();
            return RawLastIndexOfStringNode.runIndexOf(node, arrayA, offsetA, a.length(), strideA, arrayB, offsetB, b.length(), strideB, fromIndex, toIndex, mask, oneLength);
        }

        static int runIndexOf(Node node, byte[] arrayA, long offsetA, int lengthA, int strideA, byte[] arrayB, long offsetB, int lengthB, int strideB, int fromIndex, int toIndex, byte[] mask, InlinedConditionProfile oneLength) {
            if (oneLength.profile(node, lengthB == 1)) {
                int b0 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, 0);
                int mask0 = mask == null ? 0 : TStringOps.readFromByteArray(mask, strideB, 0);
                return TStringOps.lastIndexOfCodePointWithOrMaskWithStride(node, arrayA, offsetA, strideA, fromIndex, toIndex, b0, mask0);
            }
            return TStringOps.lastIndexOfStringWithOrMaskWithStride(node, arrayA, offsetA, lengthA, strideA, arrayB, offsetB, lengthB, strideB, fromIndex, toIndex, mask);
        }
    }

    static abstract class RawIndexOfStringNode
    extends AbstractInternalNode {
        RawIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, AbstractTruffleString var6, byte[] var7, long var8, int var10, int var11, byte[] var12);

        @Specialization(guards={"compactionA == cachedCompactionA", "compactionB == cachedCompactionB"}, limit="9")
        static int doCached(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, AbstractTruffleString b, byte[] arrayB, long offsetB, int fromIndex, int toIndex, byte[] mask, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compactionA, @Cached(value="compactionA") TruffleString.CompactionLevel cachedCompactionA, @Bind(value="fromStride(b.stride())") TruffleString.CompactionLevel compactionB, @Cached(value="compactionB") TruffleString.CompactionLevel cachedCompactionB, @Cached InlinedConditionProfile oneLength) {
            int strideB = cachedCompactionB.getStride();
            int strideA = cachedCompactionA.getStride();
            return RawIndexOfStringNode.runIndexOf(node, arrayA, offsetA, a.length(), strideA, arrayB, offsetB, b.length(), strideB, fromIndex, toIndex, mask, oneLength);
        }

        static int runIndexOf(Node node, byte[] arrayA, long offsetA, int lengthA, int strideA, byte[] arrayB, long offsetB, int lengthB, int strideB, int fromIndex, int toIndex, byte[] mask, InlinedConditionProfile oneLength) {
            if (oneLength.profile(node, lengthB == 1)) {
                int b0 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, 0);
                int mask0 = mask == null ? 0 : TStringOps.readFromByteArray(mask, strideB, 0);
                return TStringOps.indexOfCodePointWithOrMaskWithStride(node, arrayA, offsetA, strideA, fromIndex, toIndex, b0, mask0);
            }
            return TStringOps.indexOfStringWithOrMaskWithStride(node, arrayA, offsetA, lengthA, strideA, arrayB, offsetB, lengthB, strideB, fromIndex, toIndex, mask);
        }
    }

    static abstract class RawLastIndexOfCodePointNode
    extends AbstractInternalNode {
        RawLastIndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, int var8);

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static int cached(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codepoint, int fromIndex, int toIndex, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction) {
            return TStringOps.lastIndexOfCodePointWithOrMaskWithStride(node, arrayA, offsetA, cachedCompaction.getStride(), fromIndex, toIndex, codepoint, 0);
        }
    }

    static abstract class RawIndexOfCodePointNode
    extends AbstractInternalNode {
        RawIndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, int var8);

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static int cached(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codepoint, int fromIndex, int toIndex, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction) {
            return TStringOps.indexOfCodePointWithStride(node, arrayA, offsetA, cachedCompaction.getStride(), fromIndex, toIndex, codepoint);
        }
    }

    static abstract class IndexOfAnyIntNode
    extends AbstractInternalNode {
        IndexOfAnyIntNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, int[] var8);

        @Specialization(guards={"isStride0(a)", "values.length == 1"})
        int stride0(AbstractTruffleString a, byte[] arrayA, long offsetA, int fromIndex, int maxIndex, int[] values) {
            return TStringOps.indexOfAnyInt(this, arrayA, offsetA, 0, fromIndex, maxIndex, values);
        }

        @Specialization(guards={"isStride0(a)", "values.length > 1"})
        int stride0MultiValue(AbstractTruffleString a, byte[] arrayA, long offsetA, int fromIndex, int maxIndex, int[] values) {
            return TStringOps.indexOfAnyInt(this, arrayA, offsetA, 0, fromIndex, maxIndex, TStringOpsNodes.removeValuesGreaterThan((Node)this, values, 255));
        }

        @Specialization(guards={"isStride1(a)", "values.length == 1"})
        int stride1(AbstractTruffleString a, byte[] arrayA, long offsetA, int fromIndex, int maxIndex, int[] values) {
            return TStringOps.indexOfAnyInt(this, arrayA, offsetA, 1, fromIndex, maxIndex, values);
        }

        @Specialization(guards={"isStride1(a)", "values.length > 1"})
        int stride1MultiValue(AbstractTruffleString a, byte[] arrayA, long offsetA, int fromIndex, int maxIndex, int[] values) {
            return TStringOps.indexOfAnyInt(this, arrayA, offsetA, 1, fromIndex, maxIndex, TStringOpsNodes.removeValuesGreaterThan((Node)this, values, 65535));
        }

        @Specialization(guards={"isStride2(a)"})
        int stride2(AbstractTruffleString a, byte[] arrayA, long offsetA, int fromIndex, int maxIndex, int[] values) {
            return TStringOps.indexOfAnyInt(this, arrayA, offsetA, 2, fromIndex, maxIndex, values);
        }
    }

    static abstract class IndexOfAnyCharUTF16Node
    extends AbstractInternalNode {
        IndexOfAnyCharUTF16Node() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, char[] var8);

        @Specialization(guards={"isStride0(a)", "values.length == 1"})
        int stride0(AbstractTruffleString a, byte[] arrayA, long offsetA, int fromIndex, int maxIndex, char[] values) {
            return TStringOps.indexOfAnyChar(this, arrayA, offsetA, 0, fromIndex, maxIndex, values);
        }

        @Specialization(guards={"isStride0(a)", "values.length > 1"})
        int stride0MultiValue(AbstractTruffleString a, byte[] arrayA, long offsetA, int fromIndex, int maxIndex, char[] values) {
            return TStringOps.indexOfAnyChar(this, arrayA, offsetA, 0, fromIndex, maxIndex, TStringOpsNodes.removeValuesGreaterThan((Node)this, values, 255));
        }

        @Specialization(guards={"isStride1(a)"})
        int stride1(AbstractTruffleString a, byte[] arrayA, long offsetA, int fromIndex, int maxIndex, char[] values) {
            return TStringOps.indexOfAnyChar(this, arrayA, offsetA, 1, fromIndex, maxIndex, values);
        }
    }
}

