/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import java.lang.ref.Reference;
import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.AbstractPublicNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.AbstractTruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.JCodings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.MutableTruffleStringFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TSCodeRange;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringInternalNodes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringOps;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringUnsafe;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TranscodingErrorHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;

public final class MutableTruffleString
extends AbstractTruffleString {
    private MutableTruffleString(Object data, int offset, int length, int stride, int codePointLength, TruffleString.Encoding encoding) {
        super(data, offset, length, stride, encoding, 0, codePointLength, TSCodeRange.getUnknownCodeRangeForEncoding(encoding.id), 0);
        assert (data instanceof byte[] || data instanceof AbstractTruffleString.NativePointer);
    }

    private static MutableTruffleString create(Object data, int offset, int length, TruffleString.Encoding encoding) {
        int codePointLength = encoding.isFixedWidth() ? (encoding.isSupported() ? length : length / JCodings.getInstance().minLength(encoding)) : -1;
        MutableTruffleString string = new MutableTruffleString(data, offset, length, encoding.naturalStride, codePointLength, encoding);
        if (AbstractTruffleString.DEBUG_ALWAYS_CREATE_JAVA_STRING) {
            string.toJavaStringUncached();
        }
        return string;
    }

    void invalidateCachedAttributes() {
        boolean isFixedWidth = TruffleString.Encoding.isFixedWidth(this.encoding());
        if (!isFixedWidth) {
            this.invalidateCodePointLength();
        }
        this.invalidateCodeRange();
        this.invalidateHashCode();
        if (this.data() instanceof AbstractTruffleString.NativePointer) {
            ((AbstractTruffleString.NativePointer)this.data()).invalidateCachedByteArray();
        }
    }

    public void notifyExternalMutation() {
        this.invalidateCachedAttributes();
    }

    @CompilerDirectives.TruffleBoundary
    public static MutableTruffleString fromByteArrayUncached(byte[] value, int byteOffset, int byteLength, TruffleString.Encoding encoding, boolean copy) {
        return FromByteArrayNode.getUncached().execute(value, byteOffset, byteLength, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public static MutableTruffleString fromNativePointerUncached(Object pointerObject, int byteOffset, int byteLength, TruffleString.Encoding encoding, boolean copy) {
        return FromNativePointerNode.getUncached().execute(pointerObject, byteOffset, byteLength, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public void writeByteUncached(int byteIndex, byte value, TruffleString.Encoding expectedEncoding) {
        WriteByteNode.getUncached().execute(this, byteIndex, value, expectedEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public MutableTruffleString concatUncached(AbstractTruffleString b, TruffleString.Encoding expectedEncoding) {
        return ConcatNode.getUncached().execute(this, b, expectedEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public MutableTruffleString substringUncached(int byteOffset, int byteLength, TruffleString.Encoding expectedEncoding) {
        return SubstringNode.getUncached().execute(this, byteOffset, byteLength, expectedEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public MutableTruffleString substringByteIndexUncached(int byteOffset, int byteLength, TruffleString.Encoding expectedEncoding) {
        return SubstringByteIndexNode.getUncached().execute(this, byteOffset, byteLength, expectedEncoding);
    }

    static MutableTruffleString createCopying(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, InlinedConditionProfile managedProfileA, InlinedConditionProfile nativeProfileA) {
        return MutableTruffleString.createCopying(node, a, encoding, a.byteLength(encoding), managedProfileA, nativeProfileA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MutableTruffleString createCopying(Node node, AbstractTruffleString a, TruffleString.Encoding targetEncoding, int byteLength, InlinedConditionProfile managedProfileA, InlinedConditionProfile nativeProfileA) {
        byte strideB = targetEncoding.naturalStride;
        int lengthB = byteLength >> strideB;
        Object dataA = a.data();
        try {
            long addOffsetA;
            byte[] arrayA;
            if (managedProfileA.profile(node, dataA instanceof byte[])) {
                arrayA = (byte[])dataA;
                addOffsetA = TStringUnsafe.byteArrayBaseOffset();
            } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                arrayA = null;
                addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
            } else {
                arrayA = a.materializeLazy(node, dataA);
                addOffsetA = TStringUnsafe.byteArrayBaseOffset();
            }
            long offsetA = (long)a.offset() + addOffsetA;
            byte[] array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, a.length(), a.stride(), lengthB, strideB);
            MutableTruffleString mutableTruffleString = MutableTruffleString.create(array, 0, lengthB, targetEncoding);
            return mutableTruffleString;
        }
        finally {
            Reference.reachabilityFence(dataA);
        }
    }

    public static abstract class FromByteArrayNode
    extends AbstractPublicNode {
        FromByteArrayNode() {
        }

        public abstract MutableTruffleString execute(byte[] var1, int var2, int var3, TruffleString.Encoding var4, boolean var5);

        @Specialization
        static MutableTruffleString fromByteArray(byte[] value, int byteOffset, int byteLength, TruffleString.Encoding enc, boolean copy) {
            int offset;
            byte[] array;
            AbstractTruffleString.checkArrayRange(value, byteOffset, byteLength);
            AbstractTruffleString.checkByteLength(byteLength, enc);
            if (copy) {
                array = Arrays.copyOfRange(value, byteOffset, byteOffset + byteLength);
                offset = 0;
            } else {
                array = value;
                offset = byteOffset;
            }
            return MutableTruffleString.create(array, offset, byteLength >> enc.naturalStride, enc);
        }

        @NeverDefault
        public static FromByteArrayNode create() {
            return MutableTruffleStringFactory.FromByteArrayNodeGen.create();
        }

        public static FromByteArrayNode getUncached() {
            return MutableTruffleStringFactory.FromByteArrayNodeGen.getUncached();
        }
    }

    public static abstract class FromNativePointerNode
    extends AbstractPublicNode {
        FromNativePointerNode() {
        }

        public abstract MutableTruffleString execute(Object var1, int var2, int var3, TruffleString.Encoding var4, boolean var5);

        @Specialization
        MutableTruffleString fromNativePointer(Object pointerObject, int byteOffset, int byteLength, TruffleString.Encoding enc, boolean copy, @Cached(value="createInteropLibrary()", uncached="getUncachedInteropLibrary()") Node interopLibrary) {
            int offset;
            Object data;
            AbstractTruffleString.checkByteLength(byteLength, enc);
            AbstractTruffleString.NativePointer nativePointer = AbstractTruffleString.NativePointer.create(this, pointerObject, interopLibrary);
            if (copy) {
                data = TStringOps.arraycopyOfWithStride(this, null, nativePointer.pointer + (long)byteOffset, byteLength, 0, byteLength, 0);
                offset = 0;
            } else {
                data = nativePointer;
                offset = byteOffset;
            }
            return MutableTruffleString.create(data, offset, byteLength >> enc.naturalStride, enc);
        }

        @NeverDefault
        public static FromNativePointerNode create() {
            return MutableTruffleStringFactory.FromNativePointerNodeGen.create();
        }

        public static FromNativePointerNode getUncached() {
            return MutableTruffleStringFactory.FromNativePointerNodeGen.getUncached();
        }
    }

    public static abstract class WriteByteNode
    extends AbstractPublicNode {
        WriteByteNode() {
        }

        public abstract void execute(MutableTruffleString var1, int var2, byte var3, TruffleString.Encoding var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        void writeByte(MutableTruffleString a, int byteIndex, byte value, TruffleString.Encoding expectedEncoding, @Cached InlinedConditionProfile managedProfileA) {
            a.checkEncoding(expectedEncoding);
            int byteLength = a.length() << a.stride();
            TruffleString.boundsCheckI(byteIndex, byteLength);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                }
                long offsetA = (long)a.offset() + addOffsetA;
                TStringOps.writeS0(arrayA, offsetA, byteLength, byteIndex, value);
                if (!TSCodeRange.is7Bit(a.codeRange()) || value < 0) {
                    a.invalidateCachedAttributes();
                }
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static WriteByteNode create() {
            return MutableTruffleStringFactory.WriteByteNodeGen.create();
        }

        public static WriteByteNode getUncached() {
            return MutableTruffleStringFactory.WriteByteNodeGen.getUncached();
        }
    }

    public static abstract class ConcatNode
    extends AbstractPublicNode {
        ConcatNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        final MutableTruffleString concat(AbstractTruffleString a, AbstractTruffleString b, TruffleString.Encoding expectedEncoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB, @Cached TStringInternalNodes.ConcatMaterializeBytesNode materializeBytesNode, @Cached InlinedBranchProfile outOfMemoryProfile) {
            a.checkEncoding(expectedEncoding);
            b.checkEncoding(expectedEncoding);
            int length = TruffleString.ConcatNode.addByteLengths(this, a, b, expectedEncoding.naturalStride, outOfMemoryProfile);
            int offset = 0;
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                if (managedProfileB.profile(this, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(this, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(this, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                long offsetB = (long)b.offset() + addOffsetB;
                byte[] array = materializeBytesNode.execute(this, a, arrayA, offsetA, b, arrayB, offsetB, expectedEncoding, length, expectedEncoding.naturalStride);
                MutableTruffleString mutableTruffleString = MutableTruffleString.create(array, offset, length, expectedEncoding);
                return mutableTruffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }

        @NeverDefault
        public static ConcatNode create() {
            return MutableTruffleStringFactory.ConcatNodeGen.create();
        }

        public static ConcatNode getUncached() {
            return MutableTruffleStringFactory.ConcatNodeGen.getUncached();
        }
    }

    public static abstract class SubstringNode
    extends AbstractPublicNode {
        SubstringNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, int var2, int var3, TruffleString.Encoding var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        MutableTruffleString substring(AbstractTruffleString a, int fromIndex, int length, TruffleString.Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.CodePointIndexToRawNode translateIndexNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            a.checkEncoding(encoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(this, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(this, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(this, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                a.boundsCheckRegion(this, arrayA, offsetA, fromIndex, length, encoding, getCodePointLengthNode);
                int codeRangeA = getCodeRangeANode.execute(this, a, arrayA, offsetA, encoding);
                int fromIndexRaw = translateIndexNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, 0, fromIndex, length == 0);
                int lengthRaw = translateIndexNode.execute(this, a, arrayA, offsetA, codeRangeA, encoding, fromIndexRaw, length, true);
                byte stride = encoding.naturalStride;
                MutableTruffleString mutableTruffleString = SubstringByteIndexNode.createSubstring(a, fromIndexRaw << stride, lengthRaw << stride, encoding, copyToByteArrayNode);
                return mutableTruffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static SubstringNode create() {
            return MutableTruffleStringFactory.SubstringNodeGen.create();
        }

        public static SubstringNode getUncached() {
            return MutableTruffleStringFactory.SubstringNodeGen.getUncached();
        }
    }

    public static abstract class SubstringByteIndexNode
    extends AbstractPublicNode {
        SubstringByteIndexNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, int var2, int var3, TruffleString.Encoding var4);

        @Specialization
        static MutableTruffleString substringByteIndex(AbstractTruffleString a, int byteOffset, int byteLength, TruffleString.Encoding expectedEncoding, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            return SubstringByteIndexNode.createSubstring(a, byteOffset, byteLength, expectedEncoding, copyToByteArrayNode);
        }

        static MutableTruffleString createSubstring(AbstractTruffleString a, int byteOffset, int byteLength, TruffleString.Encoding expectedEncoding, TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            a.checkEncoding(expectedEncoding);
            AbstractTruffleString.checkByteLength(byteLength, expectedEncoding);
            a.boundsCheckRegionRaw(AbstractTruffleString.rawIndex(byteOffset, expectedEncoding), AbstractTruffleString.rawIndex(byteLength, expectedEncoding));
            byte[] array = new byte[byteLength];
            copyToByteArrayNode.execute(a, byteOffset, array, 0, byteLength, expectedEncoding);
            return MutableTruffleString.create(array, 0, byteLength >> expectedEncoding.naturalStride, expectedEncoding);
        }

        @NeverDefault
        public static SubstringByteIndexNode create() {
            return MutableTruffleStringFactory.SubstringByteIndexNodeGen.create();
        }

        public static SubstringByteIndexNode getUncached() {
            return MutableTruffleStringFactory.SubstringByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class ForceEncodingNode
    extends AbstractPublicNode {
        ForceEncodingNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, TruffleString.Encoding var2, TruffleString.Encoding var3);

        @Specialization(guards={"a.isCompatibleToIntl(targetEncoding)"})
        static MutableTruffleString compatible(MutableTruffleString a, TruffleString.Encoding expectedEncoding, TruffleString.Encoding targetEncoding) {
            a.checkEncoding(expectedEncoding);
            return a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!a.isCompatibleToIntl(targetEncoding) || a.isImmutable()"})
        static MutableTruffleString reinterpret(AbstractTruffleString a, TruffleString.Encoding expectedEncoding, TruffleString.Encoding targetEncoding, @Bind Node node, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA) {
            a.checkEncoding(expectedEncoding);
            int byteLength = a.byteLength(expectedEncoding);
            AbstractTruffleString.checkByteLength(byteLength, targetEncoding);
            Object dataA = a.data();
            try {
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(node, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                byte[] array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, a.length(), a.stride(), byteLength >> expectedEncoding.naturalStride, expectedEncoding.naturalStride);
                MutableTruffleString mutableTruffleString = MutableTruffleString.create(array, 0, byteLength >> targetEncoding.naturalStride, targetEncoding);
                return mutableTruffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @NeverDefault
        public static ForceEncodingNode create() {
            return MutableTruffleStringFactory.ForceEncodingNodeGen.create();
        }

        public static ForceEncodingNode getUncached() {
            return MutableTruffleStringFactory.ForceEncodingNodeGen.getUncached();
        }
    }

    public static abstract class SwitchEncodingNode
    extends AbstractPublicNode {
        SwitchEncodingNode() {
        }

        public final MutableTruffleString execute(AbstractTruffleString a, TruffleString.Encoding encoding) {
            return this.execute(a, encoding, TranscodingErrorHandler.DEFAULT);
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, TruffleString.Encoding var2, TranscodingErrorHandler var3);

        @Specialization(guards={"a.isCompatibleToIntl(encoding)"})
        static MutableTruffleString compatibleMutable(MutableTruffleString a, TruffleString.Encoding encoding, TranscodingErrorHandler errorHandler) {
            return a;
        }

        @Specialization(guards={"!a.isCompatibleToIntl(encoding) || a.isImmutable()"})
        static MutableTruffleString transcodeAndCopy(AbstractTruffleString a, TruffleString.Encoding encoding, TranscodingErrorHandler errorHandler, @Bind Node node, @Cached TruffleString.InternalSwitchEncodingNode switchEncodingNode, @Cached AsMutableTruffleStringNode asMutableTruffleStringNode) {
            TruffleString switched = switchEncodingNode.execute(node, a, encoding, errorHandler);
            return asMutableTruffleStringNode.execute(switched, encoding);
        }

        @NeverDefault
        public static SwitchEncodingNode create() {
            return MutableTruffleStringFactory.SwitchEncodingNodeGen.create();
        }

        public static SwitchEncodingNode getUncached() {
            return MutableTruffleStringFactory.SwitchEncodingNodeGen.getUncached();
        }
    }

    public static abstract class AsManagedNode
    extends AbstractPublicNode {
        AsManagedNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, TruffleString.Encoding var2);

        @Specialization(guards={"!a.isNative()"})
        static MutableTruffleString mutable(MutableTruffleString a, TruffleString.Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            return a;
        }

        @Specialization(guards={"a.isNative() || a.isImmutable()"})
        static MutableTruffleString fromTruffleString(AbstractTruffleString a, TruffleString.Encoding expectedEncoding, @Bind Node node, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA) {
            return MutableTruffleString.createCopying(node, a, expectedEncoding, managedProfileA, nativeProfileA);
        }

        @NeverDefault
        public static AsManagedNode create() {
            return MutableTruffleStringFactory.AsManagedNodeGen.create();
        }

        public static AsManagedNode getUncached() {
            return MutableTruffleStringFactory.AsManagedNodeGen.getUncached();
        }
    }

    public static abstract class AsMutableTruffleStringNode
    extends AbstractPublicNode {
        AsMutableTruffleStringNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, TruffleString.Encoding var2);

        @Specialization
        static MutableTruffleString mutable(MutableTruffleString a, TruffleString.Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            return a;
        }

        @Specialization
        static MutableTruffleString fromTruffleString(TruffleString a, TruffleString.Encoding expectedEncoding, @Bind Node node, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA) {
            return MutableTruffleString.createCopying(node, a, expectedEncoding, managedProfileA, nativeProfileA);
        }

        @NeverDefault
        public static AsMutableTruffleStringNode create() {
            return MutableTruffleStringFactory.AsMutableTruffleStringNodeGen.create();
        }

        public static AsMutableTruffleStringNode getUncached() {
            return MutableTruffleStringFactory.AsMutableTruffleStringNodeGen.getUncached();
        }
    }
}

