/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DebugCounter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtLayout;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtLocations;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LayoutImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Location;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Property;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ShapeExt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ShapeImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Transition;

abstract class Obsolescence {
    private static final DebugCounter mergedShapeCount = DebugCounter.create("Compatible shapes merged");

    private Obsolescence() {
    }

    static boolean isSameProperty(Property thiz, Property other) {
        return other.getKey().equals(thiz.getKey()) && other.getFlags() == thiz.getFlags();
    }

    public static boolean isRelatedByUpcast(ShapeImpl thiz, ShapeImpl other) {
        CompilerAsserts.neverPartOfCompilation();
        return Obsolescence.tryMergeShapes(thiz, other, true) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShapeImpl tryObsoleteDowncast(ShapeImpl thiz, ShapeImpl other) {
        CompilerAsserts.neverPartOfCompilation();
        Supplier<ShapeImpl> mergeResult = Obsolescence.tryMergeShapes(thiz, other, false);
        if (mergeResult != null) {
            Object object = thiz.getMutex();
            synchronized (object) {
                return mergeResult.get();
            }
        }
        return null;
    }

    private static Supplier<ShapeImpl> tryMergeShapes(ShapeImpl thiz, ShapeImpl other, boolean checkOnly) {
        CompilerAsserts.neverPartOfCompilation();
        if (thiz.getLayout() != other.getLayout()) {
            return null;
        }
        if (thiz.getRoot() != other.getRoot()) {
            return null;
        }
        if (thiz.isShared() || other.isShared()) {
            return null;
        }
        if (thiz.getSharedData() != other.getSharedData()) {
            return null;
        }
        if (thiz.getDepth() >= ExtLayout.MaxMergeDepth) {
            return null;
        }
        if (thiz.getDepth() != other.getDepth()) {
            return null;
        }
        if (thiz.getPropertyMap().size() != other.getPropertyMap().size()) {
            return null;
        }
        LayoutImpl layout = thiz.getLayout();
        ShapeImpl thisParent = thiz;
        ShapeImpl otherParent = other;
        Supplier<ShapeImpl> lastMergeResult = null;
        int diff = 0;
        for (int i = 0; i < ExtLayout.MaxMergeDepth; ++i) {
            if (thisParent == otherParent) {
                return lastMergeResult;
            }
            if (thisParent.getParent() == null || otherParent.getParent() == null) {
                return null;
            }
            if (!thisParent.isValid() || !otherParent.isValid()) {
                return null;
            }
            if (thisParent.getFlagsInternal() != otherParent.getFlagsInternal()) {
                return null;
            }
            if (thisParent.getDynamicType() != otherParent.getDynamicType()) {
                return null;
            }
            assert (thisParent.getDepth() == otherParent.getDepth());
            Property thisLast = thisParent.getLastProperty();
            Property otherLast = otherParent.getLastProperty();
            if (thisLast == null || otherLast == null) {
                return null;
            }
            if (!thisLast.equals(otherLast)) {
                if (!Obsolescence.isSameProperty(thisLast, otherLast)) {
                    return null;
                }
                assert (!thisLast.getLocation().equals(otherLast.getLocation()));
                if (!Obsolescence.isLocationEquivalent(thisLast.getLocation(), otherLast.getLocation())) {
                    if (++diff > ExtLayout.MaxMergeDiff) {
                        return null;
                    }
                    if (!Obsolescence.isLocationCompatible(layout, thisLast.getLocation(), otherLast.getLocation())) {
                        return null;
                    }
                    lastMergeResult = checkOnly ? () -> null : Obsolescence.makeMergeResult(thiz, other, thisParent, otherParent, thisLast, otherLast);
                }
            }
            thisParent = thisParent.getParent();
            otherParent = otherParent.getParent();
        }
        return null;
    }

    private static Supplier<ShapeImpl> makeMergeResult(ShapeImpl thiz, ShapeImpl other, ShapeImpl thisParent, ShapeImpl otherParent, Property thisProperty, Property otherProperty) {
        CompilerAsserts.neverPartOfCompilation();
        assert (Obsolescence.isSameProperty(thisProperty, otherProperty));
        return () -> {
            ShapeImpl succ = null;
            if (thiz.isValid() && other.isValid() && thisParent.isValid() && otherParent.isValid()) {
                LayoutImpl layout = thisParent.getLayout();
                if (Obsolescence.isLocationAssignableFrom(layout, thisProperty.getLocation(), otherProperty.getLocation())) {
                    Obsolescence.markObsolete(otherParent, thisParent, otherProperty, thisProperty);
                    assert (!otherParent.isValid());
                    succ = thiz;
                } else if (Obsolescence.isLocationAssignableFrom(layout, otherProperty.getLocation(), thisProperty.getLocation())) {
                    Obsolescence.markObsolete(thisParent, otherParent, thisProperty, otherProperty);
                    assert (!thisParent.isValid());
                    succ = other;
                }
            }
            if (succ != null) {
                mergedShapeCount.inc();
            }
            return succ;
        };
    }

    public static boolean isLocationCompatible(LayoutImpl layout, Location thisLoc, Location otherLoc) {
        return Obsolescence.isLocationAssignableFrom(layout, thisLoc, otherLoc) || Obsolescence.isLocationAssignableFrom(layout, otherLoc, thisLoc);
    }

    protected static boolean isLocationEquivalent(Location thisLoc, Location otherLoc) {
        if (thisLoc instanceof ExtLocations.IntLocation) {
            return otherLoc instanceof ExtLocations.IntLocation;
        }
        if (thisLoc instanceof ExtLocations.DoubleLocation) {
            return otherLoc instanceof ExtLocations.DoubleLocation && ((ExtLocations.DoubleLocation)((Object)thisLoc)).isImplicitCastIntToDouble() && ((ExtLocations.DoubleLocation)((Object)otherLoc)).isImplicitCastIntToDouble();
        }
        if (thisLoc instanceof ExtLocations.LongLocation) {
            return otherLoc instanceof ExtLocations.LongLocation && ((ExtLocations.LongLocation)((Object)thisLoc)).isImplicitCastIntToLong() && ((ExtLocations.LongLocation)((Object)otherLoc)).isImplicitCastIntToLong();
        }
        if (thisLoc instanceof ExtLocations.BooleanLocation) {
            return otherLoc instanceof ExtLocations.BooleanLocation;
        }
        if (thisLoc instanceof ExtLocations.ObjectLocation) {
            return otherLoc instanceof ExtLocations.ObjectLocation && ((ExtLocations.ObjectLocation)((Object)thisLoc)).getType() == ((ExtLocations.ObjectLocation)((Object)otherLoc)).getType() && ((ExtLocations.ObjectLocation)((Object)thisLoc)).isNonNull() == ((ExtLocations.ObjectLocation)((Object)otherLoc)).isNonNull();
        }
        if (thisLoc.isValue()) {
            return thisLoc.equals(otherLoc);
        }
        throw ExtLocations.shouldNotReachHere();
    }

    protected static boolean isLocationAssignableFrom(LayoutImpl layout, Location destination, Location source) {
        if (destination.isFinal() && !source.isFinal()) {
            return false;
        }
        if (destination instanceof ExtLocations.IntLocation) {
            return source instanceof ExtLocations.IntLocation;
        }
        if (destination instanceof ExtLocations.DoubleLocation) {
            return source instanceof ExtLocations.DoubleLocation || layout.isAllowedIntToDouble() && source instanceof ExtLocations.IntLocation;
        }
        if (destination instanceof ExtLocations.LongLocation) {
            return source instanceof ExtLocations.LongLocation || layout.isAllowedIntToLong() && source instanceof ExtLocations.IntLocation;
        }
        if (destination instanceof ExtLocations.BooleanLocation) {
            return source instanceof ExtLocations.BooleanLocation;
        }
        if (destination instanceof ExtLocations.ObjectLocation) {
            ExtLocations.ObjectLocation dstObjLoc = (ExtLocations.ObjectLocation)((Object)destination);
            if (source instanceof ExtLocations.ObjectLocation) {
                return !(dstObjLoc.getType() != Object.class && !dstObjLoc.getType().isAssignableFrom(((ExtLocations.ObjectLocation)((Object)source)).getType()) || dstObjLoc.isNonNull() && !((ExtLocations.ObjectLocation)((Object)source)).isNonNull());
            }
            if (source instanceof ExtLocations.TypedLocation) {
                return dstObjLoc.getType() == Object.class;
            }
            return false;
        }
        if (destination.isValue()) {
            return destination.equals(source);
        }
        throw ExtLocations.shouldNotReachHere();
    }

    public static void markObsolete(ShapeImpl oldShape, ShapeImpl obsoletedBy, Property oldProperty, Property newProperty) {
        CompilerAsserts.neverPartOfCompilation();
        assert (oldProperty != newProperty);
        assert (!oldShape.isShared());
        Obsolescence.markObsolete(oldShape, obsoletedBy);
    }

    private static void markObsolete(ShapeImpl oldShape, ShapeImpl obsoletedBy) {
        CompilerAsserts.neverPartOfCompilation();
        if (!oldShape.isValid()) {
            Obsolescence.setObsoletedBy(oldShape, obsoletedBy);
            return;
        }
        Obsolescence.setObsoletedBy(oldShape, obsoletedBy);
        Obsolescence.invalidateShape(oldShape);
        ArrayDeque workQueue = new ArrayDeque(4);
        Obsolescence.addTransitionsToWorkQueue(oldShape, workQueue);
        while (!workQueue.isEmpty()) {
            ShapeImpl childOldShape = (ShapeImpl)workQueue.pop();
            if (!childOldShape.isValid() || childOldShape.isShared()) continue;
            Obsolescence.invalidateShape(childOldShape);
            Obsolescence.addTransitionsToWorkQueue(childOldShape, workQueue);
        }
    }

    private static void addTransitionsToWorkQueue(ShapeImpl shape, final Deque<? super ShapeImpl> workQueue) {
        shape.forEachTransition(new BiConsumer<Transition, ShapeImpl>(){

            @Override
            public void accept(Transition t, ShapeImpl s) {
                if (Obsolescence.isDirectTransition(t)) {
                    workQueue.add(s);
                }
            }
        });
    }

    private static boolean isDirectTransition(Transition transition) {
        return transition.isDirect();
    }

    static void invalidateShape(ShapeImpl shape) {
        shape.invalidateValidAssumption();
    }

    static void setObsoletedBy(ShapeImpl shape, ShapeImpl successorShape) {
        ((ShapeExt)shape).setSuccessorShape(successorShape);
        ((ShapeExt)successorShape).addPredecessorShape(shape);
    }
}

