/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Assumption;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DebugCounter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtAllocator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtLayout;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtLocation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.FieldInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.IncompatibleLocationException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Location;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LocationImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.UnsafeAccess;
import sun.misc.Unsafe;

abstract class ExtLocations {
    static final int INT_FIELD_SLOT_SIZE = 1;
    static final int INT_ARRAY_SLOT_SIZE = 1;
    static final int DOUBLE_ARRAY_SLOT_SIZE = 2;
    static final int LONG_ARRAY_SLOT_SIZE = 2;
    static final int OBJECT_SLOT_SIZE = 1;
    static final int MAX_DYNAMIC_FIELDS = 1000;

    ExtLocations() {
    }

    static int getLocationOrdinal(ExtLocation loc) {
        return loc.getOrdinal();
    }

    static RuntimeException shouldNotReachHere() {
        CompilerDirectives.transferToInterpreter();
        throw new IllegalStateException();
    }

    static final class TypeAssumption {
        final Assumption assumption;
        final Class<? extends Object> type;
        final boolean nonNull;
        static final TypeAssumption ANY = new TypeAssumption(Assumption.ALWAYS_VALID, Object.class, false);

        TypeAssumption(Assumption assumption, Class<? extends Object> type, boolean nonNull) {
            this.assumption = assumption;
            this.type = type;
            this.nonNull = nonNull;
        }

        public Assumption getAssumption() {
            return this.assumption;
        }

        public String toString() {
            return TypeAssumption.toString(this.type, this.nonNull) + (this.assumption.isValid() ? "" : "(invalid)");
        }

        static String toString(Class<?> type, boolean nonNull) {
            if (type == Object.class && !nonNull) {
                return "ANY";
            }
            return (nonNull ? "!" : "") + type.getTypeName();
        }
    }

    static final class LongArrayLocation
    extends AbstractPrimitiveArrayLocation
    implements LongLocation {
        protected final boolean allowInt;

        LongArrayLocation(int index, boolean allowInt, Assumption finalAssumption) {
            super(index, finalAssumption);
            this.allowInt = allowInt;
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.getLong(store, guard);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw LongArrayLocation.incompatibleLocation();
            }
            this.setLong(store, this.longValue(value), guard, init);
        }

        protected long longValue(Object value) {
            if (!this.allowInt || value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            throw ExtLocations.shouldNotReachHere();
        }

        @Override
        public long getLong(DynamicObject store, boolean guard) {
            return UnsafeAccess.unsafeGetLong(LongArrayLocation.getArray(store, guard), this.getOffset(), guard, this);
        }

        protected void setLongInternal(DynamicObject store, long value, boolean guard) {
            UnsafeAccess.unsafePutLong(LongArrayLocation.getArray(store, guard), this.getOffset(), value, this);
        }

        protected long getFinalLong(DynamicObject store, boolean condition) {
            return UnsafeAccess.unsafeGetFinalLong(LongArrayLocation.getArray(store, condition), this.getOffset(), condition, this);
        }

        @Override
        public void setLong(DynamicObject store, long value, boolean guard, boolean init) {
            if (!init) {
                this.maybeInvalidateFinalAssumption();
            }
            this.setLongInternal(store, value, guard);
        }

        @Override
        public boolean canStore(Object value) {
            return value instanceof Long || this.allowInt && value instanceof Integer;
        }

        @Override
        public long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, LongArrayLocation.checkShape(store, shape));
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public int primitiveArrayCount() {
            return 2;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveArray(this.index, 2);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((LongArrayLocation)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToLong() {
            return this.allowInt;
        }

        @Override
        protected int getBytes() {
            return 8;
        }
    }

    static final class LongFieldLocation
    extends AbstractPrimitiveFieldLocation
    implements LongLocation {
        protected final boolean allowInt;
        protected final byte slotSize;

        LongFieldLocation(int index, FieldInfo field, boolean allowInt, int slotSize, Assumption finalAssumption) {
            super(index, field, finalAssumption);
            this.allowInt = allowInt;
            assert (slotSize >= 1 && slotSize <= 2);
            this.slotSize = (byte)slotSize;
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.getLong(store, guard);
        }

        @Override
        public long getLong(DynamicObject store, boolean guard) {
            if (ExtLayout.UseVarHandle) {
                return this.field.varHandle().get(store);
            }
            this.field.receiverCheck(store);
            return UnsafeAccess.unsafeGetLong(store, this.getOffset(), guard, this);
        }

        @Override
        public void setLong(DynamicObject store, long value, boolean guard, boolean init) {
            if (!init) {
                this.maybeInvalidateFinalAssumption();
            }
            this.setLongInternal(store, value);
        }

        protected void setLongInternal(DynamicObject store, long value) {
            if (ExtLayout.UseVarHandle) {
                this.field.varHandle().set(store, value);
                return;
            }
            this.field.receiverCheck(store);
            UnsafeAccess.unsafePutLong(store, this.getOffset(), value, this);
        }

        protected long getFinalLong(DynamicObject store, boolean condition) {
            if (ExtLayout.UseVarHandle) {
                return this.field.varHandle().get(store);
            }
            this.field.receiverCheck(store);
            return UnsafeAccess.unsafeGetFinalLong(store, this.getOffset(), condition, this);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw LongFieldLocation.incompatibleLocation();
            }
            this.setLong(store, this.longValue(value), guard, init);
        }

        protected long longValue(Object value) {
            if (!this.allowInt || value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            throw ExtLocations.shouldNotReachHere();
        }

        @Override
        public boolean canStore(Object value) {
            return value instanceof Long || this.allowInt && value instanceof Integer;
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public int primitiveFieldCount() {
            return this.slotSize;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), this.slotSize);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((LongFieldLocation)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToLong() {
            return this.allowInt;
        }
    }

    static final class DoubleArrayLocation
    extends AbstractPrimitiveArrayLocation
    implements DoubleLocation {
        protected final boolean allowInt;

        DoubleArrayLocation(int index, boolean allowInt, Assumption finalAssumption) {
            super(index, finalAssumption);
            this.allowInt = allowInt;
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.getDouble(store, guard);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw DoubleArrayLocation.incompatibleLocation();
            }
            this.setDouble(store, this.doubleValue(value), guard, init);
        }

        protected double doubleValue(Object value) {
            if (!this.allowInt || value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).doubleValue();
            }
            throw ExtLocations.shouldNotReachHere();
        }

        @Override
        public double getDouble(DynamicObject store, boolean guard) {
            return UnsafeAccess.unsafeGetDouble(DoubleArrayLocation.getArray(store, guard), this.getOffset(), guard, this);
        }

        protected void setDoubleInternal(DynamicObject store, double value, boolean guard) {
            UnsafeAccess.unsafePutDouble(DoubleArrayLocation.getArray(store, guard), this.getOffset(), value, this);
        }

        protected double getFinalDouble(DynamicObject store, boolean condition) {
            return UnsafeAccess.unsafeGetFinalDouble(DoubleArrayLocation.getArray(store, condition), this.getOffset(), condition, this);
        }

        @Override
        public void setDouble(DynamicObject store, double value, boolean guard, boolean init) {
            if (!init) {
                this.maybeInvalidateFinalAssumption();
            }
            this.setDoubleInternal(store, value, guard);
        }

        @Override
        public boolean canStore(Object value) {
            return value instanceof Double || this.allowInt && value instanceof Integer;
        }

        @Override
        public Class<Double> getType() {
            return Double.TYPE;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveArray(this.index, 2);
        }

        @Override
        public int primitiveArrayCount() {
            return 2;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((DoubleArrayLocation)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToDouble() {
            return this.allowInt;
        }

        @Override
        protected int getBytes() {
            return 8;
        }
    }

    static final class IntArrayLocation
    extends AbstractPrimitiveArrayLocation
    implements IntLocation {
        IntArrayLocation(int index, Assumption finalAssumption) {
            super(index, finalAssumption);
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.getInt(store, guard);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw IntArrayLocation.incompatibleLocation();
            }
            this.setInt(store, (Integer)value, guard, init);
        }

        @Override
        public int getInt(DynamicObject store, boolean guard) {
            return UnsafeAccess.unsafeGetInt(IntArrayLocation.getArray(store, guard), this.getOffset(), guard, this);
        }

        protected void setIntInternal(DynamicObject store, int value, boolean guard) {
            UnsafeAccess.unsafePutInt(IntArrayLocation.getArray(store, guard), this.getOffset(), value, this);
        }

        protected int getFinalInt(DynamicObject store, boolean condition) {
            return UnsafeAccess.unsafeGetFinalInt(IntArrayLocation.getArray(store, condition), this.getOffset(), condition, this);
        }

        @Override
        public void setInt(DynamicObject store, int value, boolean guard, boolean init) {
            if (!init) {
                this.maybeInvalidateFinalAssumption();
            }
            this.setIntInternal(store, value, guard);
        }

        @Override
        public boolean canStore(Object value) {
            return value instanceof Integer;
        }

        @Override
        public Class<Integer> getType() {
            return Integer.TYPE;
        }

        @Override
        public int primitiveArrayCount() {
            return 1;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveArray(this.index, 1);
        }

        @Override
        protected int getBytes() {
            return 4;
        }
    }

    static abstract class AbstractPrimitiveArrayLocation
    extends InstanceLocation
    implements ArrayLocation {
        AbstractPrimitiveArrayLocation(int index, Assumption finalAssumption) {
            super(index, finalAssumption);
        }

        protected final long getOffset() {
            return (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)Unsafe.ARRAY_INT_INDEX_SCALE * (long)this.index;
        }

        protected abstract int getBytes();

        protected static Object getArray(DynamicObject store, boolean condition) {
            return UnsafeAccess.unsafeCast(store.getPrimitiveStore(), int[].class, condition, true, true);
        }
    }

    static final class BooleanFieldLocation
    extends AbstractPrimitiveFieldLocation
    implements BooleanLocation {
        BooleanFieldLocation(int index, FieldInfo field, Assumption finalAssumption) {
            super(index, field, finalAssumption);
            assert (field.type() == Integer.TYPE) : field;
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.getBoolean(store, guard);
        }

        @Override
        public boolean getBoolean(DynamicObject store, boolean guard) {
            if (ExtLayout.UseVarHandle) {
                return UnsafeAccess.booleanCast(this.field.varHandle().get(store));
            }
            this.field.receiverCheck(store);
            return UnsafeAccess.booleanCast(UnsafeAccess.unsafeGetInt(store, this.getOffset(), guard, this));
        }

        @Override
        public void setBoolean(DynamicObject store, boolean value, boolean guard, boolean init) {
            if (!init) {
                this.maybeInvalidateFinalAssumption();
            }
            this.setBooleanInternal(store, value);
        }

        protected void setBooleanInternal(DynamicObject store, boolean value) {
            if (ExtLayout.UseVarHandle) {
                this.field.varHandle().set(store, UnsafeAccess.intCast(value));
                return;
            }
            this.field.receiverCheck(store);
            UnsafeAccess.unsafePutInt(store, this.getOffset(), UnsafeAccess.intCast(value), this);
        }

        protected boolean getFinalBoolean(DynamicObject store, boolean condition) {
            if (ExtLayout.UseVarHandle) {
                return UnsafeAccess.booleanCast(this.field.varHandle().get(store));
            }
            this.field.receiverCheck(store);
            return UnsafeAccess.booleanCast(UnsafeAccess.unsafeGetFinalInt(store, this.getOffset(), condition, this));
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw BooleanFieldLocation.incompatibleLocation();
            }
            this.setBoolean(store, (Boolean)value, guard, init);
        }

        @Override
        public boolean canStore(Object value) {
            return value instanceof Boolean;
        }

        @Override
        public Class<Boolean> getType() {
            return Boolean.TYPE;
        }

        @Override
        public int primitiveFieldCount() {
            return 1;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), 1);
        }
    }

    static final class DoubleFieldLocation
    extends AbstractPrimitiveFieldLocation
    implements DoubleLocation {
        protected final boolean allowInt;
        protected final byte slotSize;

        DoubleFieldLocation(int index, FieldInfo field, boolean allowInt, int slotSize, Assumption finalAssumption) {
            super(index, field, finalAssumption);
            this.allowInt = allowInt;
            assert (slotSize >= 1 && slotSize <= 2);
            this.slotSize = (byte)slotSize;
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.getDouble(store, guard);
        }

        @Override
        public double getDouble(DynamicObject store, boolean guard) {
            if (ExtLayout.UseVarHandle) {
                return Double.longBitsToDouble(this.field.varHandle().get(store));
            }
            this.field.receiverCheck(store);
            if (this.field.type() == Long.TYPE) {
                return Double.longBitsToDouble(UnsafeAccess.unsafeGetLong(store, this.getOffset(), guard, this));
            }
            return UnsafeAccess.unsafeGetDouble(store, this.getOffset(), guard, this);
        }

        @Override
        public void setDouble(DynamicObject store, double value, boolean guard, boolean init) {
            if (!init) {
                this.maybeInvalidateFinalAssumption();
            }
            this.setDoubleInternal(store, value);
        }

        protected void setDoubleInternal(DynamicObject store, double value) {
            if (ExtLayout.UseVarHandle) {
                this.field.varHandle().set(store, Double.doubleToRawLongBits(value));
                return;
            }
            this.field.receiverCheck(store);
            if (this.field.type() == Long.TYPE) {
                UnsafeAccess.unsafePutLong(store, this.getOffset(), Double.doubleToRawLongBits(value), this);
            } else {
                UnsafeAccess.unsafePutDouble(store, this.getOffset(), value, this);
            }
        }

        protected double getFinalDouble(DynamicObject store, boolean condition) {
            if (ExtLayout.UseVarHandle) {
                return Double.longBitsToDouble(this.field.varHandle().get(store));
            }
            this.field.receiverCheck(store);
            if (this.field.type() == Long.TYPE) {
                return Double.longBitsToDouble(UnsafeAccess.unsafeGetFinalLong(store, this.getOffset(), condition, this));
            }
            return UnsafeAccess.unsafeGetFinalDouble(store, this.getOffset(), condition, this);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw DoubleFieldLocation.incompatibleLocation();
            }
            this.setDouble(store, this.doubleValue(value), guard, init);
        }

        protected double doubleValue(Object value) {
            if (!this.allowInt || value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).doubleValue();
            }
            throw ExtLocations.shouldNotReachHere();
        }

        @Override
        public boolean canStore(Object value) {
            return value instanceof Double || this.allowInt && value instanceof Integer;
        }

        @Override
        public double getDouble(DynamicObject store, Shape shape) {
            return this.getDouble(store, DoubleFieldLocation.checkShape(store, shape));
        }

        @Override
        public Class<Double> getType() {
            return Double.TYPE;
        }

        @Override
        public int primitiveFieldCount() {
            return this.slotSize;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), this.slotSize);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((DoubleFieldLocation)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToDouble() {
            return this.allowInt;
        }
    }

    static final class IntFieldLocation
    extends AbstractPrimitiveFieldLocation
    implements IntLocation {
        IntFieldLocation(int index, FieldInfo field, Assumption finalAssumption) {
            super(index, field, finalAssumption);
            assert (field.type() == Long.TYPE || field.type() == Integer.TYPE) : field;
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.getInt(store, guard);
        }

        @Override
        public int getInt(DynamicObject store, boolean guard) {
            if (ExtLayout.UseVarHandle) {
                if (this.field.type() == Long.TYPE) {
                    return (int)this.field.varHandle().get(store);
                }
                return this.field.varHandle().get(store);
            }
            this.field.receiverCheck(store);
            if (this.field.type() == Long.TYPE) {
                return (int)UnsafeAccess.unsafeGetLong(store, this.getOffset(), guard, this);
            }
            return UnsafeAccess.unsafeGetInt(store, this.getOffset(), guard, this);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw IntFieldLocation.incompatibleLocation();
            }
            this.setInt(store, (Integer)value, guard, init);
        }

        @Override
        public void setInt(DynamicObject store, int value, boolean guard, boolean init) {
            if (!init) {
                this.maybeInvalidateFinalAssumption();
            }
            this.setIntInternal(store, value);
        }

        protected void setIntInternal(DynamicObject store, int value) {
            if (ExtLayout.UseVarHandle) {
                if (this.field.type() == Long.TYPE) {
                    this.field.varHandle().set(store, (long)value & 0xFFFFFFFFL);
                } else {
                    this.field.varHandle().set(store, value);
                }
                return;
            }
            this.field.receiverCheck(store);
            if (this.field.type() == Long.TYPE) {
                UnsafeAccess.unsafePutLong(store, this.getOffset(), (long)value & 0xFFFFFFFFL, this);
            } else {
                UnsafeAccess.unsafePutInt(store, this.getOffset(), value, this);
            }
        }

        protected int getFinalInt(DynamicObject store, boolean condition) {
            if (ExtLayout.UseVarHandle) {
                if (this.field.type() == Long.TYPE) {
                    return (int)this.field.varHandle().get(store);
                }
                return this.field.varHandle().get(store);
            }
            this.field.receiverCheck(store);
            if (this.field.type() == Long.TYPE) {
                return (int)UnsafeAccess.unsafeGetFinalLong(store, this.getOffset(), condition, this);
            }
            return UnsafeAccess.unsafeGetFinalInt(store, this.getOffset(), condition, this);
        }

        @Override
        public boolean canStore(Object value) {
            return value instanceof Integer;
        }

        @Override
        public Class<Integer> getType() {
            return Integer.TYPE;
        }

        @Override
        public int primitiveFieldCount() {
            return 1;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), 1);
        }
    }

    static abstract class AbstractPrimitiveFieldLocation
    extends InstanceLocation
    implements FieldLocation {
        protected final FieldInfo field;

        AbstractPrimitiveFieldLocation(int index, FieldInfo field, Assumption finalAssumption) {
            super(index, finalAssumption);
            this.field = Objects.requireNonNull(field);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.field.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            AbstractPrimitiveFieldLocation other = (AbstractPrimitiveFieldLocation)obj;
            return this.field.equals(other.field);
        }

        final long getOffset() {
            return this.field.offset();
        }
    }

    static final class ATypedObjectFieldLocation
    extends AbstractObjectFieldLocation {
        ATypedObjectFieldLocation(int index, FieldInfo field, TypeAssumption typeAssumption, Assumption finalAssumption) {
            super(index, field, finalAssumption, typeAssumption);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) {
            if (!init) {
                this.maybeInvalidateFinalAssumption();
            }
            this.maybeInvalidateTypeAssumption(value);
            super.setObjectInternal(store, value);
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.assumedTypeCast(super.get(store, guard), guard);
        }
    }

    static abstract class AbstractObjectFieldLocation
    extends AbstractObjectLocation
    implements FieldLocation {
        protected final FieldInfo field;

        AbstractObjectFieldLocation(int index, FieldInfo field, Assumption finalAssumption, TypeAssumption typeAssumption) {
            super(index, finalAssumption, typeAssumption);
            this.field = Objects.requireNonNull(field);
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            if (ExtLayout.UseVarHandle) {
                return this.field.varHandle().get(store);
            }
            this.field.receiverCheck(store);
            return UnsafeAccess.unsafeGetObject(store, this.getOffset(), guard, this);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            boolean condition = this.canStore(value);
            if (!condition) {
                throw AbstractObjectFieldLocation.incompatibleLocation();
            }
            this.setObjectInternal(store, value);
        }

        protected final void setObjectInternal(DynamicObject store, Object value) {
            if (ExtLayout.UseVarHandle) {
                this.field.varHandle().set(store, value);
                return;
            }
            this.field.receiverCheck(store);
            UnsafeAccess.unsafePutObject(store, this.getOffset(), value, this);
        }

        protected final Object getFinalObject(DynamicObject store, boolean condition) {
            if (ExtLayout.UseVarHandle) {
                return this.field.varHandle().get(store);
            }
            this.field.receiverCheck(store);
            return UnsafeAccess.unsafeGetFinalObject(store, this.getOffset(), condition, this);
        }

        @Override
        protected final void clear(DynamicObject store) {
            UnsafeAccess.unsafePutObject(store, this.getOffset(), null, this);
        }

        @Override
        public final int objectFieldCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitObjectField(this.index, 1);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.field.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            AbstractObjectFieldLocation other = (AbstractObjectFieldLocation)obj;
            return this.field.equals(other.field);
        }

        final long getOffset() {
            return this.field.offset();
        }
    }

    static final class ATypedObjectArrayLocation
    extends AbstractObjectArrayLocation {
        ATypedObjectArrayLocation(int index, TypeAssumption typeAssumption, Assumption finalAssumption) {
            super(index, finalAssumption, typeAssumption);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) {
            if (!init) {
                this.maybeInvalidateFinalAssumption();
            }
            this.maybeInvalidateTypeAssumption(value);
            super.setObjectInternal(store, value, guard);
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.assumedTypeCast(super.get(store, guard), guard);
        }
    }

    static abstract class AbstractObjectArrayLocation
    extends AbstractObjectLocation
    implements ArrayLocation {
        AbstractObjectArrayLocation(int index, Assumption finalAssumption, TypeAssumption typeAssumption) {
            super(index, finalAssumption, typeAssumption);
        }

        protected static Object getArray(DynamicObject store, boolean condition) {
            return UnsafeAccess.unsafeCast(store.getObjectStore(), Object[].class, condition, true, true);
        }

        protected final long getOffset() {
            return (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE * (long)this.index;
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return UnsafeAccess.unsafeGetObject(AbstractObjectArrayLocation.getArray(store, guard), this.getOffset(), guard, this);
        }

        @Override
        protected void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            boolean valueGuard = this.canStore(value);
            if (!valueGuard) {
                throw AbstractObjectArrayLocation.incompatibleLocation();
            }
            this.setObjectInternal(store, value, guard);
        }

        protected final void setObjectInternal(DynamicObject store, Object value, boolean guard) {
            UnsafeAccess.unsafePutObject(AbstractObjectArrayLocation.getArray(store, guard), this.getOffset(), value, this);
        }

        protected final Object getFinalObject(DynamicObject store, boolean condition) {
            return UnsafeAccess.unsafeGetFinalObject(AbstractObjectArrayLocation.getArray(store, condition), this.getOffset(), condition, this);
        }

        @Override
        protected final void clear(DynamicObject store) {
            UnsafeAccess.unsafePutObject(AbstractObjectArrayLocation.getArray(store, false), this.getOffset(), null, this);
        }

        @Override
        public final int objectArrayCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitObjectArray(this.index, 1);
        }
    }

    static abstract class AbstractObjectLocation
    extends InstanceLocation
    implements ObjectLocation {
        @CompilerDirectives.CompilationFinal
        protected volatile TypeAssumption typeAssumption;
        private static final AtomicReferenceFieldUpdater<AbstractObjectLocation, TypeAssumption> TYPE_ASSUMPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractObjectLocation.class, TypeAssumption.class, "typeAssumption");
        static final boolean LAZY_ASSUMPTION = false;
        private static final DebugCounter assumedTypeLocationAssumptionCount = DebugCounter.create("Typed location assumptions allocated");
        private static final DebugCounter assumedTypeLocationAssumptionInvalidationCount = DebugCounter.create("Typed location assumptions invalidated");
        private static final DebugCounter assumedTypeLocationAssumptionRenewCount = DebugCounter.create("Typed location assumptions renewed");

        AbstractObjectLocation(int index, Assumption finalAssumption, TypeAssumption typeAssumption) {
            super(index, finalAssumption);
            this.typeAssumption = typeAssumption;
        }

        public final TypeAssumption getTypeAssumption() {
            return this.typeAssumption;
        }

        @Override
        public final boolean canStore(Object value) {
            return true;
        }

        @Override
        public final Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public final boolean isNonNull() {
            return false;
        }

        protected final boolean canStoreInternal(Object value) {
            TypeAssumption curr = this.getTypeAssumption();
            if (curr == TypeAssumption.ANY) {
                return true;
            }
            if (curr != null && curr.getAssumption().isValid()) {
                if (value == null) {
                    return !curr.nonNull;
                }
                Class<? extends Object> type = curr.type;
                return type == Object.class || type.isInstance(value);
            }
            return false;
        }

        protected final Object assumedTypeCast(Object value, boolean condition) {
            if (CompilerDirectives.inInterpreter()) {
                return value;
            }
            TypeAssumption curr = this.getTypeAssumption();
            if (curr != null && curr != TypeAssumption.ANY && curr.getAssumption().isValid()) {
                Class<? extends Object> type = curr.type;
                boolean nonNull = curr.nonNull;
                return UnsafeAccess.unsafeCast(value, type, condition, nonNull);
            }
            return value;
        }

        protected final Class<? extends Object> getAssumedType() {
            TypeAssumption curr = this.getTypeAssumption();
            if (curr != null && curr.getAssumption().isValid()) {
                return curr.type;
            }
            return Object.class;
        }

        protected final boolean isAssumedNonNull() {
            TypeAssumption curr = this.getTypeAssumption();
            if (curr != null && curr.getAssumption().isValid()) {
                return curr.nonNull;
            }
            return false;
        }

        static TypeAssumption createTypeAssumption(Class<? extends Object> type, boolean nonNull) {
            if (type == Object.class && !nonNull) {
                return TypeAssumption.ANY;
            }
            assumedTypeLocationAssumptionCount.inc();
            return new TypeAssumption(Truffle.getRuntime().createAssumption("typed object location"), type, nonNull);
        }

        static TypeAssumption createTypeAssumptionFromValue(Object value) {
            boolean nonNull = value != null;
            Class type = nonNull ? value.getClass() : Object.class;
            return AbstractObjectLocation.createTypeAssumption(type, nonNull);
        }

        protected final void maybeInvalidateTypeAssumption(Object value) {
            if (this.canStoreInternal(value)) {
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.invalidateTypeAssumption(value);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void invalidateTypeAssumption(Object value) {
            CompilerAsserts.neverPartOfCompilation();
            AtomicReferenceFieldUpdater<AbstractObjectLocation, TypeAssumption> updater = TYPE_ASSUMPTION_UPDATER;
            while (true) {
                TypeAssumption next;
                void var6_7;
                TypeAssumption curr;
                if ((curr = this.getTypeAssumption()) == null) {
                    TypeAssumption next2 = AbstractObjectLocation.createTypeAssumptionFromValue(value);
                    if (!updater.compareAndSet(this, curr, next2)) continue;
                    return;
                }
                boolean nonNull = curr.nonNull;
                boolean changed = false;
                if (nonNull && value == null) {
                    nonNull = false;
                    changed = true;
                }
                Class<? extends Object> clazz = curr.type;
                if (value != null && !clazz.isInstance(value)) {
                    Class<?> clazz2 = ExtAllocator.getCommonSuperclassForValue(curr.type, value);
                    changed = true;
                }
                if (!changed) {
                    if (curr.getAssumption().isValid()) return;
                    assumedTypeLocationAssumptionRenewCount.inc();
                } else {
                    curr.getAssumption().invalidate("generalizing object type " + TypeAssumption.toString(curr.type, curr.nonNull) + " => " + TypeAssumption.toString(var6_7, nonNull) + " " + String.valueOf(this));
                    assumedTypeLocationAssumptionInvalidationCount.inc();
                }
                if (updater.compareAndSet(this, curr, next = AbstractObjectLocation.createTypeAssumption((Class<? extends Object>)var6_7, nonNull))) return;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void mergeTypeAssumption(TypeAssumption other) {
            CompilerAsserts.neverPartOfCompilation();
            AtomicReferenceFieldUpdater<AbstractObjectLocation, TypeAssumption> updater = TYPE_ASSUMPTION_UPDATER;
            while (true) {
                TypeAssumption next;
                void var6_7;
                Class<? extends Object> clazz;
                TypeAssumption curr;
                if ((curr = this.getTypeAssumption()) == null) {
                    TypeAssumption next2 = other;
                    if (!updater.compareAndSet(this, curr, next2)) continue;
                    return;
                }
                boolean nonNull = curr.nonNull;
                boolean changed = false;
                if (nonNull && !other.nonNull) {
                    nonNull = false;
                    changed = true;
                }
                if (!(clazz = curr.type).isAssignableFrom(other.type)) {
                    Class<?> clazz2 = ExtAllocator.getCommonSuperclass(curr.type, other.type);
                    changed = true;
                }
                if (!changed) {
                    if (curr.getAssumption().isValid()) return;
                    assumedTypeLocationAssumptionRenewCount.inc();
                } else {
                    curr.getAssumption().invalidate("generalizing object type " + TypeAssumption.toString(curr.type, curr.nonNull) + " => " + TypeAssumption.toString(var6_7, nonNull) + " " + String.valueOf(this));
                    assumedTypeLocationAssumptionInvalidationCount.inc();
                }
                if (updater.compareAndSet(this, curr, next = AbstractObjectLocation.createTypeAssumption((Class<? extends Object>)var6_7, nonNull))) return;
            }
        }

        @Override
        public String toString() {
            TypeAssumption assumed = this.getTypeAssumption();
            return super.toString() + "[type=" + TypeAssumption.toString(assumed.type, assumed.nonNull) + "]";
        }
    }

    static interface FieldLocation {
    }

    static interface ArrayLocation {
    }

    static abstract class InstanceLocation
    extends ExtLocation {
        protected final int index;
        @CompilerDirectives.CompilationFinal
        protected volatile Assumption finalAssumption;
        private static final AtomicReferenceFieldUpdater<InstanceLocation, Assumption> FINAL_ASSUMPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InstanceLocation.class, Assumption.class, "finalAssumption");
        static final boolean LAZY_FINAL_ASSUMPTION = true;
        private static final DebugCounter assumedFinalLocationAssumptionCount = DebugCounter.create("Final location assumptions allocated");
        private static final DebugCounter assumedFinalLocationAssumptionInvalidationCount = DebugCounter.create("Final location assumptions invalidated");

        protected InstanceLocation(int index, Assumption finalAssumption) {
            this.index = index;
            this.finalAssumption = finalAssumption;
        }

        final int getIndex() {
            return this.index;
        }

        final Assumption getFinalAssumptionField() {
            return this.finalAssumption;
        }

        static Assumption createFinalAssumption() {
            assumedFinalLocationAssumptionCount.inc();
            return Truffle.getRuntime().createAssumption("final location");
        }

        protected final void maybeInvalidateFinalAssumption() {
            Assumption assumption = this.getFinalAssumptionField();
            if (assumption == null || assumption.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.invalidateFinalAssumption(assumption);
            }
        }

        private void invalidateFinalAssumption(Assumption lastAssumption) {
            CompilerAsserts.neverPartOfCompilation();
            AtomicReferenceFieldUpdater<InstanceLocation, Assumption> updater = FINAL_ASSUMPTION_UPDATER;
            assumedFinalLocationAssumptionInvalidationCount.inc();
            Assumption assumption = lastAssumption;
            if (assumption == null) {
                while (!updater.compareAndSet(this, assumption, Assumption.NEVER_VALID) && (assumption = updater.get(this)) != Assumption.NEVER_VALID) {
                    assumption.invalidate();
                }
            } else if (assumption.isValid()) {
                assumption.invalidate();
                updater.set(this, Assumption.NEVER_VALID);
            }
        }

        @Override
        public final Assumption getFinalAssumption() {
            Assumption assumption = this.getFinalAssumptionField();
            if (assumption == null) {
                return this.initializeFinalAssumption();
            }
            return assumption;
        }

        private Assumption initializeFinalAssumption() {
            AtomicReferenceFieldUpdater<InstanceLocation, Assumption> updater = FINAL_ASSUMPTION_UPDATER;
            Assumption newAssumption = InstanceLocation.createFinalAssumption();
            if (updater.compareAndSet(this, null, newAssumption)) {
                return newAssumption;
            }
            return Objects.requireNonNull(updater.get(this));
        }

        @Override
        public final boolean isAssumedFinal() {
            Assumption assumption = this.getFinalAssumptionField();
            return assumption == null || assumption.isValid();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.index;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            InstanceLocation other = (InstanceLocation)obj;
            return this.index == other.index;
        }

        @Override
        public String toString() {
            return super.toString() + "[final=" + this.isAssumedFinal() + "]";
        }

        @Override
        public String getWhereString() {
            return this instanceof ArrayLocation ? "[" + this.index + "]" : "@" + this.index;
        }

        @Override
        int getOrdinal() {
            boolean isPrimitive = this instanceof AbstractPrimitiveFieldLocation || this instanceof AbstractPrimitiveArrayLocation;
            int ordinal = (isPrimitive ? -2147483647 : 0) + this.getIndex();
            if (this instanceof ArrayLocation) {
                ordinal += 1000;
            }
            return ordinal;
        }
    }

    static final class DeclaredLocation
    extends ValueLocation {
        DeclaredLocation(Object value) {
            super(value);
        }

        @Override
        public boolean isDeclared() {
            return true;
        }
    }

    static final class ConstantLocation
    extends ValueLocation {
        ConstantLocation(Object value) {
            super(value);
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    static abstract class ValueLocation
    extends ExtLocation {
        private final Object value;

        ValueLocation(Object value) {
            assert (!(value instanceof Location));
            this.value = value;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.value, ((ValueLocation)obj).value);
        }

        @Override
        public final Object get(DynamicObject store, boolean guard) {
            return this.value;
        }

        @Override
        public final boolean canStore(Object val) {
            return ValueLocation.valueEquals(this.value, val);
        }

        @Override
        public final void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                if (init) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new UnsupportedOperationException();
                }
                throw ValueLocation.incompatibleLocation();
            }
        }

        @Override
        public String toString() {
            return "=" + String.valueOf(this.value);
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
        }

        @Override
        public final boolean isValue() {
            return true;
        }
    }

    static interface BooleanLocation
    extends TypedLocation,
    org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.BooleanLocation {
        @Override
        public boolean getBoolean(DynamicObject var1, boolean var2);

        @Override
        default public boolean getBoolean(DynamicObject store, Shape shape) {
            return this.getBoolean(store, store.getShape() == shape);
        }

        public void setBoolean(DynamicObject var1, boolean var2, boolean var3, boolean var4);

        @Override
        default public void setBoolean(DynamicObject store, boolean value, Shape shape) {
            this.setBoolean(store, value, store.getShape() == shape, false);
        }

        default public Class<Boolean> getType() {
            return Boolean.TYPE;
        }
    }

    static interface DoubleLocation
    extends TypedLocation,
    org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DoubleLocation {
        @Override
        public double getDouble(DynamicObject var1, boolean var2);

        @Override
        default public double getDouble(DynamicObject store, Shape shape) {
            return this.getDouble(store, store.getShape() == shape);
        }

        public void setDouble(DynamicObject var1, double var2, boolean var4, boolean var5);

        default public Class<Double> getType() {
            return Double.TYPE;
        }

        public boolean isImplicitCastIntToDouble();

        @Override
        default public void setDouble(DynamicObject store, double value, Shape shape) {
            this.setDouble(store, value, store.getShape() == shape, false);
        }
    }

    static interface LongLocation
    extends TypedLocation,
    org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LongLocation {
        @Override
        public long getLong(DynamicObject var1, boolean var2);

        @Override
        default public long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, store.getShape() == shape);
        }

        public void setLong(DynamicObject var1, long var2, boolean var4, boolean var5);

        default public Class<Long> getType() {
            return Long.TYPE;
        }

        public boolean isImplicitCastIntToLong();

        @Override
        default public void setLong(DynamicObject store, long value, Shape shape) {
            this.setLong(store, value, store.getShape() == shape, false);
        }
    }

    static interface IntLocation
    extends TypedLocation,
    org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.IntLocation {
        @Override
        public int getInt(DynamicObject var1, boolean var2);

        @Override
        default public int getInt(DynamicObject store, Shape shape) {
            return this.getInt(store, store.getShape() == shape);
        }

        public void setInt(DynamicObject var1, int var2, boolean var3, boolean var4);

        default public Class<Integer> getType() {
            return Integer.TYPE;
        }

        @Override
        default public void setInt(DynamicObject store, int value, Shape shape) {
            this.setInt(store, value, store.getShape() == shape, false);
        }
    }

    static interface ObjectLocation
    extends TypedLocation {
        public Class<? extends Object> getType();

        public boolean isNonNull();
    }

    static interface TypedLocation {
        public Class<?> getType();
    }
}

