/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory;

import java.nio.ByteOrder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory.ByteArraySupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory.CheckedByteArraySupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory.ReversedByteArraySupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory.SimpleByteArraySupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory.UnsafeByteArraySupport;

final class ByteArraySupports {
    static final ByteArraySupport NATIVE_UNSAFE;
    static final ByteArraySupport NATIVE_CHECKED;
    static final ByteArraySupport LITTLE_ENDIAN;
    static final ByteArraySupport BIG_ENDIAN;

    private ByteArraySupports() {
    }

    static {
        if (System.getProperty("os.arch").equals("x86_64") || System.getProperty("os.arch").equals("aarch64") || System.getProperty("os.arch").equals("amd64")) {
            NATIVE_UNSAFE = new UnsafeByteArraySupport();
            NATIVE_CHECKED = new CheckedByteArraySupport(NATIVE_UNSAFE);
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                BIG_ENDIAN = NATIVE_CHECKED;
                LITTLE_ENDIAN = new ReversedByteArraySupport(NATIVE_CHECKED);
            } else {
                BIG_ENDIAN = new ReversedByteArraySupport(NATIVE_CHECKED);
                LITTLE_ENDIAN = NATIVE_CHECKED;
            }
        } else {
            BIG_ENDIAN = new SimpleByteArraySupport();
            LITTLE_ENDIAN = new ReversedByteArraySupport(BIG_ENDIAN);
            NATIVE_CHECKED = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? BIG_ENDIAN : LITTLE_ENDIAN;
            NATIVE_UNSAFE = NATIVE_CHECKED;
        }
    }
}

