/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeLocal;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnexpectedResultException;

public final class LocalRangeAccessor {
    private final int startOffset;
    private final int startIndex;
    private final int length;
    private static final int CACHE_MAX_START = 32;
    private static final int CACHE_MAX_LENGTH = 16;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private static final LocalRangeAccessor[][] CACHE = LocalRangeAccessor.createArray();

    private LocalRangeAccessor(int startOffset, int startIndex, int length) {
        this.startOffset = startOffset;
        this.startIndex = startIndex;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        return Objects.hash(this.length, this.startIndex, this.startOffset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalRangeAccessor other = (LocalRangeAccessor)obj;
        return this.length == other.length && this.startIndex == other.startIndex && this.startOffset == other.startOffset;
    }

    public String toString() {
        if (this.length == 0) {
            return "LocalRangeAccessor[]";
        }
        return String.format("LocalRangeAccessor[%d...%d]", this.startOffset, this.startOffset + this.length - 1);
    }

    public Object getObject(BytecodeNode bytecodeNode, VirtualFrame frame, int offset) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        return bytecodeNode.getLocalValueInternal(frame, this.startOffset + offset, this.startIndex + offset);
    }

    public boolean getBoolean(BytecodeNode bytecodeNode, VirtualFrame frame, int offset) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        return bytecodeNode.getLocalValueInternalBoolean(frame, this.startOffset + offset, this.startIndex + offset);
    }

    public byte getByte(BytecodeNode bytecodeNode, VirtualFrame frame, int offset) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        return bytecodeNode.getLocalValueInternalByte(frame, this.startOffset + offset, this.startIndex + offset);
    }

    public int getInt(BytecodeNode bytecodeNode, VirtualFrame frame, int offset) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        return bytecodeNode.getLocalValueInternalInt(frame, this.startOffset + offset, this.startIndex + offset);
    }

    public long getLong(BytecodeNode bytecodeNode, VirtualFrame frame, int offset) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        return bytecodeNode.getLocalValueInternalLong(frame, this.startOffset + offset, this.startIndex + offset);
    }

    public float getFloat(BytecodeNode bytecodeNode, VirtualFrame frame, int offset) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        return bytecodeNode.getLocalValueInternalFloat(frame, this.startOffset + offset, this.startIndex + offset);
    }

    public double getDouble(BytecodeNode bytecodeNode, VirtualFrame frame, int offset) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        return bytecodeNode.getLocalValueInternalDouble(frame, this.startOffset + offset, this.startIndex + offset);
    }

    public void setObject(BytecodeNode bytecodeNode, VirtualFrame frame, int offset, Object value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        bytecodeNode.setLocalValueInternal(frame, this.startOffset + offset, this.startIndex + offset, value);
    }

    public void setBoolean(BytecodeNode bytecodeNode, VirtualFrame frame, int offset, boolean value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        bytecodeNode.setLocalValueInternalBoolean(frame, this.startOffset + offset, this.startIndex + offset, value);
    }

    public void setByte(BytecodeNode bytecodeNode, VirtualFrame frame, int offset, byte value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        bytecodeNode.setLocalValueInternalByte(frame, this.startOffset + offset, this.startIndex + offset, value);
    }

    public void setInt(BytecodeNode bytecodeNode, VirtualFrame frame, int offset, int value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        bytecodeNode.setLocalValueInternalInt(frame, this.startOffset + offset, this.startIndex + offset, value);
    }

    public void setLong(BytecodeNode bytecodeNode, VirtualFrame frame, int offset, long value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        bytecodeNode.setLocalValueInternalLong(frame, this.startOffset + offset, this.startIndex + offset, value);
    }

    public void setFloat(BytecodeNode bytecodeNode, VirtualFrame frame, int offset, float value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        bytecodeNode.setLocalValueInternalFloat(frame, this.startOffset + offset, this.startIndex + offset, value);
    }

    public void setDouble(BytecodeNode bytecodeNode, VirtualFrame frame, int offset, double value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        bytecodeNode.setLocalValueInternalDouble(frame, this.startOffset + offset, this.startIndex + offset, value);
    }

    public void clear(BytecodeNode bytecodeNode, VirtualFrame frame, int offset) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        bytecodeNode.clearLocalValueInternal(frame, this.startOffset + offset, this.startIndex + offset);
    }

    public boolean isCleared(BytecodeNode bytecodeNode, VirtualFrame frame, int offset) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        this.checkBounds(offset);
        return bytecodeNode.isLocalClearedInternal(frame, this.startOffset + offset, this.startIndex + offset);
    }

    public Object getLocalName(BytecodeNode bytecodeNode, int offset) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        return bytecodeNode.getLocalNameInternal(this.startOffset + offset, this.startIndex + offset);
    }

    public Object getLocalInfo(BytecodeNode bytecodeNode, int offset) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        CompilerAsserts.partialEvaluationConstant(offset);
        return bytecodeNode.getLocalInfoInternal(this.startOffset + offset, this.startIndex + offset);
    }

    private void checkBounds(int offset) {
        if (offset < 0 || offset >= this.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new ArrayIndexOutOfBoundsException(offset);
        }
    }

    private static LocalRangeAccessor[][] createArray() {
        LocalRangeAccessor[][] array = new LocalRangeAccessor[16][32];
        for (int length = 0; length < 16; ++length) {
            for (int start = 0; start < 32; ++start) {
                array[length][start] = new LocalRangeAccessor(start, start, length);
            }
        }
        return array;
    }

    public static LocalRangeAccessor constantOf(BytecodeLocal[] locals) {
        if (locals.length == 0) {
            return CACHE[0][0];
        }
        int startOffset = locals[0].getLocalOffset();
        int startIndex = locals[0].getLocalIndex();
        for (int i = 1; i < locals.length; ++i) {
            if (startOffset + i == locals[i].getLocalOffset() && startIndex + i == locals[i].getLocalIndex()) continue;
            throw new IllegalArgumentException("Invalid locals provided. Only contiguous locals must be provided for LocalRangeAccessor.");
        }
        int length = locals.length;
        if (startIndex == startOffset && startOffset < 32 && length < 16) {
            return CACHE[length][startOffset];
        }
        return new LocalRangeAccessor(startOffset, startIndex, length);
    }
}

