/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleRuntimeAccess;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.CheckMultiReleaseSupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.DefaultTruffleRuntime;

public final class Truffle {
    private static final TruffleRuntime RUNTIME = Truffle.initRuntime();

    private Truffle() {
    }

    public static TruffleRuntime getRuntime() {
        return RUNTIME;
    }

    private static TruffleRuntimeAccess selectTruffleRuntimeAccess(List<Iterable<TruffleRuntimeAccess>> lookups) {
        TruffleRuntimeAccess selectedAccess = null;
        for (Iterable<TruffleRuntimeAccess> lookup : lookups) {
            if (lookup == null) continue;
            Iterator<TruffleRuntimeAccess> it = lookup.iterator();
            while (it.hasNext()) {
                TruffleRuntimeAccess access;
                try {
                    access = it.next();
                }
                catch (ServiceConfigurationError err) {
                    continue;
                }
                if (selectedAccess == null) {
                    selectedAccess = access;
                    continue;
                }
                if (selectedAccess == access || selectedAccess.getClass() == access.getClass()) continue;
                if (selectedAccess.getPriority() == access.getPriority()) {
                    throw new InternalError(String.format("Providers for %s with same priority %d: %s (loader: %s) vs. %s (loader: %s)", TruffleRuntimeAccess.class.getName(), access.getPriority(), selectedAccess, selectedAccess.getClass().getClassLoader(), access, access.getClass().getClassLoader()));
                }
                if (selectedAccess.getPriority() >= access.getPriority()) continue;
                selectedAccess = access;
            }
        }
        return selectedAccess;
    }

    private static TruffleRuntime createRuntime() throws InternalError {
        if (!CheckMultiReleaseSupport.isSupported() && !Boolean.getBoolean("polyglotimpl.DisableMultiReleaseCheck")) {
            throw new InternalError("Truffle could not be initialized because Multi-Release classes are not configured correctly. This most likely means Truffle classes have been repackaged incorrectly and the `Multi-Release: true` attribute in META-INF/MANIFEST.MF has been lost. A common cause of this error is invalid Uber JAR configuration. For more information see: https://www.graalvm.org/latest/reference-manual/embed-languages/#uber-jar-file-creation. This check may be disabled with '-Dpolyglotimpl.DisableMultiReleaseCheck=true'.");
        }
        if (Boolean.getBoolean("truffle.UseFallbackRuntime")) {
            return new DefaultTruffleRuntime("The fallback runtime was explicitly selected using the -Dtruffle.UseFallbackRuntime option.");
        }
        String runtimeClassName = System.getProperty("truffle.TruffleRuntime");
        if (runtimeClassName != null && !runtimeClassName.isEmpty()) {
            if (runtimeClassName.equals(DefaultTruffleRuntime.class.getName())) {
                return new DefaultTruffleRuntime("The fallback runtime was explicitly selected using the -Dtruffle.TruffleRuntime option.");
            }
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> runtimeClass = Class.forName(runtimeClassName, false, cl);
                Truffle.maybeExportJVMCITo(runtimeClass);
                return (TruffleRuntime)runtimeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }
        Class<Truffle> lookupClass = Truffle.class;
        ModuleLayer moduleLayer = lookupClass.getModule().getLayer();
        TruffleRuntimeAccess access = moduleLayer != null ? Truffle.selectTruffleRuntimeAccess(List.of(ServiceLoader.load(moduleLayer, TruffleRuntimeAccess.class))) : Truffle.selectTruffleRuntimeAccess(List.of(ServiceLoader.load(TruffleRuntimeAccess.class, lookupClass.getClassLoader())));
        if (access == null) {
            access = Truffle.selectTruffleRuntimeAccess(List.of(ServiceLoader.load(TruffleRuntimeAccess.class)));
        }
        if (access != null) {
            Truffle.exportTo(access.getClass());
            TruffleRuntime runtime = access.getRuntime();
            if (runtime != null) {
                return runtime;
            }
        }
        String reason = ModuleLayer.boot().findModule("jdk.internal.vm.ci").isPresent() ? "No optimizing Truffle runtime found on the module or class-path." : "JVMCI is required to enable optimizations. Pass -XX:+EnableJVMCI as a virtual machine argument to the java executable to resolve this.";
        return new DefaultTruffleRuntime(reason);
    }

    private static void maybeExportJVMCITo(Class<?> runtimeClass) throws ReflectiveOperationException {
        Class<?> modulesSupport;
        try {
            modulesSupport = Class.forName("org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.ModulesSupport");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        modulesSupport.getMethod("exportJVMCI", Class.class).invoke(null, runtimeClass);
    }

    private static TruffleRuntime initRuntime() {
        return AccessController.doPrivileged(new PrivilegedAction<TruffleRuntime>(){

            @Override
            public TruffleRuntime run() {
                return Truffle.createRuntime();
            }
        });
    }

    private static void exportTo(Class<?> client) {
        Module truffleModule = Truffle.class.getModule();
        Truffle.exportFromTo(truffleModule, client.getModule());
    }

    private static void exportFromTo(Module truffleModule, Module clientModule) {
        if (truffleModule != clientModule) {
            Set<String> packages = truffleModule.getPackages();
            for (String pkg : packages) {
                boolean exported = truffleModule.isExported(pkg, clientModule);
                if (exported) continue;
                truffleModule.addExports(pkg, clientModule);
            }
        }
    }
}

