/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.network;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class LazyOutputStream
extends OutputStream {
    private final OutputStreamSupplier outputStreamSupplier;
    @Nullable
    private OutputStream outputStream;

    public LazyOutputStream(OutputStreamSupplier outputStreamSupplier) {
        this.outputStreamSupplier = outputStreamSupplier;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.outputStreamSupplier.get();
        }
        this.outputStream.write(b);
    }

    public static interface OutputStreamSupplier {
        public OutputStream get() throws FileNotFoundException;
    }
}

