/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.item;

import java.nio.file.Path;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelProvider;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.client.model.BakedSingleVariableModelProvider;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;
import org.cyclops.integratedscripting.api.item.IScriptVariableFacade;
import org.cyclops.integratedscripting.api.network.IScriptingNetwork;
import org.cyclops.integratedscripting.core.client.model.ScriptingVariableModelProviders;
import org.cyclops.integratedscripting.core.network.ScriptingNetworkHelpers;

public class ScriptVariableFacade
extends VariableFacadeBase
implements IScriptVariableFacade {
    private final int disk;
    private final Path path;
    private final String member;

    public ScriptVariableFacade(boolean generateId, int disk, Path path, String member) {
        super(generateId);
        this.disk = disk;
        this.path = path;
        this.member = member;
    }

    public ScriptVariableFacade(int id, int disk, Path path, String member) {
        super(id);
        this.disk = disk;
        this.path = path;
        this.member = member;
    }

    public <V extends IValue> IVariable<V> getVariable(INetwork network, IPartNetwork partNetwork) {
        if (this.isValid()) {
            return ScriptingNetworkHelpers.getScriptingNetwork(network).map(scriptingNetwork -> scriptingNetwork.getVariable(this.disk, this.path, this.member)).orElse(null);
        }
        return null;
    }

    public boolean isValid() {
        return this.disk >= 0;
    }

    public void validate(INetwork network, IPartNetwork partNetwork, IVariableFacade.IValidator validator, IValueType containingValueType) {
        IScriptingNetwork scriptingNetwork = ScriptingNetworkHelpers.getScriptingNetwork(network).orElse(null);
        try {
            if (!this.isValid()) {
                validator.addError(Component.translatable((String)"variable.integrateddynamics.error.invalid_item"));
            } else if (scriptingNetwork == null) {
                validator.addError(Component.translatable((String)"script.integratedscripting.error.invalid_network"));
            } else if (!scriptingNetwork.getDisks().contains(this.disk)) {
                validator.addError(Component.translatable((String)"script.integratedscripting.error.disk_not_in_network", (Object[])new Object[]{this.disk}));
            } else if (scriptingNetwork.getScript(this.disk, this.path) == null) {
                validator.addError(Component.translatable((String)"script.integratedscripting.error.path_not_in_network", (Object[])new Object[]{this.disk, this.path.toString()}));
            } else if (scriptingNetwork.getScript(this.disk, this.path).getMember(this.member) == null) {
                validator.addError(Component.translatable((String)"script.integratedscripting.error.member_not_in_network", (Object[])new Object[]{this.disk, this.member, this.path.toString()}));
            } else {
                IValue value = scriptingNetwork.getScript(this.disk, this.path).getMember(this.member).getValue();
                if (!ValueHelpers.correspondsTo((IValueType)containingValueType, (IValueType)value.getType())) {
                    validator.addError(Component.translatable((String)"script.integratedscripting.error.invalid_type", (Object[])new Object[]{this.member, this.path.toString(), this.disk, Component.translatable((String)containingValueType.getTranslationKey()), Component.translatable((String)value.getType().getTranslationKey())}));
                }
            }
        }
        catch (EvaluationException e) {
            validator.addError(e.getErrorMessage());
        }
    }

    public IValueType getOutputType() {
        return ValueTypes.CATEGORY_ANY;
    }

    protected List<Component> getScriptTooltip() {
        return List.of(Component.translatable((String)"script.integratedscripting.tooltip.disk", (Object[])new Object[]{this.getDisk()}), Component.translatable((String)"script.integratedscripting.tooltip.path", (Object[])new Object[]{this.getPath().toString()}), Component.translatable((String)"script.integratedscripting.tooltip.member", (Object[])new Object[]{this.getMember()}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(List<Component> list, Item.TooltipContext context) {
        if (this.isValid()) {
            list.addAll(this.getScriptTooltip());
        }
        super.appendHoverText(list, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads, RandomSource random, ModelData modelData) {
        if (this.isValid()) {
            quads.addAll(((BakedSingleVariableModelProvider)variableModelBaked.getSubModels((IVariableModelProvider)ScriptingVariableModelProviders.SCRIPT)).getBakedModel().getQuads(null, null, random, modelData, null));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptVariableFacade)) {
            return false;
        }
        ScriptVariableFacade other = (ScriptVariableFacade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDisk() != other.getDisk()) {
            return false;
        }
        Path this$path = this.getPath();
        Path other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        String this$member = this.getMember();
        String other$member = other.getMember();
        return !(this$member == null ? other$member != null : !this$member.equals(other$member));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScriptVariableFacade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDisk();
        Path $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        String $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : $member.hashCode());
        return result;
    }

    @Override
    public int getDisk() {
        return this.disk;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public String getMember() {
        return this.member;
    }

    public String toString() {
        return "ScriptVariableFacade(disk=" + this.getDisk() + ", path=" + String.valueOf(this.getPath()) + ", member=" + this.getMember() + ")";
    }
}

