/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.evaluate;

import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.network.IScript;
import org.cyclops.integratedscripting.api.network.IScriptMember;
import org.cyclops.integratedscripting.api.network.IScriptingNetwork;

public class ScriptVariable
extends VariableAdapter<IValue> {
    private final int disk;
    private final Path path;
    private final String member;
    private final IScriptingNetwork scriptingNetwork;
    @Nullable
    protected IScript script;
    @Nullable
    protected IValue value;
    private EvaluationException lastEvaluationException;

    public ScriptVariable(int disk, Path path, String member, IScriptingNetwork scriptingNetwork) {
        this.disk = disk;
        this.path = path;
        this.member = member;
        this.scriptingNetwork = scriptingNetwork;
    }

    public IValueType<IValue> getType() {
        return ValueTypes.CATEGORY_ANY;
    }

    public IValue getValue() throws EvaluationException {
        if (this.lastEvaluationException != null) {
            throw this.lastEvaluationException;
        }
        if (this.script == null) {
            try {
                this.script = this.scriptingNetwork.getScript(this.disk, this.path);
                if (this.script != null) {
                    this.script.addInvalidationListener(this::invalidate);
                }
            }
            catch (EvaluationException e) {
                this.lastEvaluationException = e;
                throw this.lastEvaluationException;
            }
        }
        if (this.script == null) {
            this.lastEvaluationException = new EvaluationException(Component.translatable((String)"script.integratedscripting.error.path_not_in_network", (Object[])new Object[]{this.disk, this.path.toString()}));
            throw this.lastEvaluationException;
        }
        if (this.value == null) {
            IScriptMember scriptMember = this.script.getMember(this.member);
            if (scriptMember == null) {
                this.lastEvaluationException = new EvaluationException(Component.translatable((String)"script.integratedscripting.error.member_not_in_network", (Object[])new Object[]{this.disk, this.member, this.path.toString()}));
                throw this.lastEvaluationException;
            }
            this.value = scriptMember.getValue();
        }
        return this.value;
    }

    public void invalidate() {
        if (this.script != null) {
            this.script.removeInvalidationListeners();
        }
        this.script = null;
        this.value = null;
        this.lastEvaluationException = null;
        super.invalidate();
    }
}

