/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotSharingLayer;
import com.oracle.truffle.polyglot.SourceCacheListener;
import com.oracle.truffle.polyglot.TracingSourceCacheListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;

final class SourceCacheStatisticsListener
implements SourceCacheListener {
    private static final int MAX_ENTRIES_PER_CATEGORY = 3;
    private static final int LEFT_COLUMN_WIDTH = 47;
    private final boolean showAllDetails;
    private final Map<CacheCounterKey, SourceCacheCounters> cacheCounters = new ConcurrentHashMap<CacheCounterKey, SourceCacheCounters>();

    private SourceCacheStatisticsListener(boolean sourceCacheStatisticDetails) {
        this.showAllDetails = sourceCacheStatisticDetails;
    }

    static SourceCacheStatisticsListener createOrNull(PolyglotEngineImpl engine) {
        boolean sourceCacheStatistics = engine.engineOptionValues.get(PolyglotEngineOptions.SourceCacheStatistics);
        boolean sourceCacheStatisticDetails = engine.engineOptionValues.get(PolyglotEngineOptions.SourceCacheStatisticDetails);
        return sourceCacheStatistics || sourceCacheStatisticDetails ? new SourceCacheStatisticsListener(sourceCacheStatisticDetails) : null;
    }

    private void finalizeAllCounters(SourceCacheCounters counters) {
        assert (Thread.holdsLock(this));
        counters.finalizeCounters();
        if (counters.nestedCounters != null) {
            for (SourceCacheCounters nestedCounters : counters.nestedCounters.values()) {
                this.finalizeAllCounters(nestedCounters);
            }
        }
    }

    synchronized void onEngineClose(PolyglotEngineImpl engine) {
        for (SourceCacheCounters cacheCounter : this.cacheCounters.values()) {
            this.finalizeAllCounters(cacheCounter);
        }
        StringBuilder logBuilder = new StringBuilder("Polyglot source cache statistics for engine " + engine.engineId);
        logBuilder.append(System.lineSeparator());
        for (SourceCacheCounters cacheCounter : this.cacheCounters.values()) {
            logBuilder.append("--- SHARING LAYER ").append(cacheCounter.sharingLayerId).append("; ").append(cacheCounter.cacheType.name()).append(" CACHE -------------------------").append(System.lineSeparator());
            int indent = 4;
            logBuilder.append(" ".repeat(indent));
            logBuilder.append(String.format("%-" + (47 - indent) + "s", "Languages")).append(":").append(System.lineSeparator());
            ArrayList<String> keys = new ArrayList<String>(cacheCounter.nestedCounters.keySet());
            keys.sort((s1, s2) -> {
                SourceCacheCounters counter1 = cacheCounter.nestedCounters.get(s1);
                SourceCacheCounters counter2 = cacheCounter.nestedCounters.get(s2);
                int signum = Long.signum(counter2.eventCount.get() - counter1.eventCount.get());
                if (signum != 0) {
                    return signum;
                }
                return counter1.sortString.compareTo(counter2.sortString);
            });
            for (String key : keys) {
                SourceCacheCounters languageCounter = cacheCounter.nestedCounters.get(key);
                logBuilder.append(" ".repeat(indent + 4));
                logBuilder.append(String.format("%-" + (47 - indent - 4) + "s", languageCounter.key)).append(":").append(System.lineSeparator());
                if (languageCounter.missParseTimeCharacters.getCount() + languageCounter.failureParseTimeCharacters.getCount() > 0L) {
                    logBuilder.append(" ".repeat(indent + 8));
                    logBuilder.append(String.format("%-" + (47 - indent - 8) + "s", "Character Based Sources Stats")).append(":").append(System.lineSeparator());
                    this.printSourcesStatistics(indent + 12, logBuilder, languageCounter, true);
                    this.printCacheStatistics(indent + 12, logBuilder, languageCounter, true);
                }
                if (languageCounter.missParseTimeBytes.getCount() + languageCounter.failureParseTimeBytes.getCount() <= 0L) continue;
                logBuilder.append(" ".repeat(indent + 8));
                logBuilder.append(String.format("%-" + (47 - indent - 8) + "s", "Byte Based Sources Stats")).append(":").append(System.lineSeparator());
                this.printSourcesStatistics(indent + 12, logBuilder, languageCounter, false);
                this.printCacheStatistics(indent + 12, logBuilder, languageCounter, false);
            }
            engine.getEngineLogger().log(Level.INFO, logBuilder.toString());
        }
    }

    private SourceCacheCounters getCacheCounter(long sharingLayerId, SourceCacheListener.CacheType cacheType) {
        return this.cacheCounters.computeIfAbsent(new CacheCounterKey(sharingLayerId, cacheType), layerAndType -> new SourceCacheCounters(layerAndType.sharinglayerId, layerAndType.cacheType, false, null, null, null));
    }

    private static int appendSourceEntries(StringBuilder sb, Map<String, SourceCacheCounters> m, int maxEntries, Predicate<String> filter, Comparator<String> comparator, BiConsumer<StringBuilder, SourceCacheCounters> appender) {
        ArrayList<String> keys = new ArrayList<String>(m.keySet().stream().filter(filter).toList());
        keys.sort(comparator);
        for (String key : keys.subList(0, Math.min(maxEntries, keys.size()))) {
            appender.accept(sb, m.get(key));
        }
        return keys.size();
    }

    private void printCacheStatistics(int indent, StringBuilder sb, SourceCacheCounters languageCounter, boolean characterBased) {
        LongStatistics failureParseTime;
        char sizeUnit = characterBased ? (char)'C' : 'B';
        LongStatistics missParseSize = characterBased ? languageCounter.missParseSizeCharacters : languageCounter.missParseSizeBytes;
        LongStatistics missParseTime = characterBased ? languageCounter.missParseTimeCharacters : languageCounter.missParseTimeBytes;
        LongStatistics longStatistics = failureParseTime = characterBased ? languageCounter.failureParseTimeCharacters : languageCounter.failureParseTimeBytes;
        if (missParseTime.getCount() + failureParseTime.getCount() > 0L) {
            AtomicLong hitCount = characterBased ? languageCounter.hitCountCharacters : languageCounter.hitCountBytes;
            AtomicLong missCount = characterBased ? languageCounter.missCountCharacters : languageCounter.missCountBytes;
            AtomicLong evictionCount = characterBased ? languageCounter.evictionCountCharacters : languageCounter.evictionCountBytes;
            sb.append(" ".repeat(indent));
            sb.append(String.format("%-" + (47 - indent) + "s", "Cache")).append(": ").append(String.format("parse time(ms)=%6d, parse rate(%c/s)=%12.2f, hits=%7d, misses=%6d, evictions=%5d, failures=%5d, hit rate=%2d%%", missParseTime.getSum(), Character.valueOf(sizeUnit), 1000.0 * (double)missParseSize.getSum() / (double)missParseTime.getSum(), hitCount.get(), missCount.get(), evictionCount.get(), failureParseTime.getCount(), 100L * hitCount.get() / (hitCount.get() + missCount.get())));
            sb.append(System.lineSeparator());
            sb.append(" ".repeat(indent + 4));
            sb.append(String.format("%-" + (47 - indent - 4) + "s", "Parse Successful")).append(": ").append(String.format("count=%15d", missParseTime.getCount()));
            sb.append(System.lineSeparator());
            sb.append(" ".repeat(indent + 8));
            sb.append(String.format("%-" + (47 - indent - 8) + "s", "Time (ms)")).append(": ").append(String.format("count=%15d, sum=%24d, min=%8d, avg=%9.2f, max=%11d, maxSource=%s", missParseTime.getCount(), missParseTime.getSum(), missParseTime.getMin(), missParseTime.getAverage(), missParseTime.getMax(), missParseTime.maxId));
            sb.append(System.lineSeparator());
            sb.append(" ".repeat(indent + 8));
            sb.append(String.format("%-" + (47 - indent - 8) + "s", String.format("Size (%c)", Character.valueOf(sizeUnit)))).append(": ").append(String.format("count=%15d, sum=%24d, min=%8d, avg=%9.2f, max=%11d, maxSource=%s", missParseSize.getCount(), missParseSize.getSum(), missParseSize.getMin(), missParseSize.getAverage(), missParseSize.getMax(), missParseSize.maxId));
            sb.append(System.lineSeparator());
            sb.append(" ".repeat(indent + 4));
            sb.append(String.format("%-" + (47 - indent - 4) + "s", "Sources With Most Hits")).append(":").append(System.lineSeparator());
            BiConsumer<StringBuilder, SourceCacheCounters> appendSingleSourceStats = (b, c) -> {
                LongStatistics sourceMissParseTime = characterBased ? c.missParseTimeCharacters : c.missParseTimeBytes;
                LongStatistics sourceMissParseSize = characterBased ? c.missParseSizeCharacters : c.missParseSizeBytes;
                LongStatistics sourceFailureTimeStats = characterBased ? c.failureParseTimeCharacters : c.failureParseTimeBytes;
                AtomicLong sourceHitCount = characterBased ? c.hitCountCharacters : c.hitCountBytes;
                AtomicLong sourceMissCount = characterBased ? c.missCountCharacters : c.missCountBytes;
                AtomicLong sourceEvictionCount = characterBased ? c.evictionCountCharacters : c.evictionCountBytes;
                b.append(" ".repeat(indent + 8));
                b.append(String.format("%-" + (47 - indent - 8) + "s", c.keyFixedLengthPrefix)).append(": ").append(String.format("parse time(ms)=%6d, parse rate(%c/s)=%12.2f, hits=%7d, misses=%6d, evictions=%5d, failures=%5d, hit rate=%2d%%, name=%s", sourceMissParseTime.getSum(), Character.valueOf(sizeUnit), 1000.0 * (double)sourceMissParseSize.getSum() / (double)sourceMissParseTime.getSum(), sourceHitCount.get(), sourceMissCount.get(), sourceEvictionCount.get(), sourceFailureTimeStats.getCount(), 100L * sourceHitCount.get() / (sourceHitCount.get() + sourceMissCount.get()), c.keyVariableLengthSuffix));
                b.append(System.lineSeparator());
            };
            int totalEntries = SourceCacheStatisticsListener.appendSourceEntries(sb, languageCounter.nestedCounters, this.getMaxEntriesPerCategory(), SourceCacheStatisticsListener.getSourcesFilter(languageCounter, characterBased), (s1, s2) -> {
                SourceCacheCounters counter1 = languageCounter.nestedCounters.get(s1);
                AtomicLong sourceHitCount1 = characterBased ? counter1.hitCountCharacters : counter1.hitCountBytes;
                SourceCacheCounters counter2 = languageCounter.nestedCounters.get(s2);
                AtomicLong sourceHitCount2 = characterBased ? counter2.hitCountCharacters : counter2.hitCountBytes;
                int signum = Long.signum(sourceHitCount2.get() - sourceHitCount1.get());
                if (signum != 0) {
                    return signum;
                }
                return counter1.sortString.compareTo(counter2.sortString);
            }, appendSingleSourceStats);
            if (totalEntries > this.getMaxEntriesPerCategory()) {
                sb.append(" ".repeat(indent + 8)).append("...").append(System.lineSeparator());
            }
            sb.append(" ".repeat(indent + 4));
            sb.append(String.format("%-" + (47 - indent - 4) + "s", "Sources With Most Misses")).append(":").append(System.lineSeparator());
            totalEntries = SourceCacheStatisticsListener.appendSourceEntries(sb, languageCounter.nestedCounters, this.getMaxEntriesPerCategory(), SourceCacheStatisticsListener.getSourcesFilter(languageCounter, characterBased), (s1, s2) -> {
                SourceCacheCounters counter1 = languageCounter.nestedCounters.get(s1);
                AtomicLong sourceMissCount1 = characterBased ? counter1.missCountCharacters : counter1.missCountBytes;
                SourceCacheCounters counter2 = languageCounter.nestedCounters.get(s2);
                AtomicLong sourceMissCount2 = characterBased ? counter2.missCountCharacters : counter2.missCountBytes;
                int signum = Long.signum(sourceMissCount2.get() - sourceMissCount1.get());
                if (signum != 0) {
                    return signum;
                }
                return counter1.sortString.compareTo(counter2.sortString);
            }, appendSingleSourceStats);
            if (totalEntries > this.getMaxEntriesPerCategory()) {
                sb.append(" ".repeat(indent + 8)).append("...").append(System.lineSeparator());
            }
            sb.append(" ".repeat(indent + 4));
            sb.append(String.format("%-" + (47 - indent - 4) + "s", "Sources With Most Evictions")).append(":").append(System.lineSeparator());
            totalEntries = SourceCacheStatisticsListener.appendSourceEntries(sb, languageCounter.nestedCounters, this.getMaxEntriesPerCategory(), SourceCacheStatisticsListener.getSourcesFilter(languageCounter, characterBased), (s1, s2) -> {
                SourceCacheCounters counter1 = languageCounter.nestedCounters.get(s1);
                AtomicLong sourceEvictionCount1 = characterBased ? counter1.evictionCountCharacters : counter1.evictionCountBytes;
                SourceCacheCounters counter2 = languageCounter.nestedCounters.get(s2);
                AtomicLong sourceEvictionCount2 = characterBased ? counter2.evictionCountCharacters : counter2.evictionCountBytes;
                int signum = Long.signum(sourceEvictionCount2.get() - sourceEvictionCount1.get());
                if (signum != 0) {
                    return signum;
                }
                return counter1.sortString.compareTo(counter2.sortString);
            }, appendSingleSourceStats);
            if (totalEntries > this.getMaxEntriesPerCategory()) {
                sb.append(" ".repeat(indent + 8)).append("...").append(System.lineSeparator());
            }
            sb.append(" ".repeat(indent + 4));
            sb.append(String.format("%-" + (47 - indent - 4) + "s", "Failures")).append(": ").append(String.format("count=%15d", failureParseTime.getCount()));
            sb.append(System.lineSeparator());
            if (failureParseTime.getCount() > 0L) {
                sb.append(" ".repeat(indent + 8));
                sb.append(String.format("%-" + (47 - indent - 8) + "s", "Sources With Failures")).append(": ").append(String.format("count=%15d", languageCounter.nestedCounters.entrySet().stream().filter(nestedEntry -> !((SourceCacheCounters)nestedEntry.getValue()).failures.isEmpty() && (characterBased && ((SourceCacheCounters)nestedEntry.getValue()).failureParseTimeCharacters.getCount() > 0L || !characterBased && ((SourceCacheCounters)nestedEntry.getValue()).failureParseTimeBytes.getCount() > 0L)).count()));
                sb.append(System.lineSeparator());
            }
            SourceCacheStatisticsListener.appendSourceEntries(sb, languageCounter.nestedCounters, Integer.MAX_VALUE, SourceCacheStatisticsListener.getSourcesFilter(languageCounter, characterBased), (s1, s2) -> {
                SourceCacheCounters counter1 = languageCounter.nestedCounters.get(s1);
                LongStatistics failureTimeStats1 = characterBased ? counter1.failureParseTimeCharacters : counter1.failureParseTimeBytes;
                SourceCacheCounters counter2 = languageCounter.nestedCounters.get(s2);
                LongStatistics failureTimeStats2 = characterBased ? counter2.failureParseTimeCharacters : counter2.failureParseTimeBytes;
                int signum = Long.signum(failureTimeStats2.getCount() - failureTimeStats1.getCount());
                if (signum != 0) {
                    return signum;
                }
                return counter1.sortString.compareTo(counter2.sortString);
            }, (b, c) -> {
                AtomicLong sourceEvictionCount;
                LongStatistics sourceFailureParseTime = characterBased ? c.failureParseTimeCharacters : c.failureParseTimeBytes;
                LongStatistics sourceFailureParseSize = characterBased ? c.failureParseSizeCharacters : c.failureParseSizeBytes;
                AtomicLong sourceHitCount = characterBased ? c.hitCountCharacters : c.hitCountBytes;
                AtomicLong sourceMissCount = characterBased ? c.missCountCharacters : c.missCountBytes;
                AtomicLong atomicLong = sourceEvictionCount = characterBased ? c.evictionCountCharacters : c.evictionCountBytes;
                if (!c.failures.isEmpty()) {
                    b.append(" ".repeat(indent + 12));
                    b.append(String.format("%-" + (47 - indent - 12) + "s", c.keyFixedLengthPrefix)).append(": ").append(String.format("parse time(ms)=%6d, parse rate(%c/s)=%12.2f, hits=%7d, misses=%6d, evictions=%5d, failures=%5d, hit rate=%2d%%, name=%s", sourceFailureParseTime.getSum(), Character.valueOf(sizeUnit), 1000.0 * (double)sourceFailureParseSize.getSum() / (double)sourceFailureParseTime.getSum(), sourceHitCount.get(), sourceMissCount.get(), sourceEvictionCount.get(), sourceFailureParseTime.getCount(), 100L * sourceHitCount.get() / (sourceHitCount.get() + sourceMissCount.get()), c.keyVariableLengthSuffix));
                    b.append(System.lineSeparator());
                    int index = 0;
                    for (Map.Entry<String, Long> failureEntry : c.failures.entrySet()) {
                        b.append(" ".repeat(indent + 16));
                        b.append(String.format("Failure #%-" + (47 - indent - 16 - "Failure #".length()) + "d", ++index)).append(": ").append(String.format("count=%15d", failureEntry.getValue()));
                        b.append(", failure=").append(failureEntry.getKey());
                        b.append(System.lineSeparator());
                    }
                }
            });
        }
    }

    private void printSourcesStatistics(int indent, StringBuilder sb, SourceCacheCounters languageCounter, boolean characterBased) {
        LongStatistics sizeStats;
        char sizeUnit = characterBased ? (char)'C' : 'B';
        LongStatistics longStatistics = sizeStats = characterBased ? languageCounter.sourceSizeCharacters : languageCounter.sourceSizeBytes;
        if (sizeStats.getCount() > 0L) {
            sb.append(" ".repeat(indent));
            sb.append(String.format("%-" + (47 - indent) + "s", "Sources")).append(": ").append(String.format("count=%15d", sizeStats.getCount()));
            sb.append(System.lineSeparator());
            sb.append(" ".repeat(indent + 4));
            sb.append(String.format("%-" + (47 - indent - 4) + "s", String.format("Size (%c)", Character.valueOf(sizeUnit)))).append(": ").append(String.format("count=%15d, sum=%24d, min=%8d, avg=%9.2f, max=%11d, maxSource=%s", sizeStats.getCount(), sizeStats.getSum(), sizeStats.getMin(), sizeStats.getAverage(), sizeStats.getMax(), sizeStats.maxId));
            sb.append(System.lineSeparator());
            sb.append(" ".repeat(indent + 4));
            sb.append(String.format("%-" + (47 - indent - 4) + "s", "Biggest Sources")).append(":").append(System.lineSeparator());
            int totalEntries = SourceCacheStatisticsListener.appendSourceEntries(sb, languageCounter.nestedCounters, this.getMaxEntriesPerCategory(), SourceCacheStatisticsListener.getSourcesFilter(languageCounter, characterBased), (s1, s2) -> {
                long size1;
                SourceCacheCounters counter1 = languageCounter.nestedCounters.get(s1);
                SourceCacheCounters counter2 = languageCounter.nestedCounters.get(s2);
                long size2 = characterBased ? counter2.sourceSizeCharacters.getSum() : counter2.sourceSizeBytes.getSum();
                int signum = Long.signum(size2 - (size1 = characterBased ? counter1.sourceSizeCharacters.getSum() : counter1.sourceSizeBytes.getSum()));
                if (signum != 0) {
                    return signum;
                }
                return counter1.sortString.compareTo(counter2.sortString);
            }, (b, c) -> {
                long size = characterBased ? c.sourceSizeCharacters.getSum() : c.sourceSizeBytes.getSum();
                b.append(" ".repeat(indent + 8));
                b.append(String.format("%-" + (47 - indent - 8) + "s", c.keyFixedLengthPrefix)).append(": ").append(String.format("size=%16d", size));
                b.append(", name=").append(c.keyVariableLengthSuffix);
                b.append(System.lineSeparator());
            });
            if (totalEntries > this.getMaxEntriesPerCategory()) {
                sb.append(" ".repeat(indent + 8)).append("...").append(System.lineSeparator());
            }
        }
    }

    private static void updateCounters(SourceCacheCounters counter, Source source, CacheEventType eventType, long parseTime, String failure) {
        counter.update(source, eventType, parseTime, failure);
        SourceCacheCounters languageCounter = counter.nestedCounters.merge(source.getLanguage(), new SourceCacheCounters(counter.sharingLayerId, counter.cacheType, false, "", source.getLanguage(), source.getLanguage()), (oldValue, newValue) -> oldValue);
        languageCounter.update(source, eventType, parseTime, failure);
        SourceCacheCounters sourceCounter = languageCounter.nestedCounters.merge(SourceCacheStatisticsListener.getSourceKey(source), new SourceCacheCounters(counter.sharingLayerId, counter.cacheType, true, SourceCacheStatisticsListener.getSourceHash(source), SourceCacheStatisticsListener.getTruncatedSourceName(source), source.getName()), (oldValue, newValue) -> oldValue);
        sourceCounter.update(source, eventType, parseTime, failure);
    }

    @Override
    public void onCacheHit(Source source, CallTarget target, SourceCacheListener.CacheType cacheType, long hits) {
        PolyglotSharingLayer sharingLayer = (PolyglotSharingLayer)EngineAccessor.NODES.getSharingLayer(((RootCallTarget)target).getRootNode());
        SourceCacheCounters sourceCacheCounters = this.getCacheCounter(sharingLayer.shared.id, cacheType);
        SourceCacheStatisticsListener.updateCounters(sourceCacheCounters, source, CacheEventType.HIT, -1L, null);
    }

    @Override
    public void onCacheMiss(Source source, CallTarget target, SourceCacheListener.CacheType cacheType, long startTime) {
        PolyglotSharingLayer sharingLayer = (PolyglotSharingLayer)EngineAccessor.NODES.getSharingLayer(((RootCallTarget)target).getRootNode());
        SourceCacheCounters sourceCacheCounters = this.getCacheCounter(sharingLayer.shared.id, cacheType);
        SourceCacheStatisticsListener.updateCounters(sourceCacheCounters, source, CacheEventType.MISS, System.currentTimeMillis() - startTime, null);
    }

    @Override
    public void onCacheFail(PolyglotSharingLayer sharingLayer, Source source, SourceCacheListener.CacheType cacheType, long startTime, Throwable throwable) {
        String failureKey = TracingSourceCacheListener.truncateString(throwable.toString(), 175);
        SourceCacheCounters sourceCacheCounters = this.getCacheCounter(sharingLayer.shared.id, cacheType);
        SourceCacheStatisticsListener.updateCounters(sourceCacheCounters, source, CacheEventType.FAIL, System.currentTimeMillis() - startTime, failureKey);
    }

    @Override
    public void onCacheEvict(Source source, CallTarget target, SourceCacheListener.CacheType cacheType, long hits) {
        PolyglotSharingLayer sharingLayer = (PolyglotSharingLayer)EngineAccessor.NODES.getSharingLayer(((RootCallTarget)target).getRootNode());
        SourceCacheCounters sourceCacheCounters = this.getCacheCounter(sharingLayer.shared.id, cacheType);
        SourceCacheStatisticsListener.updateCounters(sourceCacheCounters, source, CacheEventType.EVICT, -1L, null);
    }

    private int getMaxEntriesPerCategory() {
        return this.showAllDetails ? Integer.MAX_VALUE : 3;
    }

    private static Predicate<String> getSourcesFilter(SourceCacheCounters languageCounter, boolean characterBased) {
        return s -> {
            SourceCacheCounters c = languageCounter.nestedCounters.get(s);
            return characterBased && c.sourceSizeCharacters.getCount() > 0L || !characterBased && c.sourceSizeBytes.getCount() > 0L;
        };
    }

    private static String getSourceKey(Source source) {
        return SourceCacheStatisticsListener.getSourceHash(source) + " " + SourceCacheStatisticsListener.getTruncatedSourceName(source);
    }

    private static String getSourceHash(Source source) {
        return String.format("0x%08x", source.hashCode());
    }

    private static String getTruncatedSourceName(Source source) {
        return TracingSourceCacheListener.truncateString(source.getName(), 50);
    }

    private static final class SourceCacheCounters {
        private final long sharingLayerId;
        private final SourceCacheListener.CacheType cacheType;
        private final String key;
        private final String keyFixedLengthPrefix;
        private final String keyVariableLengthSuffix;
        private final String sortString;
        private final Set<String> sources = Collections.newSetFromMap(new ConcurrentHashMap());
        private final LongStatistics sourceSizeBytes = new LongStatistics();
        private final LongStatistics sourceSizeCharacters = new LongStatistics();
        private final AtomicLong eventCount = new AtomicLong();
        private final AtomicLong hitCountBytes = new AtomicLong();
        private final AtomicLong hitCountCharacters = new AtomicLong();
        private final AtomicLong missCountBytes = new AtomicLong();
        private final AtomicLong missCountCharacters = new AtomicLong();
        private final LongStatistics missParseTimeBytes = new LongStatistics();
        private final LongStatistics missParseTimeCharacters = new LongStatistics();
        private final LongStatistics missParseSizeBytes = new LongStatistics();
        private final LongStatistics missParseSizeCharacters = new LongStatistics();
        private final AtomicLong evictionCountBytes = new AtomicLong();
        private final AtomicLong evictionCountCharacters = new AtomicLong();
        private final LongStatistics failureParseTimeBytes = new LongStatistics();
        private final LongStatistics failureParseTimeCharacters = new LongStatistics();
        private final LongStatistics failureParseSizeBytes = new LongStatistics();
        private final LongStatistics failureParseSizeCharacters = new LongStatistics();
        private final Map<String, Long> failures = new ConcurrentHashMap<String, Long>();
        private final Map<String, SourceCacheCounters> nestedCounters;
        private boolean finalized;

        private SourceCacheCounters(long sharingLayerId, SourceCacheListener.CacheType cacheType, boolean leaf, String keyFixed, String keyVariable, String sortString) {
            this.sharingLayerId = sharingLayerId;
            this.cacheType = cacheType;
            this.nestedCounters = !leaf ? new ConcurrentHashMap<String, SourceCacheCounters>() : null;
            this.keyFixedLengthPrefix = keyFixed;
            this.keyVariableLengthSuffix = keyVariable;
            this.key = keyFixed != null && keyVariable != null ? keyFixed + " " + keyVariable : (keyFixed != null ? keyFixed : keyVariable);
            this.sortString = sortString;
        }

        private void updateSourceSizeStatistics(Source source, String sourceKey, LongStatistics statsCharacters, LongStatistics statsBytes) {
            assert (Thread.holdsLock(this));
            if (source.hasCharacters()) {
                statsCharacters.accept(source.getCharacters().length(), sourceKey);
            } else if (source.hasBytes()) {
                statsBytes.accept(source.getBytes().length(), sourceKey);
            } else {
                statsCharacters.accept(0L, sourceKey);
            }
        }

        private void updateSourceTimeStatistics(Source source, String sourceKey, LongStatistics statsCharacters, LongStatistics statsBytes, long parseTime) {
            assert (Thread.holdsLock(this));
            if (source.hasCharacters()) {
                statsCharacters.accept(parseTime, sourceKey);
            } else {
                statsBytes.accept(parseTime, sourceKey);
            }
        }

        private void incrementCount(Source source, AtomicLong counterCharacters, AtomicLong counterBytes) {
            assert (Thread.holdsLock(this));
            if (source.hasCharacters()) {
                counterCharacters.incrementAndGet();
            } else {
                counterBytes.incrementAndGet();
            }
        }

        private synchronized void update(Source source, CacheEventType eventType, long parseTime, String failure) {
            if (this.finalized) {
                return;
            }
            String sourceKey = SourceCacheStatisticsListener.getSourceKey(source);
            if (this.sources.add(sourceKey)) {
                this.updateSourceSizeStatistics(source, sourceKey, this.sourceSizeCharacters, this.sourceSizeBytes);
            }
            switch (eventType.ordinal()) {
                case 0: {
                    this.incrementCount(source, this.hitCountCharacters, this.hitCountBytes);
                    break;
                }
                case 1: {
                    this.incrementCount(source, this.missCountCharacters, this.missCountBytes);
                    this.updateSourceSizeStatistics(source, sourceKey, this.missParseSizeCharacters, this.missParseSizeBytes);
                    this.updateSourceTimeStatistics(source, sourceKey, this.missParseTimeCharacters, this.missParseTimeBytes, parseTime);
                    break;
                }
                case 2: {
                    this.incrementCount(source, this.evictionCountCharacters, this.evictionCountBytes);
                    break;
                }
                case 3: {
                    this.incrementCount(source, this.missCountCharacters, this.missCountBytes);
                    this.updateSourceSizeStatistics(source, sourceKey, this.failureParseSizeCharacters, this.failureParseSizeBytes);
                    this.updateSourceTimeStatistics(source, sourceKey, this.failureParseTimeCharacters, this.failureParseTimeBytes, parseTime);
                    this.failures.merge(failure, 1L, Long::sum);
                }
            }
            this.eventCount.incrementAndGet();
        }

        private synchronized void finalizeCounters() {
            this.finalized = true;
        }
    }

    private static final class LongStatistics
    extends LongSummaryStatistics {
        private String maxId;

        private LongStatistics() {
        }

        @Override
        public void accept(int value) {
            throw new UnsupportedOperationException();
        }

        public void accept(long value, String id) {
            if (value > this.getMax()) {
                this.maxId = id;
            }
            super.accept(value);
        }

        @Override
        public void combine(LongSummaryStatistics other) {
            throw new UnsupportedOperationException();
        }
    }

    private record CacheCounterKey(long sharinglayerId, SourceCacheListener.CacheType cacheType) {
    }

    private static enum CacheEventType {
        HIT,
        MISS,
        EVICT,
        FAIL;

    }
}

