/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.item;

import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;

public class UpgradeItem
extends Item {
    private final String previousTier;
    private final GeneratorObject generator;

    public UpgradeItem(Item.Properties properties, String previousTier, GeneratorObject generator) {
        super(properties);
        this.previousTier = previousTier;
        this.generator = generator;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state;
        ResourceLocation blockId;
        if (!context.getLevel().isClientSide() && (blockId = BuiltInRegistries.BLOCK.getKey((Object)(state = context.getLevel().getBlockState(context.getClickedPos())).getBlock())).getNamespace().equals("generatorgalore") && blockId.getPath().equals(this.previousTier + "_generator")) {
            GeneratorUtil.replaceGenerator(context.getLevel(), context.getClickedPos(), this.generator);
            if (!context.getPlayer().isCreative()) {
                context.getItemInHand().shrink(1);
            }
            context.getPlayer().swing(context.getHand());
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }
}

