/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table.core.world.inventory;

import neoforge.com.cursee.disenchanting_table.core.ServerConfig;
import neoforge.com.cursee.disenchanting_table.core.registry.ModBlocks;
import neoforge.com.cursee.disenchanting_table.core.registry.ModMenus;
import neoforge.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import neoforge.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class DisenchantingMenu
extends ItemCombinerMenu {
    public int cost = 0;
    public final DataSlot mayPickup = DataSlot.standalone();
    private final Player playerReference;
    private Holder<Enchantment> keptEnchantment = null;
    private Integer keptEnchantmentLevel = null;
    private ItemEnchantments stolenEnchantments = null;

    public DisenchantingMenu(int containerIndex, Inventory inventory) {
        this(containerIndex, inventory, ContainerLevelAccess.NULL);
    }

    public DisenchantingMenu(int containerIndex, Inventory inventory, ContainerLevelAccess access) {
        super(ModMenus.DISENCHANTING_MENU, containerIndex, inventory, access);
        this.addDataSlot(this.mayPickup);
        this.mayPickup.set(this.cost);
        this.playerReference = inventory.player;
    }

    protected boolean isValidBlock(BlockState blockState) {
        return blockState.is(ModBlocks.DISENCHANTING_TABLE);
    }

    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, DisenchantmentHelper::canDisenchant).withSlot(1, 76, 47, stack -> stack.is(Items.BOOK)).withResultSlot(2, 134, 47).build();
    }

    public boolean hasResult() {
        return !this.resultSlots.isEmpty();
    }

    private void reset() {
        this.keptEnchantment = null;
        this.keptEnchantmentLevel = null;
        this.stolenEnchantments = null;
        this.resultSlots.setItem(0, ItemStack.EMPTY);
        this.cost = 0;
        this.mayPickup.set(0);
    }

    private void disenchantNormal(ItemStack input) {
        this.keptEnchantment = null;
        this.keptEnchantmentLevel = null;
        this.stolenEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
        ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)this.stolenEnchantments);
        this.resultSlots.setItem(0, result);
    }

    private void disenchantBookWithMany(ItemStack input) {
        this.stolenEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
        this.keptEnchantment = (Holder)this.stolenEnchantments.keySet().iterator().next();
        this.keptEnchantmentLevel = this.stolenEnchantments.getLevel(this.keptEnchantment);
        ItemEnchantments.Mutable mutableEnchantments = new ItemEnchantments.Mutable(this.stolenEnchantments);
        mutableEnchantments.removeIf(enchantmentHolder -> enchantmentHolder.value() == this.keptEnchantment.value());
        this.stolenEnchantments = mutableEnchantments.toImmutable();
        ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)this.stolenEnchantments);
        this.resultSlots.setItem(0, result);
    }

    boolean satisfiesCost() {
        Player player = this.playerReference;
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        int currentExperience = ExperienceHelper.getTotalPlayerExperiencePoints((Player)serverPlayer);
        boolean creative = this.player.getAbilities().instabuild;
        boolean experiencePoints = ServerConfig.uses_points && currentExperience >= this.cost;
        boolean experienceLevels = !ServerConfig.uses_points && serverPlayer.experienceLevel >= this.cost;
        boolean experience = experiencePoints || experienceLevels;
        boolean books = this.inputSlots.getItem(1).is(Items.BOOK);
        return (creative || experience) && books;
    }

    public void createResult() {
        Player player = this.playerReference;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack input = this.inputSlots.getItem(0);
        ItemStack book = this.inputSlots.getItem(1);
        if (!DisenchantmentHelper.canDisenchant(input) || !book.is(Items.BOOK)) {
            this.reset();
            return;
        }
        if (!input.is(Items.ENCHANTED_BOOK)) {
            this.disenchantNormal(input);
        } else if (EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input).size() > 1) {
            this.disenchantBookWithMany(input);
        } else if (EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input).size() == 1) {
            ItemStack result = input.copy();
            if (ServerConfig.resets_repair_cost) {
                result.set(DataComponents.REPAIR_COST, (Object)0);
            }
            this.resultSlots.setItem(0, result);
        }
        if (!ServerConfig.requires_experience && !this.hasResult()) {
            return;
        }
        boolean requiresExperience = ServerConfig.requires_experience;
        boolean satisfiesCost = this.satisfiesCost();
        this.mayPickup.set(requiresExperience && satisfiesCost ? 1 : 0);
        this.cost = ServerConfig.experience_cost;
    }

    protected boolean mayPickup(Player player, boolean b) {
        this.mayPickup.set(this.satisfiesCost() ? 1 : 0);
        return this.mayPickup.get() == 1;
    }

    protected void onTake(Player player, ItemStack itemStack) {
        this.access.execute((level, blockPos) -> level.levelEvent(1503, blockPos, 0));
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ItemStack input = this.inputSlots.getItem(0);
        ItemStack extra = this.inputSlots.getItem(1);
        if (!input.is(Items.ENCHANTED_BOOK)) {
            if (ServerConfig.resets_repair_cost) {
                input.set(DataComponents.REPAIR_COST, (Object)0);
            }
            EnchantmentHelper.setEnchantments((ItemStack)input, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)ItemStack.EMPTY));
            this.inputSlots.setItem(0, input);
        } else if (input.is(Items.ENCHANTED_BOOK) && EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input).size() > 1) {
            if (this.keptEnchantment == null || this.keptEnchantmentLevel == null) {
                return;
            }
            this.inputSlots.setItem(0, EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(this.keptEnchantment, this.keptEnchantmentLevel.intValue())));
        } else if (input.is(Items.ENCHANTED_BOOK) && EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input).size() == 1) {
            this.inputSlots.setItem(0, ItemStack.EMPTY);
        }
        extra.shrink(1);
        this.inputSlots.setItem(1, extra);
        if (!ServerConfig.requires_experience) {
            return;
        }
        if (ServerConfig.uses_points) {
            player.giveExperiencePoints(-ServerConfig.experience_cost);
        } else {
            player.giveExperienceLevels(-ServerConfig.experience_cost);
        }
        this.reset();
        if (!input.isEmpty() && input.has(DataComponents.REPAIR_COST) && (Integer)input.get(DataComponents.REPAIR_COST) > 0) {
            this.createResult();
        }
    }
}

