/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.disenchanting_table.core.world.block.entity;

import fabric.com.cursee.disenchanting_table.core.ServerConfig;
import fabric.com.cursee.disenchanting_table.core.registry.ModBlockEntities;
import fabric.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import fabric.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import fabric.com.cursee.disenchanting_table.core.util.S2CBlockEntityUpdatePacket;
import fabric.com.cursee.disenchanting_table.core.world.block.entity.util.ExposedSimpleInventoryBlockEntity;
import fabric.com.cursee.disenchanting_table.core.world.block.entity.util.SimpleInventoryBlockEntity;
import fabric.com.cursee.disenchanting_table.core.world.inventory.DisenchantingMenu;
import fabric.com.cursee.disenchanting_table.core.world.inventory.DisenchantingTableMenu;
import fabric.com.cursee.disenchanting_table.platform.Services;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class DisenchantingTableBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements class_3908 {
    public static final int INPUT_SLOT = 0;
    public static final int EXTRA_SLOT = 1;
    public static final int OUTER_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    private int signal = 0;
    private boolean dirty = false;
    private static final int MAX_PROGRESS = 10;
    private int progress = 0;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int i) {
            if (i == 0) {
                return DisenchantingTableBlockEntity.this.progress;
            }
            return 0;
        }

        public void method_17391(int i, int v) {
            if (i == 0) {
                DisenchantingTableBlockEntity.this.progress = v;
            }
        }

        public int method_17389() {
            return 1;
        }
    };
    private class_6880<class_1887> keptEnchantment = null;
    private Integer keptEnchantmentLevel = null;
    private class_9304 stolenEnchantments = null;

    public DisenchantingTableBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.DISENCHANTING_TABLE, pos, blockState);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"itemGroup.disenchantingTable");
    }

    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        if (this.field_11863 == null) {
            return null;
        }
        return ServerConfig.automatic_disenchanting ? new DisenchantingTableMenu(i, inventory, (class_1263)this, this.dataAccess) : new DisenchantingMenu(i, inventory, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867));
    }

    @Override
    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        if (!ServerConfig.automatic_disenchanting) {
            return false;
        }
        if (index == 0 && !DisenchantmentHelper.canDisenchant(stack)) {
            return true;
        }
        return index == 2;
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(this, 3){

            public boolean method_5437(int index, class_1799 stack) {
                if (!ServerConfig.automatic_disenchanting) {
                    return false;
                }
                return index == 0 && DisenchantmentHelper.canDisenchant(stack) || index == 1 && stack.method_31574(class_1802.field_8529);
            }
        };
    }

    public static void tickClient(class_1937 level, class_2338 pos, class_2680 state, DisenchantingTableBlockEntity table) {
    }

    public static void tickServer(class_1937 level, class_2338 pos, class_2680 state, DisenchantingTableBlockEntity table) {
        boolean validInputs;
        if (!ServerConfig.automatic_disenchanting) {
            return;
        }
        class_1657 player = level.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 16.0, false);
        if (player == null || !DisenchantingTableBlockEntity.hasEnoughExperience(player)) {
            return;
        }
        boolean bl = validInputs = DisenchantmentHelper.canDisenchant(table.method_5438(0)) && table.method_5438(1).method_31574(class_1802.field_8529);
        if (validInputs && table.method_5438(2).method_7960()) {
            if (table.progress >= 10) {
                table.disenchant(level, pos, player);
                level.method_20290(1503, pos, 0);
                table.progress = 0;
            }
            ++table.progress;
            table.dirty = true;
        } else {
            table.progress = 0;
        }
        int newSignal = 0;
        class_1263 container = table.getItemHandler();
        if (!container.method_5442()) {
            if (!container.method_5438(0).method_7960()) {
                newSignal = 3;
                if (!container.method_5438(1).method_7960()) {
                    newSignal = 6;
                }
            }
            if (!container.method_5438(2).method_7960()) {
                newSignal = 9;
            }
        }
        if (newSignal != table.signal) {
            table.signal = newSignal;
            level.method_8455(pos, state.method_26204());
        }
        if (table.dirty) {
            table.dirty = false;
            S2CBlockEntityUpdatePacket.sendToClients(table);
        }
    }

    private static boolean hasEnoughExperience(class_1657 player) {
        if (!ServerConfig.requires_experience) {
            return true;
        }
        if (ServerConfig.uses_points && ExperienceHelper.hasEnoughExperiencePoints(player, ServerConfig.experience_cost)) {
            return true;
        }
        if (!ServerConfig.uses_points && ExperienceHelper.hasEnoughExperienceLevels(player, ServerConfig.experience_cost)) {
            return true;
        }
        return player.method_7337();
    }

    private void disenchant(class_1937 level, class_2338 pos, class_1657 player) {
        class_1799 input = this.method_5438(0);
        if (!input.method_31574(class_1802.field_8598)) {
            this.stolenEnchantments = class_1890.method_57532((class_1799)input);
            class_1799 result = new class_1799((class_1935)class_1802.field_8598);
            class_1890.method_57530((class_1799)result, (class_9304)this.stolenEnchantments);
            if (ServerConfig.resets_repair_cost) {
                result.method_57379(class_9334.field_49639, (Object)0);
            }
            this.method_5447(2, result);
            class_1890.method_57530((class_1799)input, (class_9304)class_1890.method_57532((class_1799)class_1799.field_8037));
            if (ServerConfig.resets_repair_cost) {
                input.method_57379(class_9334.field_49639, (Object)0);
            }
            this.method_5447(0, input);
            this.removeNormalBook();
        } else {
            this.stolenEnchantments = class_1890.method_57532((class_1799)input);
            this.keptEnchantment = (class_6880)this.stolenEnchantments.method_57534().iterator().next();
            this.keptEnchantmentLevel = this.stolenEnchantments.method_57536(this.keptEnchantment);
            class_9304.class_9305 mutable = new class_9304.class_9305(this.stolenEnchantments);
            mutable.method_57548(enchantmentHolder -> enchantmentHolder.comp_349() == this.keptEnchantment.comp_349());
            this.stolenEnchantments = mutable.method_57549();
            class_1799 result = new class_1799((class_1935)class_1802.field_8598);
            class_1890.method_57530((class_1799)result, (class_9304)this.stolenEnchantments);
            if (ServerConfig.resets_repair_cost) {
                result.method_57379(class_9334.field_49639, (Object)0);
            }
            this.method_5447(2, result);
            if (this.keptEnchantment == null || this.keptEnchantmentLevel == null) {
                return;
            }
            class_1799 keptEnchantedBook = class_1772.method_7808((class_1889)new class_1889(this.keptEnchantment, this.keptEnchantmentLevel.intValue()));
            if (ServerConfig.resets_repair_cost) {
                keptEnchantedBook.method_57379(class_9334.field_49639, (Object)0);
            }
            this.method_5447(0, keptEnchantedBook);
            this.removeNormalBook();
        }
        if (!player.method_7337()) {
            if (ServerConfig.uses_points) {
                ExperienceHelper.deductExperiencePoints(player, ServerConfig.experience_cost);
            } else {
                ExperienceHelper.deductExperienceLevels(player, ServerConfig.experience_cost);
            }
        }
    }

    public void removeNormalBook() {
        class_1799 bookStack = this.method_5438(1);
        bookStack.method_7934(1);
        this.method_5447(1, bookStack);
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.progress = tag.method_10550("Progress");
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        tag.method_10569("Progress", this.progress);
        super.method_11007(tag, registries);
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.dirty = true;
            for (class_1657 player : this.field_11863.method_18456()) {
                if (!(player instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)player;
                Services.PLATFORM.sendItemSyncToClient(serverPlayer, SimpleInventoryBlockEntity.copyFromInv((class_1263)this), this.method_11016());
            }
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public int getSignal() {
        return this.signal;
    }

    public class_1799 getRenderStack() {
        return !this.method_5438(2).method_7960() ? this.method_5438(2) : this.method_5438(0);
    }
}

