/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import me.rufia.fightorflight.CobblemonFightOrFlight;

public class TargetingWhitelist {
    private static final Set<String> ALL_POKEMON = new HashSet<String>();
    private static final Set<String> WILD_POKEMON = new HashSet<String>();
    private static final Set<String> PLAYER_OWNED_POKEMON = new HashSet<String>();

    public static void init() {
        ALL_POKEMON.addAll(Arrays.stream(CobblemonFightOrFlight.commonConfig().all_pokemon_targeting_whitelist).toList());
        PLAYER_OWNED_POKEMON.addAll(Arrays.stream(CobblemonFightOrFlight.commonConfig().player_owned_pokemon_targeting_whitelist).toList());
        PLAYER_OWNED_POKEMON.addAll(ALL_POKEMON);
        WILD_POKEMON.addAll(Arrays.stream(CobblemonFightOrFlight.commonConfig().wild_pokemon_targeting_whitelist).toList());
        WILD_POKEMON.addAll(ALL_POKEMON);
    }

    public static Set<String> getWhitelist(boolean hasOwner) {
        return hasOwner ? PLAYER_OWNED_POKEMON : WILD_POKEMON;
    }

    public static Set<String> getWhitelist(PokemonEntity pokemonEntity) {
        return TargetingWhitelist.getWhitelist(pokemonEntity.getPokemon());
    }

    public static Set<String> getWhitelist(Pokemon pokemon) {
        return TargetingWhitelist.getWhitelist(pokemon.isPlayerOwned());
    }

    private static void debug() {
        for (String s : ALL_POKEMON) {
            CobblemonFightOrFlight.LOGGER.info("ALL_POKEMON:{}", (Object)s);
        }
        for (String s : WILD_POKEMON) {
            CobblemonFightOrFlight.LOGGER.info("WILD_POKEMON:{}", (Object)s);
        }
        for (String s : PLAYER_OWNED_POKEMON) {
            CobblemonFightOrFlight.LOGGER.info("PLAYER_OWNED_POKEMON:{}", (Object)s);
        }
    }
}

