/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RayTrace {
    public static LivingEntity rayTraceEntity(LivingEntity viewer, double distance) {
        Level level = viewer.level();
        Vec3 eyePosition = viewer.getEyePosition();
        Vec3 viewVector = viewer.getViewVector(1.0f).normalize();
        Vec3 extendedViewVector = viewVector.scale(distance);
        AABB area = new AABB(eyePosition, eyePosition.add(extendedViewVector));
        LivingEntity livingEntity = null;
        float minDistance = -1.0f;
        for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, area, e -> RayTrace.canChooseAsTarget(e, (Entity)viewer))) {
            Optional optional = entity.getBoundingBox().clip(eyePosition, eyePosition.add(extendedViewVector));
            if (!optional.isPresent()) continue;
            float dis = entity.distanceTo((Entity)viewer);
            if (!(minDistance < 0.0f) && !(minDistance > dis)) continue;
            livingEntity = entity;
            minDistance = dis;
        }
        return livingEntity;
    }

    public static BlockHitResult rayTraceBlock(LivingEntity viewer, double distance) {
        Level level = viewer.level();
        Vec3 eyePosition = viewer.getEyePosition();
        Vec3 viewVector = viewer.getViewVector(1.0f).normalize();
        Vec3 extendedViewVector = viewVector.scale(distance);
        ClipContext context = new ClipContext(eyePosition, eyePosition.add(extendedViewVector), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)viewer);
        BlockHitResult blockHitResult = level.clip(context);
        return blockHitResult;
    }

    private static boolean canChooseAsTarget(LivingEntity entity, Entity viewer) {
        return !entity.isRemoved() && !entity.isSpectator() && entity != viewer.getVehicle() && entity != viewer;
    }
}

