/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.mixin;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.experience.ExperienceSource;
import com.cobblemon.mod.common.api.pokemon.experience.SidemodExperienceSource;
import com.cobblemon.mod.common.api.pokemon.stats.EvSource;
import com.cobblemon.mod.common.api.pokemon.stats.SidemodEvSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.ai.sensors.FOFSensors;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.FOFEVCalculator;
import me.rufia.fightorflight.utils.FOFExpCalculator;
import me.rufia.fightorflight.utils.FOFHeldItemManager;
import me.rufia.fightorflight.utils.FOFMove;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonMultipliers;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonEntity.class})
public abstract class PokemonEntityMixin
extends TamableAnimal
implements PokemonInterface {
    @Final
    @Shadow(remap=false)
    private List<Object> busyLocks;
    @Unique
    @Nullable
    private LivingEntity fightorflight$clientSideCachedAttackTarget;
    @Unique
    @Nullable
    private LivingEntity ownerLastHurt;
    @Unique
    private int ownerLastHurtTick = 0;
    @Unique
    private int ticksUntilNewAngerParticle = 0;
    @Unique
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Unique
    private static final EntityDataAccessor<Integer> DATA_ID_CAPTURED_BY = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Unique
    private static final EntityDataAccessor<Integer> ATTACK_MODE;
    @Unique
    private static final EntityDataAccessor<Integer> ATTACK_TIME;
    @Unique
    private static final EntityDataAccessor<Integer> MAX_ATTACK_TIME;
    @Unique
    private static final EntityDataAccessor<String> MOVE;
    @Unique
    private static final EntityDataAccessor<Integer> CRY_CD;
    @Unique
    private static final EntityDataAccessor<String> COMMAND;
    @Unique
    private static final EntityDataAccessor<String> COMMAND_DATA;
    @Unique
    private static final EntityDataAccessor<BlockPos> TARGET_BLOCK_POS;
    @Unique
    private static final EntityDataAccessor<Integer> MOVE_DURATION;
    @Unique
    private final List<FOFMove> MOVES_FOF = new ArrayList<FOFMove>();

    @Shadow(remap=false)
    public abstract void cry();

    @Shadow(remap=false)
    public abstract Pokemon getPokemon();

    @Shadow(remap=false)
    public abstract int getBeamMode();

    @Unique
    protected void createTargetBlockPos() {
        String data = this.getCommandData();
        BlockPos blockPos = BlockPos.ZERO;
        if (data.startsWith("POS_")) {
            if (data.equals("POS_SELF")) {
                blockPos = new BlockPos(this.getBlockX(), this.getBlockZ(), this.getBlockZ());
            }
        } else {
            Vec3i vec3i = FOFUtils.stringToVec3i(data);
            if (vec3i != null) {
                blockPos = new BlockPos(vec3i.getX(), vec3i.getY(), vec3i.getZ());
            }
        }
        this.setTargetBlockPos(blockPos);
    }

    protected PokemonEntityMixin(EntityType<? extends ShoulderRidingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public LivingEntity getTarget() {
        if (this.level().isClientSide) {
            if (this.fightorflight$clientSideCachedAttackTarget != null) {
                return this.fightorflight$clientSideCachedAttackTarget;
            }
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.fightorflight$clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.fightorflight$clientSideCachedAttackTarget;
            }
        }
        return super.getTarget();
    }

    @Inject(method={"onSyncedDataUpdated(Lnet/minecraft/network/syncher/EntityDataAccessor;)V"}, at={@At(value="TAIL")})
    public void onSyncedDataUpdated(EntityDataAccessor<?> key, CallbackInfo ci) {
        if (DATA_ID_ATTACK_TARGET.equals(key)) {
            this.fightorflight$clientSideCachedAttackTarget = null;
        }
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    protected void defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo callbackInfo) {
        builder.define(DATA_ID_ATTACK_TARGET, (Object)0);
        builder.define(DATA_ID_CAPTURED_BY, (Object)0);
        builder.define(ATTACK_TIME, (Object)0);
        builder.define(MAX_ATTACK_TIME, (Object)-1);
        builder.define(MOVE, (Object)"");
        builder.define(CRY_CD, (Object)0);
        builder.define(COMMAND, (Object)"");
        builder.define(COMMAND_DATA, (Object)"");
        builder.define(TARGET_BLOCK_POS, (Object)BlockPos.ZERO);
        builder.define(ATTACK_MODE, (Object)0);
        builder.define(MOVE_DURATION, (Object)0);
    }

    @Inject(method={"saveWithoutId(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="HEAD")})
    private void writeAdditionalNbt(CompoundTag compoundTag, CallbackInfoReturnable<Boolean> ci) {
        compoundTag.putInt(CRY_CD.toString(), 0);
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void readAdditionalNbt(CompoundTag compoundTag, CallbackInfo ci) {
        this.entityData.set(CRY_CD, (Object)compoundTag.getInt(CRY_CD.toString()));
    }

    @ModifyVariable(method={"assignNewBrainWithMemoriesAndSensors(Lcom/mojang/serialization/Dynamic;Ljava/util/Set;Ljava/util/Set;)Lnet/minecraft/world/entity/ai/Brain;"}, at=@At(value="HEAD"), argsOnly=true, index=3)
    private Set<SensorType<?>> assignNewBrainWithMemoriesAndSensorsMixin(Set<SensorType<?>> sensors) {
        HashSet hashSet = new HashSet(sensors);
        hashSet.add(FOFSensors.POKEMON_HELP_OWNER);
        hashSet.add(FOFSensors.POKEMON_WILD_PROACTIVE);
        hashSet.add(FOFSensors.POKEMON_CAUGHT_BY);
        hashSet.add(FOFSensors.POKESTAFF_ATTACK_TARGET);
        hashSet.add(FOFSensors.POKESTAFF_WALK_TARGET);
        return Set.copyOf(hashSet);
    }

    public void setTarget(LivingEntity target) {
        super.setTarget(target);
        if (target != null) {
            this.entityData.set(DATA_ID_ATTACK_TARGET, (Object)target.getId());
        }
    }

    @Override
    public int getAttackTime() {
        return (Integer)this.entityData.get(ATTACK_TIME);
    }

    @Override
    public void setAttackTime(int val) {
        this.entityData.set(ATTACK_TIME, (Object)val);
    }

    @Override
    public int getMaxAttackTime() {
        return (Integer)this.entityData.get(MAX_ATTACK_TIME);
    }

    @Override
    public void setMaxAttackTime(int val) {
        this.entityData.set(MAX_ATTACK_TIME, (Object)val);
    }

    @Override
    public boolean usingBeam() {
        if (this.getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().single_beam_moves).toList().contains(this.getCurrentMove());
    }

    @Override
    public boolean usingSound() {
        if (this.getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().sound_based_moves).toList().contains(this.getCurrentMove());
    }

    @Override
    public boolean usingMagic() {
        if (this.getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(this.getCurrentMove());
    }

    @Override
    public void setCurrentMove(Move move) {
        this.entityData.set(MOVE, (Object)move.getName());
    }

    @Override
    public String getCurrentMove() {
        return (String)this.entityData.get(MOVE);
    }

    @Override
    public int getNextCryTime() {
        return (Integer)this.entityData.get(CRY_CD);
    }

    @Override
    public void setNextCryTime(int time) {
        this.entityData.set(CRY_CD, (Object)time);
    }

    @Override
    public void setCommand(String cmd) {
        this.entityData.set(COMMAND, (Object)cmd);
    }

    @Override
    public String getCommand() {
        return (String)this.entityData.get(COMMAND);
    }

    @Override
    public void setCommandData(String cmdData) {
        this.entityData.set(COMMAND_DATA, (Object)cmdData);
        this.createTargetBlockPos();
    }

    @Override
    public String getCommandData() {
        return (String)this.entityData.get(COMMAND_DATA);
    }

    @Override
    public BlockPos getTargetBlockPos() {
        return (BlockPos)this.entityData.get(TARGET_BLOCK_POS);
    }

    @Override
    public void setTargetBlockPos(BlockPos blockPos) {
        this.entityData.set(TARGET_BLOCK_POS, (Object)blockPos);
    }

    @Override
    public int getCapturedBy() {
        return (Integer)this.entityData.get(DATA_ID_CAPTURED_BY);
    }

    @Override
    public void setCapturedBy(int id) {
        this.entityData.set(DATA_ID_CAPTURED_BY, (Object)id);
    }

    @Override
    public int getAttackMode() {
        return (Integer)this.entityData.get(ATTACK_MODE);
    }

    @Override
    public void setAttackMode(int attackMode) {
        this.entityData.set(ATTACK_MODE, (Object)attackMode);
    }

    @Override
    public int getMoveDuration() {
        return (Integer)this.entityData.get(MOVE_DURATION);
    }

    @Override
    public void setMoveDuration(int duration) {
        this.entityData.set(MOVE_DURATION, (Object)duration);
    }

    @Override
    public int getOwnerLastHurtTick() {
        return this.ownerLastHurtTick;
    }

    @Override
    public LivingEntity getOwnerLastHurt() {
        return this.ownerLastHurt;
    }

    @Override
    public void setOwnerLastHurt(@Nullable LivingEntity livingEntity) {
        this.ownerLastHurt = livingEntity;
        this.ownerLastHurtTick = this.tickCount;
    }

    @ModifyVariable(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private float hurtDamageTweak(float amount) {
        if (PokemonUtils.shouldRetreat((PokemonEntity)this)) {
            PokemonAttackEffect.pokemonRecallWithAnimation((PokemonEntity)this);
            return 0.0f;
        }
        PokemonMultipliers pokemonMultipliers = new PokemonMultipliers((PokemonEntity)this);
        Pokemon pokemon = this.getPokemon();
        int specialDef = (int)((float)pokemon.getSpecialDefence() * (FOFHeldItemManager.canUse(pokemon, (Item)CobblemonItems.ASSAULT_VEST) ? 1.3f : 1.0f));
        float def = Math.max(pokemon.getDefence(), specialDef);
        return amount * (1.0f - pokemonMultipliers.getMaximumDamageReduction() * Math.min(CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier, Mth.lerp((float)(def / (float)CobblemonFightOrFlight.commonConfig().defense_stat_limit), (float)0.0f, (float)CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier)));
    }

    protected void actuallyHurt(DamageSource damageSource, float damageAmount) {
        float newHealth;
        float d;
        float prevHealth = this.getHealth();
        super.actuallyHurt(damageSource, damageAmount);
        if (PokemonUtils.isUsingNewHealthMechanic() && this.invulnerableTime == 20 && (d = (newHealth = this.getHealth()) - prevHealth) < 0.0f) {
            PokemonUtils.entityHpToPokemonHp((PokemonEntity)this, -d, false);
        }
        if (CobblemonFightOrFlight.commonConfig().slow_down_after_hurt && !this.getPokemon().isPlayerOwned()) {
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 0));
        }
        if (damageSource.is(DamageTypes.MOB_ATTACK) && damageAmount > 0.0f) {
            PokemonEntity pokemonEntity = (PokemonEntity)this;
            Entity entity = damageSource.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (FOFHeldItemManager.canUse(pokemonEntity, (Item)CobblemonItems.ROCKY_HELMET)) {
                    entity.hurt(this.damageSources().thorns((Entity)pokemonEntity), livingEntity.getMaxHealth() / 6.0f);
                }
                if (PokemonUtils.abilityIs(pokemonEntity, "roughskin") || PokemonUtils.abilityIs(pokemonEntity, "ironbarbs")) {
                    entity.hurt(this.damageSources().thorns((Entity)pokemonEntity), livingEntity.getMaxHealth() / 8.0f);
                }
            }
        }
    }

    @Inject(method={"isInvulnerableTo(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void invulnerableToModify(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (!this.busyLocks.isEmpty()) {
            cir.setReturnValue((Object)true);
        }
        if (this.getBeamMode() != 0) {
            cir.setReturnValue((Object)true);
        }
        if (CobblemonFightOrFlight.commonConfig().suffocation_immunity && damageSource.is(DamageTypes.IN_WALL)) {
            cir.setReturnValue((Object)true);
        }
        if (!CobblemonFightOrFlight.commonConfig().pvp_immunity && this.getOwnerUUID() != null && damageSource.getEntity() instanceof Player) {
            cir.setReturnValue((Object)super.isInvulnerableTo(damageSource));
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hurtImmune(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity && !PokemonAttackEffect.shouldBeHurtByAllyMob((PokemonEntity)this, livingEntity = (LivingEntity)entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    public void heal(float healAmount) {
        if (PokemonUtils.isUsingNewHealthMechanic()) {
            PokemonUtils.entityHpToPokemonHp((PokemonEntity)this, healAmount, true);
        }
        super.heal(healAmount);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        int attackTime;
        if (Objects.equals(this.getCommand(), PokeStaffComponent.CMDMODE.CLEAR.name())) {
            this.setCommand(PokeStaffComponent.CMDMODE.NOCMD.name());
        }
        PokemonEntity thisEntity = (PokemonEntity)this;
        LivingEntity targetEntity = PokemonUtils.getTarget(thisEntity);
        int nextCryTime = this.getNextCryTime();
        if (!this.getPokemon().isPlayerOwned() && PokemonUtils.shouldFightTarget(thisEntity)) {
            boolean targetAvailable;
            boolean bl = targetAvailable = targetEntity != null && targetEntity.isAlive();
            if (nextCryTime > 0) {
                this.setNextCryTime(nextCryTime - 1);
            }
            if (nextCryTime == 0) {
                this.setNextCryTime(20);
                if (targetAvailable) {
                    this.cry();
                    if (CobblemonFightOrFlight.commonConfig().multiple_cries) {
                        this.setNextCryTime(CobblemonFightOrFlight.commonConfig().time_to_cry_again);
                    } else {
                        this.setNextCryTime(-1);
                    }
                }
            }
            if (this.ticksUntilNewAngerParticle > 0) {
                --this.ticksUntilNewAngerParticle;
            }
            if (this.ticksUntilNewAngerParticle == 0) {
                this.ticksUntilNewAngerParticle = 25;
                if (targetAvailable) {
                    CobblemonFightOrFlight.PokemonEmoteAngry((Mob)this);
                }
            }
        }
        if ((attackTime = this.getAttackTime()) > -1) {
            this.setAttackTime(attackTime - 1);
        }
        if (!this.level().isClientSide) {
            int t = this.tickCount % 20;
            int sec = this.tickCount / 20;
            this.slowTick(t, sec);
        }
    }

    @Override
    public void tryUsingStatusMoves() {
        Move move;
        if (this.getAttackTime() > 0) {
            return;
        }
        PokemonEntity self = (PokemonEntity)this;
        if (self.getOwner() instanceof Player && !FOFHeldItemManager.canUse(self, (Item)CobblemonItems.ASSAULT_VEST) && (move = PokemonUtils.getStatusMove(self)) != null && CobblemonFightOrFlight.commonConfig().activate_move_effect && MoveData.moveData.containsKey(move.getName())) {
            for (MoveData data : MoveData.moveData.get(move.getName())) {
                data.invoke(self, null);
            }
            PokemonUtils.makeParticle(10, (Entity)self, ParticleTypes.HAPPY_VILLAGER);
            PokemonUtils.sendAnimationPacket(self, "status");
            this.setAttackTime(300);
            this.setMaxAttackTime(300);
        }
    }

    @Unique
    private void slowTick(int ticks, int sec) {
        if (ticks == 11) {
            this.updateAttackMode();
            this.backendMoveCooldown();
        }
        if (sec % 5 == 0 && ticks == 17) {
            this.turnBasedHeldItemTrigger();
        }
    }

    @Unique
    private void turnBasedHeldItemTrigger() {
        if (!FOFHeldItemManager.canUseHeldItemHPInfluencing()) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)this;
        Pokemon pokemon = pokemonEntity.getPokemon();
        float maxHealth = pokemonEntity.getMaxHealth();
        if (FOFHeldItemManager.canUse(pokemonEntity, (Item)CobblemonItems.LEFTOVERS)) {
            this.heal(maxHealth / 16.0f);
        } else if (FOFHeldItemManager.canUse(pokemonEntity, (Item)CobblemonItems.STICKY_BARB)) {
            if (!PokemonUtils.abilityIs(pokemonEntity, "magicguard")) {
                this.hurt(this.damageSources().magic(), maxHealth / 8.0f);
            }
        } else if (FOFHeldItemManager.canUse(pokemonEntity, (Item)CobblemonItems.BLACK_SLUDGE)) {
            if (PokemonUtils.hasType(pokemon, ElementalTypes.POISON)) {
                this.heal(maxHealth / 16.0f);
            } else if (!PokemonUtils.abilityIs(pokemonEntity, "magicguard")) {
                this.hurt(this.damageSources().magic(), maxHealth / 8.0f);
            }
        }
    }

    @Unique
    private void backendMoveCooldown() {
        String moveName = this.getCurrentMove();
        for (FOFMove move : this.MOVES_FOF) {
            int remainingTime;
            if (Objects.equals(move.getName(), moveName) || (remainingTime = move.getRemainingCooldown()) <= 25) continue;
            move.setRemainingCooldown(remainingTime - 20);
        }
    }

    @Unique
    private void updateAttackMode() {
        boolean moveAvailable;
        PokemonEntity pokemonEntity = (PokemonEntity)this;
        Pokemon pokemon = pokemonEntity.getPokemon();
        Move move = PokemonUtils.getMove(pokemonEntity);
        boolean attackIsHigher = pokemon.getAttack() > pokemon.getSpecialAttack();
        boolean hasOwner = pokemonEntity.getOwner() != null;
        boolean bl = moveAvailable = move != null;
        if (hasOwner && moveAvailable) {
            if (PokemonUtils.isMeleeAttackMove(move)) {
                this.setAttackMode(1);
            } else if (PokemonUtils.isRangeAttackMove(move)) {
                this.setAttackMode(2);
            } else {
                this.setAttackMode(0);
            }
            this.setCurrentMove(move);
        } else if (!attackIsHigher && CobblemonFightOrFlight.commonConfig().wild_pokemon_ranged_attack) {
            this.setAttackMode(2);
        } else {
            this.setAttackMode(1);
        }
    }

    @Override
    public void refreshMovesList() {
        if (this.level().isClientSide) {
            return;
        }
        this.MOVES_FOF.clear();
        Pokemon pokemon = this.getPokemon();
        for (Move move : pokemon.getMoveSet()) {
            this.MOVES_FOF.add(new FOFMove(move.getName(), 0, 0));
        }
    }

    @Override
    public void switchMove(Move move) {
        if (this.level().isClientSide || move == null) {
            return;
        }
        if (this.MOVES_FOF.isEmpty()) {
            this.refreshMovesList();
        }
        String oldMoveName = this.getCurrentMove();
        block0: for (int index = 0; index < 4; ++index) {
            FOFMove tmpMove = this.MOVES_FOF.get(index);
            if (tmpMove == null || !Objects.equals(tmpMove.getName(), oldMoveName)) continue;
            tmpMove.setRemainingCooldown(this.getAttackTime());
            tmpMove.setOriginalCooldown(this.getMaxAttackTime());
            for (int i = 0; i < 4; ++i) {
                FOFMove m = this.MOVES_FOF.get(i);
                if (m == null || !Objects.equals(m.getName(), move.getName())) continue;
                if (m.getRemainingCooldown() < 10) {
                    this.setAttackTime(10);
                    this.setMaxAttackTime(10);
                    break block0;
                }
                if (m.getRemainingCooldown() <= 10) break block0;
                this.setAttackTime(m.getRemainingCooldown());
                this.setMaxAttackTime(m.getOriginalCooldown());
                break block0;
            }
            break;
        }
        this.setCurrentMove(move);
    }

    @Inject(method={"dropAllDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="TAIL")})
    private void dropAllDeathLootInject(ServerLevel world, DamageSource source, CallbackInfo ci) {
        PokemonEntity pokemonEntity;
        LivingEntity livingEntity = this.getLastHurtByMob();
        if (livingEntity instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)livingEntity).getOwner() != null) {
            PokemonEntity self = (PokemonEntity)this;
            pokemonEntity.getPokemon().addExperience((ExperienceSource)new SidemodExperienceSource("fightorflight"), FOFExpCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon()));
            if (CobblemonFightOrFlight.commonConfig().can_gain_ev) {
                Map<Stat, Integer> map = FOFEVCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon());
                for (Map.Entry<Stat, Integer> entry : map.entrySet()) {
                    SidemodEvSource evSource = new SidemodEvSource("fightorflight", pokemonEntity.getPokemon());
                    pokemonEntity.getPokemon().getEvs().add(entry.getKey(), entry.getValue().intValue(), (EvSource)evSource);
                }
            }
        }
    }

    static {
        ATTACK_TIME = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.INT);
        MAX_ATTACK_TIME = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.INT);
        MOVE = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        CRY_CD = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.INT);
        COMMAND = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        COMMAND_DATA = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        TARGET_BLOCK_POS = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
        ATTACK_MODE = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.INT);
        MOVE_DURATION = SynchedEntityData.defineId(PokemonEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    }
}

