/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.mixin;

import com.cobblemon.mod.common.api.ai.ActivityConfigurationContext;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.ai.tasks.FOFBackUpIfTooClose;
import me.rufia.fightorflight.entity.ai.tasks.FOFPokemonRangeTask;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.schedule.Activity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ActivityConfigurationContext.class})
public abstract class ActivityConfigurationContextMixin {
    @Final
    @Shadow(remap=false)
    private List<Pair<Integer, BehaviorControl<? super LivingEntity>>> tasks;
    @Final
    @Shadow(remap=false)
    private Activity activity;

    @Inject(method={"apply(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, remap=false)
    private void applyMixin(LivingEntity entity, CallbackInfo ci) {
        if (entity instanceof PokemonEntity && Objects.equals(this.activity.getName(), "fight") && CobblemonFightOrFlight.commonConfig().use_range_attack) {
            this.tasks.add((Pair<Integer, BehaviorControl<? super LivingEntity>>)new Pair((Object)0, (Object)BehaviorBuilder.triggerIf(livingEntity -> {
                if (livingEntity instanceof PokemonEntity) {
                    PokemonEntity pokemonEntity = (PokemonEntity)livingEntity;
                    return PokemonUtils.shouldShoot(pokemonEntity);
                }
                return false;
            }, FOFBackUpIfTooClose.create(5, 0.75f))));
            this.tasks.add((Pair<Integer, BehaviorControl<? super LivingEntity>>)new Pair((Object)1, (Object)new FOFPokemonRangeTask()));
        }
    }
}

