/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.goals.targeting;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;

public class PokemonTauntedTargetGoal
extends NearestAttackableTargetGoal<PokemonEntity> {
    protected PokemonEntity pokemonEntity;
    protected PokemonEntity targetPokemon;
    protected float safeDistanceSqr;

    public PokemonTauntedTargetGoal(PokemonEntity entity, boolean mustSee) {
        super((Mob)entity, PokemonEntity.class, 10, mustSee, false, livingEntity -> {
            if (livingEntity instanceof PokemonEntity) {
                PokemonEntity pokemon = (PokemonEntity)livingEntity;
                return pokemon.getOwner() != null;
            }
            return false;
        });
        this.safeDistanceSqr = (float)Math.pow(CobblemonFightOrFlight.moveConfig().status_move_radius, 2.0);
        this.pokemonEntity = entity;
    }

    public boolean isTaunted() {
        PokemonEntity pokemonEntity1;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof PokemonEntity && (pokemonEntity1 = (PokemonEntity)livingEntity).getOwner() != null && PokemonUtils.canTaunt(pokemonEntity1)) {
            this.targetPokemon = pokemonEntity1;
            return PokemonUtils.WildPokemonCanPerformUnprovokedAttack(this.pokemonEntity);
        }
        this.targetPokemon = null;
        return false;
    }

    public boolean canUse() {
        if (!CobblemonFightOrFlight.moveConfig().wild_pokemon_taunt || this.pokemonEntity.getOwner() != null) {
            return false;
        }
        if (super.canUse()) {
            if (this.isTaunted()) {
                this.target = this.targetPokemon;
                return true;
            }
            this.target = null;
        }
        return false;
    }
}

