/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.ai.goal.Goal;

public class PokemonGoToPosGoal
extends Goal {
    private final PokemonEntity pokemonEntity;
    private final double speedModifier;
    private boolean stuck;

    public PokemonGoToPosGoal(PokemonEntity entity, double speedModifier) {
        this.pokemonEntity = entity;
        this.speedModifier = speedModifier;
    }

    protected boolean moveCommand() {
        return PokemonUtils.moveCommandAvailable(this.pokemonEntity) || PokemonUtils.moveAttackCommandAvailable(this.pokemonEntity);
    }

    protected boolean stayCommand() {
        return PokemonUtils.stayCommandAvailable(this.pokemonEntity);
    }

    public boolean canUse() {
        return this.moveCommand() && !this.isCloseEnough() || this.stayCommand();
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
        this.stuck = false;
    }

    public void tick() {
        if (this.moveCommand()) {
            this.approach();
        } else if (this.stayCommand() && !this.isCloseEnough()) {
            this.approach();
        }
    }

    public void stop() {
        PokemonUtils.finishMoving(this.pokemonEntity);
    }

    protected void approach() {
        PokemonUtils.pokemonEntityApproachPos(this.pokemonEntity, this.getBlockPos(), this.speedModifier);
    }

    protected BlockPos getBlockPos() {
        return ((PokemonInterface)this.pokemonEntity).getTargetBlockPos();
    }

    protected boolean isCloseEnough() {
        return this.getBlockPos().closerToCenterThan((Position)this.pokemonEntity.position(), 2.0);
    }
}

