/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import java.util.Arrays;
import java.util.EnumSet;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

@Deprecated
public class PokemonAttackGoal
extends Goal {
    private int ticksUntilNewAngerParticle = 0;
    private int ticksUntilNewAngerCry = 0;
    private int seeTime;
    private final float attackRadiusSqr;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int ticksUntilNextPathFinding = 0;
    private final double speedModifier;
    protected PokemonEntity pokemonEntity;
    private LivingEntity target;

    public PokemonAttackGoal(PokemonEntity pokemonEntity, double speedModifier) {
        this.pokemonEntity = pokemonEntity;
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = 64.0f;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    protected void setAttackTime(int i) {
        ((PokemonInterface)this.pokemonEntity).setAttackTime(i);
    }

    protected int getAttackTime() {
        return ((PokemonInterface)this.pokemonEntity).getAttackTime();
    }

    protected void resetAttackTime(double dis) {
        PokemonAttackEffect.resetAttackTime(this.pokemonEntity, dis);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        super.tick();
        LivingEntity owner = this.pokemonEntity.getOwner();
        this.angerEffectUpdate(owner);
        this.ticksUntilNextPathFinding = Math.max(this.ticksUntilNextPathFinding - 1, 0);
        if (!this.tryToUseAdvancedMechanic()) {
            if (PokemonUtils.shouldMelee(this.pokemonEntity)) {
                this.meleePathFinding();
                this.checkAndPerformAttack(this.target);
            } else if (PokemonUtils.shouldShoot(this.pokemonEntity)) {
                this.rangeAttackTick();
            }
        }
        this.changeMoveSpeed();
    }

    public boolean canUse() {
        LivingEntity livingEntity;
        if (PokemonUtils.moveCommandAvailable(this.pokemonEntity) || this.pokemonEntity.getPokemon().getState() instanceof ShoulderedState) {
            return false;
        }
        if ((PokemonUtils.shouldShoot(this.pokemonEntity) || PokemonUtils.shouldMelee(this.pokemonEntity)) && (livingEntity = this.pokemonEntity.getTarget()) != null && livingEntity.isAlive() && PokemonUtils.shouldFightTarget(this.pokemonEntity)) {
            this.target = livingEntity;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.target == null || !PokemonUtils.shouldShoot(this.pokemonEntity) && !PokemonUtils.shouldMelee(this.pokemonEntity)) {
            return false;
        }
        return (this.canUse() || !this.pokemonEntity.getNavigation().isDone()) && !this.isTargetInBattle();
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        this.pokemonEntity.getNavigation().stop();
    }

    private void angerEffectUpdate(LivingEntity owner) {
        if (owner == null) {
            if (this.ticksUntilNewAngerParticle < 1) {
                CobblemonFightOrFlight.PokemonEmoteAngry((Mob)this.pokemonEntity);
                this.ticksUntilNewAngerParticle = 10;
            } else {
                --this.ticksUntilNewAngerParticle;
            }
            if (this.ticksUntilNewAngerCry < 1) {
                this.pokemonEntity.cry();
                this.ticksUntilNewAngerCry = 100 + (int)(Math.random() * 200.0);
            } else {
                --this.ticksUntilNewAngerCry;
            }
        }
    }

    private boolean tryToUseAdvancedMechanic() {
        Move move;
        int tickCount = this.pokemonEntity.tickCount;
        if ((tickCount - 11) % 20 == 0 && this.target != null && this.getAttackTime() == 0 && (move = PokemonUtils.getMove(this.pokemonEntity)) != null) {
            String moveName = move.getName();
            if (Arrays.stream(CobblemonFightOrFlight.moveConfig().quick_attack_like_move).toList().contains(moveName)) {
                float distance = this.pokemonEntity.distanceTo((Entity)this.target);
                if (distance >= 1.5f && distance <= 10.0f) {
                    BlockPos targetBlockPos = this.target.blockPosition();
                    if (FOFUtils.multiSamplingCollisionCheckBlock((LivingEntity)this.pokemonEntity, this.target, 5, 3)) {
                        PokemonUtils.makeParticle(4, (Entity)this.pokemonEntity, ParticleTypes.WHITE_SMOKE);
                        this.pokemonEntity.teleportTo((double)targetBlockPos.getX(), (double)targetBlockPos.getY(), (double)targetBlockPos.getZ());
                        PokemonUtils.makeParticle(4, (Entity)this.target, ParticleTypes.WHITE_SMOKE);
                    }
                } else {
                    this.meleePathFinding();
                }
            }
        }
        return false;
    }

    private void changeMoveSpeed() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && this.isTargetInBattle()) {
            this.pokemonEntity.getNavigation().setSpeedModifier(0.0);
        } else {
            this.pokemonEntity.getNavigation().setSpeedModifier(this.speedModifier);
        }
    }

    public boolean isTargetInBattle() {
        LivingEntity livingEntity = this.pokemonEntity.getTarget();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer targetAsPlayer = (ServerPlayer)livingEntity;
            return BattleRegistry.getBattleByParticipatingPlayer((ServerPlayer)targetAsPlayer) != null;
        }
        return false;
    }

    private void meleePathFinding() {
        if (this.ticksUntilNextPathFinding <= 0) {
            this.ticksUntilNextPathFinding = 4 + this.pokemonEntity.getRandom().nextInt(7);
            float distance = this.pokemonEntity.distanceTo((Entity)this.target);
            if (distance > 256.0f) {
                this.ticksUntilNextPathFinding += 10;
            }
            if (!this.pokemonEntity.getNavigation().moveTo((Entity)this.target, this.speedModifier)) {
                this.ticksUntilNextPathFinding += 15;
            }
        }
    }

    private void rangeAttackPathFinding(boolean canSee, double distance) {
        if (!(distance > (double)this.attackRadiusSqr) && this.seeTime >= 5 && canSee) {
            this.pokemonEntity.getNavigation().stop();
            ++this.strafingTime;
        } else {
            this.pokemonEntity.getNavigation().moveTo((Entity)this.target, this.speedModifier);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 10) {
            if ((double)this.pokemonEntity.getRandom().nextFloat() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.pokemonEntity.getRandom().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (distance > (double)(this.attackRadiusSqr * 0.8f)) {
                this.strafingBackwards = false;
            } else if (distance < (double)(this.attackRadiusSqr * 0.2f)) {
                this.strafingBackwards = true;
            }
            this.pokemonEntity.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            Entity vehicle = this.pokemonEntity.getControlledVehicle();
            if (vehicle instanceof Mob) {
                Mob mob = (Mob)vehicle;
                mob.lookAt((Entity)this.pokemonEntity, 30.0f, 30.0f);
            }
        }
        this.pokemonEntity.getLookControl().setLookAt((Entity)this.target);
    }

    protected boolean canPerformAttack(LivingEntity entity) {
        return this.getAttackTime() == 0 && this.pokemonEntity.isWithinMeleeAttackRange(entity) && this.pokemonEntity.getSensing().hasLineOfSight((Entity)entity);
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.canPerformAttack(target)) {
            this.resetAttackTime(0.0);
            this.pokemonDoHurtTarget((Entity)target);
        }
    }

    public boolean pokemonDoHurtTarget(Entity hurtTarget) {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && this.isTargetInBattle()) {
            return false;
        }
        if (!PokemonUtils.pokemonTryForceEncounter(this.pokemonEntity, hurtTarget)) {
            Move move = PokemonUtils.getMove(this.pokemonEntity);
            if (move != null && Arrays.stream(CobblemonFightOrFlight.moveConfig().self_centered_aoe_moves).toList().contains(move.getName())) {
                PokemonAttackEffect.dealAoEDamage(this.pokemonEntity, (Entity)this.pokemonEntity, true, PokemonUtils.isMeleeAttackMove(move));
                if (PokemonUtils.isPhysicalMove(move)) {
                    PokemonUtils.sendAnimationPacket(this.pokemonEntity, "physical");
                } else {
                    PokemonUtils.sendAnimationPacket(this.pokemonEntity, "special");
                }
                return true;
            }
            PokemonUtils.sendAnimationPacket(this.pokemonEntity, "physical");
            return PokemonAttackEffect.pokemonAttack(this.pokemonEntity, hurtTarget);
        }
        return false;
    }

    private void rangeAttackTick() {
        double d = this.pokemonEntity.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean canSee = this.pokemonEntity.getSensing().hasLineOfSight((Entity)this.target);
        if (canSee) {
            ++this.seeTime;
        } else {
            this.seeTime = 0;
            this.resetAttackTime(d);
        }
        this.rangeAttackPathFinding(canSee, d);
        if (this.getAttackTime() == 7 && ((PokemonInterface)this.pokemonEntity).usingSound()) {
            PokemonUtils.createSonicBoomParticle(this.pokemonEntity, this.target);
        }
        if (this.getAttackTime() % 5 == 0 && ((PokemonInterface)this.pokemonEntity).usingMagic()) {
            PokemonAttackEffect.makeMagicAttackParticle(this.pokemonEntity, (Entity)this.target);
        }
        if (this.getAttackTime() == 0) {
            if (!canSee) {
                return;
            }
            this.resetAttackTime(d);
            this.performRangedAttack(this.target);
        } else if (this.getAttackTime() < 0) {
            this.resetAttackTime(d);
        }
    }

    protected void performRangedAttack(LivingEntity target) {
        PokemonAttackEffect.pokemonPerformRangedAttack(this.pokemonEntity, target);
    }
}

