/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonSpike;
import me.rufia.fightorflight.utils.PokemonUtils;
import me.rufia.fightorflight.utils.TypeEffectiveness;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PokemonFloatingSpike
extends AbstractPokemonSpike {
    protected short remainingFloatingTime;

    public PokemonFloatingSpike(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public PokemonFloatingSpike(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractPokemonProjectile>)((EntityType)EntityFightOrFlight.FLOATING_SPIKE.get()), level);
        this.activated = false;
        this.life = 0;
        this.inGround = false;
        this.remainingFloatingTime = 0;
        this.initPosition(shooter);
    }

    @Override
    protected void onActivated() {
        this.remainingFloatingTime = (short)this.level().random.nextIntBetweenInclusive(8, 12);
    }

    @Override
    public void tick() {
        if (this.remainingFloatingTime > 0) {
            this.remainingFloatingTime = (short)(this.remainingFloatingTime - 1);
        }
        super.tick();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putShort("remainingFloatingTime", this.remainingFloatingTime);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("remainingFloatingTime", 2)) {
            this.remainingFloatingTime = compound.getShort("remainingFloatingTime");
        }
    }

    @Override
    protected void hurtEntity(LivingEntity target) {
        PokemonEntity pokemonEntity;
        Entity entity = this.getOwner();
        if (entity instanceof PokemonEntity && PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity = (PokemonEntity)entity, target)) {
            float multiplier;
            DamageSource damageSource = this.damageSources().indirectMagic((Entity)this, (Entity)pokemonEntity);
            if (target instanceof PokemonEntity) {
                PokemonEntity pokemon = (PokemonEntity)target;
                v0 = TypeEffectiveness.getTypeEffectivenessSimple("rock", pokemon);
            } else {
                v0 = multiplier = 1.0f;
            }
            if (target.hurt(damageSource, multiplier * CobblemonFightOrFlight.moveConfig().spike_basic_damage)) {
                pokemonEntity.setLastHurtByMob((LivingEntity)pokemonEntity);
                PokemonUtils.setHurtByPlayer(pokemonEntity, (Entity)target);
            }
        }
    }

    @Override
    protected double getDefaultGravity() {
        double g = super.getDefaultGravity();
        if (this.activated) {
            if (this.remainingFloatingTime > 0) {
                return -g;
            }
            Vec3 v = this.getDeltaMovement();
            if (v.y > 0.0) {
                this.setDeltaMovement(v.x, 0.0, v.z);
            }
            return 0.0;
        }
        return g;
    }
}

