/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.areaeffect;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.areaeffect.AbstractPokemonAreaEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class PokemonTornado
extends AbstractPokemonAreaEffect {
    public PokemonTornado(EntityType<? extends AbstractPokemonAreaEffect> entityType, Level level) {
        super(entityType, level);
    }

    public PokemonTornado(LivingEntity owner) {
        super((EntityType<? extends AbstractPokemonAreaEffect>)((EntityType)EntityFightOrFlight.TORNADO.get()), owner.level());
        this.setOwner(owner);
    }

    @Override
    protected void visualEffect() {
        if (this.owner instanceof PokemonEntity && this.isWaiting()) {
            PokemonUtils.makeParticle(10, this, ParticleTypes.ASH);
            PokemonUtils.makeParticle(2, this, ParticleTypes.SWEEP_ATTACK);
        }
    }

    @Override
    protected void activate() {
        PokemonEntity pokemonEntity;
        super.activate();
        LivingEntity livingEntity = this.owner;
        if (livingEntity instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)livingEntity).isAlive()) {
            this.dealDamageInTheArea();
        } else {
            this.discard();
        }
    }

    @Override
    protected void playDefaultSound() {
        this.playSound((SoundEvent)SoundEvents.BREEZE_WIND_CHARGE_BURST.value(), 3.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f);
    }
}

