/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.areaeffect;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.IPokemonAttack;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.areaeffect.PokemonAreaEffectMagic;
import me.rufia.fightorflight.entity.areaeffect.PokemonTornado;
import me.rufia.fightorflight.entity.areaeffect.PokemonWhirlPool;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPokemonAreaEffect
extends Entity
implements IPokemonAttack {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(AbstractPokemonAreaEffect.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT = SynchedEntityData.defineId(AbstractPokemonAreaEffect.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.defineId(AbstractPokemonAreaEffect.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.defineId(AbstractPokemonAreaEffect.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> DATA_MOVE_NAME = SynchedEntityData.defineId(AbstractPokemonAreaEffect.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected int duration = 100;
    protected int waitTime = 10;
    protected boolean isInstant;
    protected boolean activated;
    @Nullable
    protected LivingEntity owner;
    @Nullable
    protected UUID ownerUUID;

    public AbstractPokemonAreaEffect(EntityType<? extends AbstractPokemonAreaEffect> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
        this.isInstant = false;
        this.activated = false;
    }

    public static AbstractPokemonAreaEffect tryToCreate(PokemonEntity owner, LivingEntity target, Move move) {
        if (move == null) {
            return null;
        }
        String moveName = move.getName();
        boolean canFloat = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_can_float).toList().contains(moveName);
        boolean isInstant = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_is_instant).toList().contains(moveName);
        boolean isTornado = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_rise_up_tornado).toList().contains(moveName);
        boolean isWhirlpool = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_bounding_whirlpool).toList().contains(moveName);
        float r = Mth.clamp((float)owner.getBbWidth(), (float)1.0f, (float)3.0f) * 1.5f;
        AbstractPokemonAreaEffect aoe = isTornado ? new PokemonTornado((LivingEntity)owner) : (isWhirlpool ? new PokemonWhirlPool((LivingEntity)owner) : new PokemonAreaEffectMagic((LivingEntity)owner));
        aoe.setMoveName(moveName);
        aoe.setOwner((LivingEntity)owner);
        aoe.init(target, 30, 10, canFloat, isInstant);
        aoe.refreshHeight();
        aoe.setRadius(r);
        return aoe;
    }

    public void init(LivingEntity target, int duration, int waitTime, boolean canFloat, boolean isInstant) {
        this.duration = duration;
        this.waitTime = waitTime;
        this.isInstant = isInstant;
        if (canFloat) {
            this.setPos(target.position());
        } else {
            BlockPos blockPos = target.getOnPos();
            int y = blockPos.getY();
            boolean yFound = false;
            while (!yFound && y > this.level().getMinBuildHeight()) {
                BlockState blockState = target.level().getBlockState(blockPos);
                if (blockState.blocksMotion()) {
                    yFound = true;
                    continue;
                }
                --y;
                blockPos = blockPos.below();
            }
            if (yFound) {
                this.setPos(target.getX(), y + 1, target.getZ());
            }
        }
    }

    public void refreshHeight() {
        float r = this.getRadius();
        if (this instanceof PokemonTornado) {
            this.setHeight(r);
        } else {
            this.setHeight(0.5f);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            boolean isWaitingNow;
            boolean wasWaiting = this.isWaiting();
            this.visualEffect();
            if (this.tickCount > this.duration || this.getOwner() == null) {
                this.discard();
                return;
            }
            boolean bl = isWaitingNow = this.tickCount < this.waitTime;
            if (wasWaiting != isWaitingNow) {
                this.setWaiting(isWaitingNow);
            }
            if (isWaitingNow) {
                return;
            }
            if (!((this.tickCount + 1) % this.getApplicationTime() != 0 || this.activated && this.isInstant)) {
                this.activate();
            }
        }
    }

    protected abstract void visualEffect();

    protected void activate() {
        if (!this.activated) {
            this.onActivated();
        }
        this.activated = true;
    }

    protected void onActivated() {
        this.playActivateSound();
    }

    protected void playActivateSound() {
        String typeName;
        switch (typeName = this.getElementalType()) {
            case "Electric": {
                this.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 4.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f);
                break;
            }
            case "Fire": {
                this.playSound(SoundEvents.GENERIC_BURN, 4.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f);
                break;
            }
            case "Water": {
                this.playSound(SoundEvents.GENERIC_SPLASH, 4.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f);
                break;
            }
            default: {
                this.playDefaultSound();
            }
        }
    }

    protected void playDefaultSound() {
        this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 3.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f);
    }

    protected void dealDamageInTheArea() {
        PokemonEntity pokemonEntity;
        LivingEntity livingEntity = this.owner;
        if (livingEntity instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)livingEntity).isAlive()) {
            List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
            for (LivingEntity target : list) {
                Move move;
                if (PokemonUtils.pokemonTryForceEncounter(pokemonEntity, (Entity)target) || (move = PokemonUtils.findMove(pokemonEntity, this.getMoveName())) == null || !PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity, target)) continue;
                boolean success = target.hurt(pokemonEntity.damageSources().indirectMagic((Entity)pokemonEntity, (Entity)pokemonEntity), PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (Entity)target, move));
                PokemonUtils.setHurtByPlayer(pokemonEntity, (Entity)target);
                PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, (Entity)target, this.getMoveName());
                PokemonAttackEffect.applyPostEffect(pokemonEntity, target, move, success);
                this.applyExtraEffect(target);
            }
        }
    }

    protected void applyExtraEffect(LivingEntity target) {
    }

    public int getApplicationTime() {
        return 5;
    }

    public float getRadius() {
        return ((Float)this.entityData.get(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float r) {
        this.entityData.set(DATA_RADIUS, (Object)Float.valueOf(r));
    }

    public float getHeight() {
        return ((Float)this.entityData.get(DATA_HEIGHT)).floatValue();
    }

    public void setHeight(float h) {
        this.entityData.set(DATA_HEIGHT, (Object)Float.valueOf(h));
    }

    public boolean isActivated() {
        return this.activated;
    }

    @NotNull
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @NotNull
    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)this.getHeight());
    }

    public void refreshDimensions() {
        double d = this.getX();
        double e = this.getY();
        double f = this.getZ();
        super.refreshDimensions();
        this.setPos(d, e, f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_RADIUS, (Object)Float.valueOf(3.0f));
        builder.define(DATA_HEIGHT, (Object)Float.valueOf(0.5f));
        builder.define(DATA_TYPE, (Object)"normal");
        builder.define(DATA_WAITING, (Object)true);
        builder.define(DATA_MOVE_NAME, (Object)"");
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (DATA_RADIUS.equals(dataAccessor)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.tickCount = compound.getInt("Age");
        this.duration = compound.getInt("Duration");
        this.waitTime = compound.getInt("WaitTime");
        this.setHeight(compound.getFloat("Height"));
        this.setRadius(compound.getFloat("Radius"));
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Age", this.tickCount);
        compound.putInt("Duration", this.duration);
        compound.putInt("WaitTime", this.waitTime);
        compound.putFloat("Radius", this.getRadius());
        compound.putFloat("Height", this.getHeight());
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    @Override
    public String getElementalType() {
        return (String)this.entityData.get(DATA_TYPE);
    }

    @Override
    public void setElementalType(String type) {
        this.entityData.set(DATA_TYPE, (Object)type);
    }

    protected void setWaiting(boolean waiting) {
        this.getEntityData().set(DATA_WAITING, (Object)waiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.getEntityData().get(DATA_WAITING);
    }

    public void setMoveName(String moveName) {
        this.entityData.set(DATA_MOVE_NAME, (Object)moveName);
    }

    public String getMoveName() {
        return (String)this.entityData.get(DATA_MOVE_NAME);
    }

    public int getDuration() {
        return this.duration;
    }

    public int getWaitTime() {
        return this.waitTime;
    }
}

