/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.ai.tasks;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Arrays;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.ai.tasks.FOFPokemonAttackTask;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public class FOFPokemonMeleeTask {
    public static OneShot<LivingEntity> create(int cooldownBetweenAttacks) {
        return BehaviorBuilder.create(context -> context.group((App)context.registered(MemoryModuleType.LOOK_TARGET), (App)context.present(MemoryModuleType.ATTACK_TARGET), (App)context.absent(MemoryModuleType.ATTACK_COOLING_DOWN), (App)context.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)context, (lookTargetAccessor, attackTargetAccessor, attackCooldownAccessor, visibleMobsAccessor) -> (serverLevel, livingEntity, l) -> {
            LivingEntity target = (LivingEntity)context.get(attackTargetAccessor);
            if (livingEntity instanceof PokemonEntity) {
                PokemonEntity pokemonEntity = (PokemonEntity)livingEntity;
                pokemonEntity.setTarget(target);
                int attackTime = FOFPokemonAttackTask.getAttackTime(pokemonEntity);
                if (PokemonUtils.shouldMelee(pokemonEntity) && FOFPokemonAttackTask.sharedStartCondition(pokemonEntity)) {
                    FOFPokemonMeleeTask.tryQuickApproach(pokemonEntity, target);
                    if (FOFPokemonMeleeTask.canPerformAttack(pokemonEntity, target) && attackTime <= 0) {
                        lookTargetAccessor.set((Object)new EntityTracker((Entity)target, true));
                        FOFPokemonAttackTask.resetAttackTime(pokemonEntity, 0.0);
                        pokemonEntity.swing(InteractionHand.MAIN_HAND);
                        FOFPokemonMeleeTask.pokemonDoHurtTarget(pokemonEntity, target);
                        ((PokemonInterface)pokemonEntity).setAttackTime(cooldownBetweenAttacks);
                        attackCooldownAccessor.setWithExpiry((Object)true, (long)cooldownBetweenAttacks);
                        return true;
                    }
                }
            }
            return false;
        }));
    }

    protected static boolean canPerformAttack(PokemonEntity pokemonEntity, LivingEntity entity) {
        return pokemonEntity.isWithinMeleeAttackRange(entity) && pokemonEntity.getSensing().hasLineOfSight((Entity)entity);
    }

    protected static boolean pokemonDoHurtTarget(PokemonEntity pokemonEntity, LivingEntity hurtTarget) {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && FOFPokemonAttackTask.isTargetInBattle(pokemonEntity)) {
            return false;
        }
        if (!PokemonUtils.pokemonTryForceEncounter(pokemonEntity, (Entity)hurtTarget)) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null && Arrays.stream(CobblemonFightOrFlight.moveConfig().self_centered_aoe_moves).toList().contains(move.getName())) {
                PokemonAttackEffect.dealAoEDamage(pokemonEntity, (Entity)pokemonEntity, true, PokemonUtils.isMeleeAttackMove(move));
                if (PokemonUtils.isPhysicalMove(move)) {
                    PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
                } else {
                    PokemonUtils.sendAnimationPacket(pokemonEntity, "special");
                }
                return true;
            }
            PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
            return PokemonAttackEffect.pokemonAttack(pokemonEntity, (Entity)hurtTarget);
        }
        return false;
    }

    protected static void tryQuickApproach(PokemonEntity pokemonEntity, LivingEntity target) {
        Move move;
        if (target != null && FOFPokemonAttackTask.getAttackTime(pokemonEntity) == 0 && (move = PokemonUtils.getMove(pokemonEntity)) != null) {
            float distance;
            String moveName = move.getName();
            if (Arrays.stream(CobblemonFightOrFlight.moveConfig().quick_attack_like_move).toList().contains(moveName) && (distance = pokemonEntity.distanceTo((Entity)target)) >= 1.5f && distance <= 10.0f) {
                BlockPos targetBlockPos = target.blockPosition();
                if (FOFUtils.multiSamplingCollisionCheckBlock((LivingEntity)pokemonEntity, target, 5, 3)) {
                    PokemonUtils.makeParticle(4, (Entity)pokemonEntity, ParticleTypes.WHITE_SMOKE);
                    pokemonEntity.teleportTo((double)targetBlockPos.getX(), (double)targetBlockPos.getY(), (double)targetBlockPos.getZ());
                    PokemonUtils.makeParticle(4, (Entity)target, ParticleTypes.WHITE_SMOKE);
                }
            }
        }
    }
}

