/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.ai.sensors;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Optional;
import java.util.Set;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.jetbrains.annotations.NotNull;

public class PokemonHelpOwnerSensor
extends Sensor<PokemonEntity> {
    private static final int REFRESH_RATE = 1200;

    public PokemonHelpOwnerSensor() {
        super(10);
    }

    protected void doTick(ServerLevel level, PokemonEntity entity) {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_owner) {
            return;
        }
        LivingEntity owner = entity.getOwner();
        if (owner != null) {
            entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).ifPresent(visibleLivingEntities -> this.setNearestTarget(entity, (NearestVisibleLivingEntities)visibleLivingEntities, owner));
        }
    }

    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return Set.of(MemoryModuleType.ATTACK_TARGET, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    private void setNearestTarget(PokemonEntity pokemonEntity, NearestVisibleLivingEntities visibleMobs, LivingEntity owner) {
        int ownerLastHurtTick = ((PokemonInterface)pokemonEntity).getOwnerLastHurtTick();
        LivingEntity ownerLastHurtTarget = ((PokemonInterface)pokemonEntity).getOwnerLastHurt();
        if (ownerLastHurtTarget != null && ownerLastHurtTarget.isAlive() && pokemonEntity.tickCount - ownerLastHurtTick < 1200) {
            pokemonEntity.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)ownerLastHurtTarget);
            return;
        }
        Optional nearestAttacker = visibleMobs.findClosest(livingEntity -> {
            PokemonEntity pokemonEntity1;
            LivingEntity lastHurtByMob = livingEntity.getLastHurtByMob();
            if (lastHurtByMob instanceof PokemonEntity && (pokemonEntity1 = (PokemonEntity)lastHurtByMob).getPokemon().getShiny() && !pokemonEntity1.getPokemon().isPlayerOwned() && CobblemonFightOrFlight.commonConfig().not_attacking_wild_shiny) {
                return false;
            }
            return lastHurtByMob != null && lastHurtByMob.is((Entity)owner);
        });
        LivingEntity livingEntity2 = nearestAttacker.orElse(null);
        ((PokemonInterface)pokemonEntity).setOwnerLastHurt(livingEntity2);
        if (livingEntity2 != null) {
            pokemonEntity.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, nearestAttacker);
        }
    }
}

