/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.ai.sensors;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;

public class PokeStaffAttackTargetSensor
extends Sensor<PokemonEntity> {
    String targetUUID;

    public PokeStaffAttackTargetSensor() {
        super(10);
    }

    protected void doTick(ServerLevel level, PokemonEntity entity) {
        if (!CobblemonFightOrFlight.commonConfig().can_use_poke_staff) {
            return;
        }
        LivingEntity owner = entity.getOwner();
        if (owner instanceof Player && !entity.isBusy() && this.tryLoadingCommandData(entity)) {
            entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).ifPresent(visibleLivingEntities -> this.setTarget(entity, (NearestVisibleLivingEntities)visibleLivingEntities));
        }
    }

    public Set<MemoryModuleType<?>> requires() {
        return Set.of(MemoryModuleType.ATTACK_TARGET, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    private boolean tryLoadingCommandData(PokemonEntity pokemonEntity) {
        Pattern pattern;
        Matcher m;
        String data;
        if (PokemonUtils.getCommandMode(pokemonEntity).equals((Object)PokeStaffComponent.CMDMODE.ATTACK) && (data = ((PokemonInterface)pokemonEntity).getCommandData()).startsWith("ENTITY_") && (m = (pattern = Pattern.compile("ENTITY_([a-z\\d]{8}-[a-z\\d]{4}-[a-z\\d]{4}-[a-z\\d]{4}-[a-z\\d]{12})")).matcher(data)).find()) {
            this.targetUUID = m.group(1);
            return true;
        }
        return false;
    }

    private void setTarget(PokemonEntity pokemonEntity, NearestVisibleLivingEntities entities) {
        Optional targetOpt = entities.findClosest(livingEntity -> livingEntity.getStringUUID().equals(this.targetUUID));
        targetOpt.ifPresent(livingEntity -> pokemonEntity.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, livingEntity));
    }
}

