/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.PokemonArrow;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PokemonArrowRenderer
extends EntityRenderer<PokemonArrow> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/arrow_bullet.png");

    public PokemonArrowRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(PokemonArrow entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Color color = Color.white;
        if (entity.getElementalType() != null) {
            color = PokemonAttackEffect.getColorFromType(entity.getElementalType());
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        boolean i = false;
        float f = 0.0f;
        float g = 0.5f;
        float h = 0.0f;
        float j = 0.15625f;
        float k = 0.0f;
        float l = 0.15625f;
        float m = 0.15625f;
        float n = 0.3125f;
        float o = 0.05625f;
        float p = 0.0f - partialTicks;
        if (p > 0.0f) {
            float q = -Mth.sin((float)(p * 3.0f)) * p;
            poseStack.mulPose(Axis.ZP.rotationDegrees(q));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        poseStack.scale(0.05625f, 0.05625f, 0.05625f);
        poseStack.translate(-4.0f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
        PoseStack.Pose pose = poseStack.last();
        this.vertex(pose, vertexConsumer, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, packedLight, color);
        this.vertex(pose, vertexConsumer, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, packedLight, color);
        this.vertex(pose, vertexConsumer, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, packedLight, color);
        this.vertex(pose, vertexConsumer, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, packedLight, color);
        this.vertex(pose, vertexConsumer, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, packedLight, color);
        this.vertex(pose, vertexConsumer, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, packedLight, color);
        this.vertex(pose, vertexConsumer, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, packedLight, color);
        this.vertex(pose, vertexConsumer, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, packedLight, color);
        for (int r = 0; r < 4; ++r) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.vertex(pose, vertexConsumer, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, packedLight, color);
            this.vertex(pose, vertexConsumer, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, packedLight, color);
            this.vertex(pose, vertexConsumer, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, packedLight, color);
            this.vertex(pose, vertexConsumer, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, packedLight, color);
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer consumer, int x, int y, int z, float u, float v, int normalX, int normalZ, int normalY, int packedLight, Color col) {
        consumer.addVertex(pose, (float)x, (float)y, (float)z).setColor(col.getRed(), col.getGreen(), col.getBlue(), 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)normalX, (float)normalY, (float)normalZ);
    }

    public ResourceLocation getTextureLocation(PokemonArrow entity) {
        return TEXTURE_LOCATION;
    }
}

