/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.Objects;
import me.rufia.fightorflight.client.model.PokemonAreaEffectWhirlpoolModel;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.areaeffect.AbstractPokemonAreaEffect;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class PokemonAreaEffectWhirlpoolRenderer
extends EntityRenderer<AbstractPokemonAreaEffect> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/whirlpool.png");
    private final PokemonAreaEffectWhirlpoolModel<AbstractPokemonAreaEffect> model;

    public PokemonAreaEffectWhirlpoolRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PokemonAreaEffectWhirlpoolModel(context.bakeLayer(PokemonAreaEffectWhirlpoolModel.LAYER_LOCATION));
    }

    public void render(AbstractPokemonAreaEffect entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean isWaiting = entity.isWaiting();
        String typeName = entity.getElementalType();
        poseStack.pushPose();
        float tick = (float)entity.tickCount + partialTicks;
        float d = entity.getRadius() * 2.0f;
        float rotSpeed = isWaiting ? 0.2f : (entity.isActivated() ? 0.1f : 0.3f);
        poseStack.scale(d, d, d);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.cos((float)(tick * rotSpeed)) * 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.translate(0.0, -1.5, 0.0);
        VertexConsumer vertexConsumer = buffer.getBuffer(this.model.renderType(TEXTURE_LOCATION));
        Color color = PokemonAttackEffect.getColorFromType(entity.getElementalType());
        int colorCode = FastColor.ARGB32.colorFromFloat((float)0.4f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        int secColorCode = this.getSecondaryColorCode(typeName);
        this.model.renderPane(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
        this.model.renderSecondaryPane(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, secColorCode);
        poseStack.translate(0.0, -0.05, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.cos((float)(tick * rotSpeed * 0.3f)) * 180.0f));
        if (!isWaiting) {
            this.model.renderEffect(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode, secColorCode);
        }
        poseStack.popPose();
    }

    public int getSecondaryColorCode(String typeName) {
        Color color = Color.WHITE;
        if (Objects.equals(typeName, "Fire")) {
            color = Color.ORANGE;
        }
        return FastColor.ARGB32.colorFromFloat((float)0.4f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
    }

    public ResourceLocation getTextureLocation(AbstractPokemonAreaEffect entity) {
        return TEXTURE_LOCATION;
    }
}

