/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import me.rufia.fightorflight.client.model.PokemonAreaEffectMagicModel;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.areaeffect.PokemonAreaEffectMagic;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class PokemonAreaEffectMagicRenderer
extends EntityRenderer<PokemonAreaEffectMagic>
implements RenderLayerParent<PokemonAreaEffectMagic, PokemonAreaEffectMagicModel<PokemonAreaEffectMagic>> {
    private static final ResourceLocation LIGHTNING_TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/lightning.png");
    private static final ResourceLocation ERUPTION_TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/eruption.png");
    private static final ResourceLocation MAGIC_TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/magic.png");
    private static final ResourceLocation ERUPTION_FIRE_TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/eruption_fire.png");
    private static final List<String> specialTypes = Arrays.asList("Fire", "Ground", "Electric");
    private final PokemonAreaEffectMagicModel<PokemonAreaEffectMagic> model;

    public PokemonAreaEffectMagicRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PokemonAreaEffectMagicModel(context.bakeLayer(PokemonAreaEffectMagicModel.LAYER_LOCATION));
    }

    public void render(PokemonAreaEffectMagic entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean isWaiting = entity.isWaiting();
        poseStack.pushPose();
        float d = entity.getRadius() * 2.0f;
        poseStack.scale(d, d, d);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.translate(0.0, -0.05, 0.0);
        VertexConsumer vertexConsumer = buffer.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        Color color = PokemonAreaEffectMagicRenderer.getColor(entity);
        int colorCode = FastColor.ARGB32.colorFromFloat((float)0.4f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        this.model.renderBottom(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
        if (!isWaiting) {
            int waitTime = entity.getWaitTime();
            float tick = (float)entity.tickCount + partialTicks - (float)waitTime;
            if (entity.getElementalType().equals("Electric")) {
                poseStack.translate(0.0f, -2.0f, 0.0f);
                float yScale = Mth.clampedLerp((float)0.2f, (float)1.0f, (float)(tick / 4.0f));
                poseStack.scale(1.0f, yScale, 1.0f);
                this.model.renderBeam(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
            } else {
                float yScale = -Mth.clampedLerp((float)0.2f, (float)1.0f, (float)(tick / 4.0f));
                poseStack.translate(0.0, 0.2, 0.0);
                poseStack.scale(1.0f, yScale, 1.0f);
                this.model.renderBeam(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
                VertexConsumer vertexConsumer1 = buffer.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)ERUPTION_FIRE_TEXTURE_LOCATION));
                this.model.renderBeam(poseStack, vertexConsumer1, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
            }
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(PokemonAreaEffectMagic entity) {
        String typeName;
        return switch (typeName = entity.getElementalType()) {
            case "Electric" -> LIGHTNING_TEXTURE_LOCATION;
            case "Ground", "Fire" -> ERUPTION_TEXTURE_LOCATION;
            default -> MAGIC_TEXTURE_LOCATION;
        };
    }

    public static boolean hasSpecialTexture(PokemonAreaEffectMagic entity) {
        String typeName = entity.getElementalType();
        return specialTypes.contains(typeName);
    }

    public static Color getColor(PokemonAreaEffectMagic entity) {
        return PokemonAreaEffectMagicRenderer.hasSpecialTexture(entity) ? Color.WHITE : PokemonAttackEffect.getColorFromType(entity.getElementalType());
    }

    public PokemonAreaEffectMagicModel<PokemonAreaEffectMagic> getModel() {
        return this.model;
    }
}

