/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.network.MessageRequestRedstoneUpdate;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class VoltmeterItem
extends IEBaseItem {
    public static RemoteEnergyData lastEnergyUpdate = new RemoteEnergyData((Either<BlockPos, Integer>)Either.left((Object)BlockPos.ZERO), 0L, false, 0, 0);
    public static RemoteRedstoneData lastRedstoneUpdate = new RemoteRedstoneData(BlockPos.ZERO, 0L, false, 0);

    public VoltmeterItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, ctx, tooltip, flagIn);
        WireLink link = (WireLink)stack.get(IEApiDataComponents.WIRE_LINK);
        if (link != null) {
            tooltip.add((Component)Component.translatable((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link.cp().getX(), link.cp().getY(), link.cp().getZ(), link.dimension().toString()}));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        IEnergyStorage energyCap;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (!(player != null && player.isShiftKeyDown() || (energyCap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, null)) == null)) {
            int max = energyCap.getMaxEnergyStored();
            int stored = energyCap.getEnergyStored();
            if (max > 0) {
                ChatUtils.sendServerNoSpamMessages(player, (Component)Component.translatable((String)"chat.immersiveengineering.info.energyStorage", (Object[])new Object[]{stored, max}));
            }
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.isShiftKeyDown()) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!VoltmeterItem.measureLoss(level, pos, player, context)) {
                ChatUtils.sendServerNoSpamMessages(player, (Component)Component.translatable((String)"chat.immersiveengineering.info.redstone_level", (Object[])new Object[]{MessageRequestRedstoneUpdate.redstoneLevel(level, pos)}));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean measureLoss(Level level, BlockPos pos, Player player, UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        BlockEntity bEntity = level.getBlockEntity(pos);
        if (!(bEntity instanceof IImmersiveConnectable)) {
            return false;
        }
        TargetingInfo targetingInfo = new TargetingInfo(context);
        BlockPos masterPos = ((IImmersiveConnectable)bEntity).getConnectionMaster(null, targetingInfo);
        BlockPos delta = pos.subtract((Vec3i)masterPos);
        ConnectionPoint cp = ((IImmersiveConnectable)bEntity).getTargetedPoint(targetingInfo, (Vec3i)delta);
        if (cp == null) {
            return false;
        }
        GlobalWireNetwork global = GlobalWireNetwork.getNetwork(level);
        LocalWireNetwork netHere = global.getNullableLocalNet(cp);
        EnergyTransferHandler energyHandler = netHere.getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class);
        if (energyHandler == null) {
            return false;
        }
        if (!stack.has(IEApiDataComponents.WIRE_LINK)) {
            stack.set(IEApiDataComponents.WIRE_LINK, (Object)WireLink.create(cp, level, delta, targetingInfo));
        } else {
            LocalWireNetwork netLink;
            WireLink link = (WireLink)stack.remove(IEApiDataComponents.WIRE_LINK);
            if (link.dimension().equals((Object)level.dimension()) && netHere == (netLink = global.getNullableLocalNet(link.cp()))) {
                EnergyTransferHandler.Path energyPath = energyHandler.getPath(link.cp(), cp);
                double loss = energyPath != null ? energyPath.loss : 1.0;
                player.sendSystemMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.averageLoss", (Object[])new Object[]{Utils.formatDouble(loss * 100.0, "###.000")}));
            }
        }
        return true;
    }

    public record RemoteEnergyData(Either<BlockPos, Integer> pos, long measuredInTick, boolean isValid, int stored, int capacity) {
        public static final StreamCodec<ByteBuf, RemoteEnergyData> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)BlockPos.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), RemoteEnergyData::pos, (StreamCodec)ByteBufCodecs.VAR_LONG, RemoteEnergyData::measuredInTick, (StreamCodec)ByteBufCodecs.BOOL, RemoteEnergyData::isValid, (StreamCodec)ByteBufCodecs.INT, RemoteEnergyData::stored, (StreamCodec)ByteBufCodecs.INT, RemoteEnergyData::capacity, RemoteEnergyData::new);
    }

    public record RemoteRedstoneData(BlockPos pos, long measuredInTick, boolean isSignalSource, FastEither<Byte, Pair<DyeColor, Byte>[]> rsLevels) {
        private static final StreamCodec<ByteBuf, Pair<DyeColor, Byte>[]> LEVEL_ARRAY_CODEC = StreamCodec.of((buffer, pairs) -> {
            ByteBufCodecs.writeCount((ByteBuf)buffer, (int)((Pair[])pairs).length, (int)16);
            for (Pair v : pairs) {
                DyeColor.STREAM_CODEC.encode(buffer, (Object)((DyeColor)v.getFirst()));
                ByteBufCodecs.BYTE.encode(buffer, (Object)((Byte)v.getSecond()));
            }
        }, buffer -> {
            int readCount = ByteBufCodecs.readCount((ByteBuf)buffer, (int)16);
            Pair[] array = new Pair[readCount];
            for (int j = 0; j < readCount; ++j) {
                array[j] = Pair.of((Object)((DyeColor)DyeColor.STREAM_CODEC.decode(buffer)), (Object)((Byte)ByteBufCodecs.BYTE.decode(buffer)));
            }
            return array;
        });
        public static final StreamCodec<ByteBuf, RemoteRedstoneData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RemoteRedstoneData::pos, (StreamCodec)ByteBufCodecs.VAR_LONG, RemoteRedstoneData::measuredInTick, (StreamCodec)ByteBufCodecs.BOOL, RemoteRedstoneData::isSignalSource, FastEither.streamCodec(ByteBufCodecs.BYTE, LEVEL_ARRAY_CODEC), RemoteRedstoneData::rsLevels, RemoteRedstoneData::new);

        public RemoteRedstoneData(BlockPos pos, long measuredInTick, boolean isSignalSource, byte rsLevel) {
            this(pos, measuredInTick, isSignalSource, FastEither.left(rsLevel));
        }

        public RemoteRedstoneData(BlockPos pos, long measuredInTick, boolean isSignalSource, Pair<DyeColor, Byte>[] rsLevel) {
            this(pos, measuredInTick, isSignalSource, FastEither.right(rsLevel));
        }
    }
}

