/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.wires.IEWireTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class EnergyConnectorBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
EnergyTransferHandler.EnergyConnector,
IEServerTickableBE {
    public static final Map<Pair<String, Boolean>, Supplier<BlockEntityType<EnergyConnectorBlockEntity>>> SPEC_TO_TYPE = new HashMap<Pair<String, Boolean>, Supplier<BlockEntityType<EnergyConnectorBlockEntity>>>();
    public static final Map<ResourceLocation, Pair<String, Boolean>> NAME_TO_SPEC = new HashMap<ResourceLocation, Pair<String, Boolean>>();
    private final String voltage;
    private final boolean relay;
    public int currentTickToMachine = 0;
    public int currentTickToNet = 0;
    private final MutableEnergyStorage storageToNet;
    private final MutableEnergyStorage storageToMachine;
    private final IEnergyStorage energyCap;
    private final IEBlockCapabilityCaches.IEBlockCapabilityCache<IEnergyStorage> output = IEBlockCapabilityCaches.forNeighbor(Capabilities.EnergyStorage.BLOCK, this, this::getFacing);
    private static final Object2FloatMap<Pair<String, Boolean>> LENGTH = new Object2FloatArrayMap();

    public static void registerConnectorTEs(DeferredRegister<BlockEntityType<?>> event) {
        for (String type : new String[]{"LV", "MV", "HV"}) {
            for (int b = 0; b < 2; ++b) {
                boolean relay = b != 0;
                Pair key = Pair.of((Object)type, (Object)relay);
                String name = type.toLowerCase(Locale.US) + "_" + (relay ? "relay" : "conn");
                DeferredHolder teType = event.register(name, () -> new BlockEntityType((pos, state) -> new EnergyConnectorBlockEntity(type, relay, pos, state), (Set)ImmutableSet.of(IEBlocks.Connectors.ENERGY_CONNECTORS.get(key).get()), null));
                SPEC_TO_TYPE.put((Pair<String, Boolean>)key, (Supplier<BlockEntityType<EnergyConnectorBlockEntity>>)teType);
                NAME_TO_SPEC.put(ImmersiveEngineering.rl(name), (Pair<String, Boolean>)key);
            }
        }
    }

    public EnergyConnectorBlockEntity(BlockEntityType<? extends EnergyConnectorBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Pair<String, Boolean> data = NAME_TO_SPEC.get(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(type));
        this.voltage = (String)data.getFirst();
        this.relay = (Boolean)data.getSecond();
        this.storageToMachine = new MutableEnergyStorage(this.getMaxInput(), this.getMaxInput(), this.getMaxInput());
        this.storageToNet = new MutableEnergyStorage(this.getMaxInput(), this.getMaxInput(), this.getMaxInput());
        this.energyCap = new ConnectorEnergyStorage();
    }

    public EnergyConnectorBlockEntity(String voltage, boolean relay, BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends EnergyConnectorBlockEntity>)SPEC_TO_TYPE.get(Pair.of((Object)voltage, (Object)relay)).get(), pos, state);
    }

    @Override
    public void tickServer() {
        IEnergyStorage target;
        int maxOut = Math.min(this.storageToMachine.getEnergyStored(), this.getMaxOutput() - this.currentTickToMachine);
        if (maxOut > 0 && (target = this.output.getCapability()) != null) {
            int inserted = target.receiveEnergy(maxOut, false);
            this.storageToMachine.extractEnergy(inserted, false);
        }
        this.currentTickToMachine = 0;
        this.currentTickToNet = 0;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return ConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local;
        if (!this.relay && (local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.worldPosition, 0))) != null && !local.getConnections(this.worldPosition).isEmpty()) {
            return false;
        }
        return this.voltage.equals(cableType.getCategory());
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        CompoundTag toNet = new CompoundTag();
        EnergyHelper.serializeTo(this.storageToNet, toNet, provider);
        nbt.put("toNet", (Tag)toNet);
        CompoundTag toMachine = new CompoundTag();
        EnergyHelper.serializeTo(this.storageToMachine, toMachine, provider);
        nbt.put("toMachine", (Tag)toMachine);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        CompoundTag toMachine = nbt.getCompound("toMachine");
        EnergyHelper.deserializeFrom(this.storageToMachine, toMachine, provider);
        CompoundTag toNet = nbt.getCompound("toNet");
        EnergyHelper.deserializeFrom(this.storageToNet, toNet, provider);
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().getOpposite();
        double lengthFromHalf = (double)LENGTH.getFloat((Object)Pair.of((Object)this.voltage, (Object)this.relay)) - type.getRenderDiameter() / 2.0 - 0.5;
        return new Vec3(0.5 + lengthFromHalf * (double)side.getStepX(), 0.5 + lengthFromHalf * (double)side.getStepY(), 0.5 + lengthFromHalf * (double)side.getStepZ());
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        SPEC_TO_TYPE.forEach((spec, type) -> {
            if (!((Boolean)spec.getSecond()).booleanValue()) {
                event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)type.get(), (be, side) -> side == null || side == be.getFacing() ? be.energyCap : null);
            }
        });
    }

    private IEWireTypes.IEWireType getWireType() {
        if ("LV".equals(this.voltage)) {
            return IEWireTypes.IEWireType.COPPER;
        }
        if ("MV".equals(this.voltage)) {
            return IEWireTypes.IEWireType.ELECTRUM;
        }
        return IEWireTypes.IEWireType.STEEL;
    }

    public int getMaxInput() {
        return IEServerConfig.getOrDefault(IEServerConfig.WIRES.energyWireConfigs.get((Object)((Object)this.getWireType())).connectorRate);
    }

    public int getMaxOutput() {
        return IEServerConfig.getOrDefault(IEServerConfig.WIRES.energyWireConfigs.get((Object)((Object)this.getWireType())).connectorRate);
    }

    public static VoxelShape getConnectorBounds(Direction facing, float length) {
        float wMin = 0.3125f;
        float wMax = 0.6875f;
        return switch (facing.getOpposite()) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)length, (double)0.6875);
            case Direction.DOWN -> Shapes.box((double)0.3125, (double)(1.0f - length), (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
            case Direction.SOUTH -> Shapes.box((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)length);
            case Direction.NORTH -> Shapes.box((double)0.3125, (double)0.3125, (double)(1.0f - length), (double)0.6875, (double)0.6875, (double)1.0);
            case Direction.EAST -> Shapes.box((double)0.0, (double)0.3125, (double)0.3125, (double)length, (double)0.6875, (double)0.6875);
            case Direction.WEST -> Shapes.box((double)(1.0f - length), (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875);
        };
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        float length = LENGTH.getFloat((Object)Pair.of((Object)this.voltage, (Object)this.relay));
        return EnergyConnectorBlockEntity.getConnectorBounds(this.getFacing(), length);
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return !this.relay;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return !this.relay;
    }

    @Override
    public int getAvailableEnergy() {
        return this.storageToNet.getEnergyStored();
    }

    @Override
    public int getRequestedEnergy() {
        return this.storageToMachine.getMaxEnergyStored() - this.storageToMachine.getEnergyStored();
    }

    @Override
    public void insertEnergy(int amount) {
        this.storageToMachine.receiveEnergy(amount, false);
    }

    @Override
    public void extractEnergy(int amount) {
        this.storageToNet.extractEnergy(amount, false);
    }

    @Override
    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)EnergyTransferHandler.ID);
    }

    static {
        LENGTH.put((Object)Pair.of((Object)"HV", (Object)false), 0.75f);
        LENGTH.put((Object)Pair.of((Object)"HV", (Object)true), 0.875f);
        LENGTH.put((Object)Pair.of((Object)"MV", (Object)false), 0.5625f);
        LENGTH.defaultReturnValue(0.5f);
    }

    private class ConnectorEnergyStorage
    implements IEnergyStorage {
        private ConnectorEnergyStorage() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (((EnergyConnectorBlockEntity)EnergyConnectorBlockEntity.this).level.isClientSide || EnergyConnectorBlockEntity.this.relay) {
                return 0;
            }
            maxReceive = Math.min(EnergyConnectorBlockEntity.this.getMaxInput() - EnergyConnectorBlockEntity.this.currentTickToNet, maxReceive);
            if (maxReceive <= 0) {
                return 0;
            }
            int accepted = Math.min(Math.min(EnergyConnectorBlockEntity.this.getMaxOutput(), EnergyConnectorBlockEntity.this.getMaxInput()), maxReceive);
            accepted = Math.min(EnergyConnectorBlockEntity.this.getMaxOutput() - EnergyConnectorBlockEntity.this.storageToNet.getEnergyStored(), accepted);
            if (accepted <= 0) {
                return 0;
            }
            if (!simulate) {
                EnergyConnectorBlockEntity.this.storageToNet.modifyEnergyStored(accepted);
                EnergyConnectorBlockEntity.this.currentTickToNet += accepted;
                EnergyConnectorBlockEntity.this.setChanged();
            }
            return accepted;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return EnergyConnectorBlockEntity.this.storageToMachine.extractEnergy(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return EnergyConnectorBlockEntity.this.storageToNet.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return EnergyConnectorBlockEntity.this.storageToNet.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

