/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.utilities;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.utilities.CobbleworkersInventoryUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JC\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062$\u0010\f\u001a \u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n0\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010 \u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0014\u0010!\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b!\u0010\"R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020$0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&\u00a8\u0006)"}, d2={"Laccieo/cobbleworkers/utilities/DeferredBlockScanner;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pastureOrigin", "", "Laccieo/cobbleworkers/enums/JobType;", "Lkotlin/Function2;", "", "jobValidators", "", "tickPastureAreaScan", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Ljava/util/Map;)V", "isScanActive", "(Lnet/minecraft/core/BlockPos;)Z", "", "currentTick", "clearExpiredCompletions", "(J)V", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GeneralGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$GeneralGroup;", "", "getBLOCKS_PER_TICK", "()I", "BLOCKS_PER_TICK", "getSearchRadius", "searchRadius", "getSearchHeight", "searchHeight", "SCAN_COOLDOWN_TICKS", "J", "", "Laccieo/cobbleworkers/utilities/DeferredBlockScanner$ScanJob;", "activeScans", "Ljava/util/Map;", "lastScanCompletion", "ScanJob", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nDeferredBlockScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeferredBlockScanner.kt\naccieo/cobbleworkers/utilities/DeferredBlockScanner\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,100:1\n384#2,7:101\n*S KotlinDebug\n*F\n+ 1 DeferredBlockScanner.kt\naccieo/cobbleworkers/utilities/DeferredBlockScanner\n*L\n49#1:101,7\n*E\n"})
public final class DeferredBlockScanner {
    @NotNull
    public static final DeferredBlockScanner INSTANCE = new DeferredBlockScanner();
    @NotNull
    private static final CobbleworkersConfig.GeneralGroup config = CobbleworkersConfigHolder.INSTANCE.getConfig().getGeneral();
    private static final long SCAN_COOLDOWN_TICKS = 1200L;
    @NotNull
    private static final Map<BlockPos, ScanJob> activeScans = new LinkedHashMap();
    @NotNull
    private static final Map<BlockPos, Long> lastScanCompletion = new LinkedHashMap();

    private DeferredBlockScanner() {
    }

    private final int getBLOCKS_PER_TICK() {
        return config.getBlocksScannedPerTick();
    }

    private final int getSearchRadius() {
        return config.getSearchRadius();
    }

    private final int getSearchHeight() {
        return config.getSearchHeight();
    }

    public final void tickPastureAreaScan(@NotNull Level world, @NotNull BlockPos pastureOrigin, @NotNull Map<JobType, ? extends Function2<? super Level, ? super BlockPos, Boolean>> jobValidators) {
        ScanJob scanJob;
        ScanJob scanJob2;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pastureOrigin, (String)"pastureOrigin");
        Intrinsics.checkNotNullParameter(jobValidators, (String)"jobValidators");
        long currentTick = world.getGameTime();
        this.clearExpiredCompletions(currentTick);
        Long l = lastScanCompletion.get(pastureOrigin);
        if (l != null) {
            long lastTick = ((Number)l).longValue();
            boolean bl = false;
            if (currentTick - lastTick < 1200L) {
                return;
            }
        }
        Map<BlockPos, ScanJob> $this$getOrPut$iv = activeScans;
        boolean $i$f$getOrPut = false;
        ScanJob value$iv = $this$getOrPut$iv.get(pastureOrigin);
        if (value$iv == null) {
            boolean bl = false;
            CobbleworkersCacheManager.INSTANCE.removeTargets(pastureOrigin);
            double radius = INSTANCE.getSearchRadius();
            double height = INSTANCE.getSearchHeight();
            AABB searchArea = new AABB(pastureOrigin).inflate(radius, height, radius);
            Iterator iterator = BlockPos.betweenClosedStream((AABB)searchArea).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            ScanJob answer$iv = new ScanJob(iterator, currentTick - 1L);
            $this$getOrPut$iv.put(pastureOrigin, answer$iv);
            scanJob2 = answer$iv;
        } else {
            scanJob2 = value$iv;
        }
        if ((scanJob = scanJob2).getLastTickProcessed() == currentTick) {
            return;
        }
        scanJob.setLastTickProcessed(currentTick);
        int n = this.getBLOCKS_PER_TICK();
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            if (!scanJob.getIterator().hasNext()) {
                activeScans.remove(pastureOrigin);
                Long radius = currentTick;
                lastScanCompletion.put(pastureOrigin, radius);
                return;
            }
            BlockPos pos = scanJob.getIterator().next();
            boolean isValidInventory = CobbleworkersInventoryUtils.INSTANCE.blockValidator(world, pos);
            if (isValidInventory) {
                BlockPos blockPos = pos.immutable();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"toImmutable(...)");
                CobbleworkersCacheManager.INSTANCE.addTarget(pastureOrigin, JobType.Generic, blockPos);
            }
            for (Map.Entry<JobType, ? extends Function2<? super Level, ? super BlockPos, Boolean>> entry : jobValidators.entrySet()) {
                JobType jobType = entry.getKey();
                Function2<? super Level, ? super BlockPos, Boolean> validator = entry.getValue();
                if (!((Boolean)validator.invoke((Object)world, (Object)pos)).booleanValue()) continue;
                BlockPos blockPos = pos.immutable();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"toImmutable(...)");
                CobbleworkersCacheManager.INSTANCE.addTarget(pastureOrigin, jobType, blockPos);
            }
        }
    }

    public final boolean isScanActive(@NotNull BlockPos pastureOrigin) {
        Intrinsics.checkNotNullParameter((Object)pastureOrigin, (String)"pastureOrigin");
        return activeScans.containsKey(pastureOrigin);
    }

    private final void clearExpiredCompletions(long currentTick) {
        Iterator<Map.Entry<BlockPos, Long>> iterator = lastScanCompletion.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Long> entry = iterator.next();
            if (currentTick - ((Number)entry.getValue()).longValue() < 1200L) continue;
            iterator.remove();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ*\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001a\u0010\nR\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Laccieo/cobbleworkers/utilities/DeferredBlockScanner$ScanJob;", "", "", "Lnet/minecraft/core/BlockPos;", "iterator", "", "lastTickProcessed", "<init>", "(Ljava/util/Iterator;J)V", "component1", "()Ljava/util/Iterator;", "component2", "()J", "copy", "(Ljava/util/Iterator;J)Laccieo/cobbleworkers/utilities/DeferredBlockScanner$ScanJob;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/Iterator;", "getIterator", "J", "getLastTickProcessed", "setLastTickProcessed", "(J)V", "cobbleworkers-common"})
    private static final class ScanJob {
        @NotNull
        private final Iterator<BlockPos> iterator;
        private long lastTickProcessed;

        public ScanJob(@NotNull Iterator<? extends BlockPos> iterator, long lastTickProcessed) {
            Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
            this.iterator = iterator;
            this.lastTickProcessed = lastTickProcessed;
        }

        @NotNull
        public final Iterator<BlockPos> getIterator() {
            return this.iterator;
        }

        public final long getLastTickProcessed() {
            return this.lastTickProcessed;
        }

        public final void setLastTickProcessed(long l) {
            this.lastTickProcessed = l;
        }

        @NotNull
        public final Iterator<BlockPos> component1() {
            return this.iterator;
        }

        public final long component2() {
            return this.lastTickProcessed;
        }

        @NotNull
        public final ScanJob copy(@NotNull Iterator<? extends BlockPos> iterator, long lastTickProcessed) {
            Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
            return new ScanJob(iterator, lastTickProcessed);
        }

        public static /* synthetic */ ScanJob copy$default(ScanJob scanJob, Iterator iterator, long l, int n, Object object) {
            if ((n & 1) != 0) {
                iterator = scanJob.iterator;
            }
            if ((n & 2) != 0) {
                l = scanJob.lastTickProcessed;
            }
            return scanJob.copy(iterator, l);
        }

        @NotNull
        public String toString() {
            return "ScanJob(iterator=" + this.iterator + ", lastTickProcessed=" + this.lastTickProcessed + ")";
        }

        public int hashCode() {
            int result = this.iterator.hashCode();
            result = result * 31 + Long.hashCode(this.lastTickProcessed);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScanJob)) {
                return false;
            }
            ScanJob scanJob = (ScanJob)other;
            if (!Intrinsics.areEqual(this.iterator, scanJob.iterator)) {
                return false;
            }
            return this.lastTickProcessed == scanJob.lastTickProcessed;
        }
    }
}

