/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.utilities;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.DeferredBlockScanner;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b!\u0010 J\u001f\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\"\u0010 Jg\u0010+\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010$\u001a\u00020#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0(0&2\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190&\u00a2\u0006\u0004\b+\u0010,R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Laccieo/cobbleworkers/utilities/CobbleworkersInventoryUtils;", "", "<init>", "()V", "", "Lnet/minecraft/world/level/block/Block;", "externalBlocks", "", "addCompatibility", "(Ljava/util/Set;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "", "blockValidator", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", "origin", "ignorePos", "findClosestInventory", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Ljava/util/Set;)Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/Container;", "inventory", "getActualInventory", "(Lnet/minecraft/world/Container;)Lnet/minecraft/world/Container;", "", "Lnet/minecraft/world/item/ItemStack;", "stacks", "insertStacks", "(Lnet/minecraft/world/Container;Ljava/util/List;)Ljava/util/List;", "stack", "insertStack", "(Lnet/minecraft/world/Container;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;", "fillEmptySlots", "fillExistingStacks", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "itemsToDeposit", "", "Ljava/util/UUID;", "", "failedDepositLocations", "heldItemsByPokemon", "handleDepositing", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "validInventoryBlocks", "Ljava/util/Set;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nCobbleworkersInventoryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbleworkersInventoryUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersInventoryUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,229:1\n774#2:230\n865#2,2:231\n2423#2,14:233\n1869#2,2:247\n1869#2,2:256\n384#3,7:249\n*S KotlinDebug\n*F\n+ 1 CobbleworkersInventoryUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersInventoryUtils\n*L\n64#1:230\n64#1:231,2\n67#1:233,14\n94#1:247,2\n197#1:256,2\n186#1:249,7\n*E\n"})
public final class CobbleworkersInventoryUtils {
    @NotNull
    public static final CobbleworkersInventoryUtils INSTANCE = new CobbleworkersInventoryUtils();
    @NotNull
    private static final Set<Block> validInventoryBlocks;

    private CobbleworkersInventoryUtils() {
    }

    public final void addCompatibility(@NotNull Set<? extends Block> externalBlocks) {
        Intrinsics.checkNotNullParameter(externalBlocks, (String)"externalBlocks");
        validInventoryBlocks.addAll((Collection<Block>)externalBlocks);
    }

    public final boolean blockValidator(@NotNull Level world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState state = world.getBlockState(pos);
        return validInventoryBlocks.contains(state.getBlock());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BlockPos findClosestInventory(@NotNull Level world, @NotNull BlockPos origin, @NotNull Set<? extends BlockPos> ignorePos) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(ignorePos, (String)"ignorePos");
        Set<BlockPos> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, JobType.Generic);
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BlockPos pos = (BlockPos)element$iv$iv;
            boolean bl = false;
            if (!(INSTANCE.blockValidator(world, pos) && !ignorePos.contains(pos))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BlockPos it = (BlockPos)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.distSqr((Vec3i)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    BlockPos it2 = (BlockPos)e$iv;
                    $i$a$-minByOrNull-CobbleworkersInventoryUtils$findClosestInventory$2 = false;
                    double v$iv = it2.distSqr((Vec3i)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public static /* synthetic */ BlockPos findClosestInventory$default(CobbleworkersInventoryUtils cobbleworkersInventoryUtils, Level level, BlockPos blockPos, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        return cobbleworkersInventoryUtils.findClosestInventory(level, blockPos, set);
    }

    @NotNull
    public final Container getActualInventory(@NotNull Container inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        if (!(inventory instanceof ChestBlockEntity)) {
            return inventory;
        }
        Level level = ((ChestBlockEntity)inventory).getLevel();
        if (level == null) {
            return inventory;
        }
        Level world = level;
        BlockPos pos = ((ChestBlockEntity)inventory).getBlockPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof ChestBlock) {
            Container container = ChestBlock.getContainer((ChestBlock)((ChestBlock)block), (BlockState)state, (Level)world, (BlockPos)pos, (boolean)true);
            if (container == null) {
                container = inventory;
            }
            return container;
        }
        return inventory;
    }

    @NotNull
    public final List<ItemStack> insertStacks(@NotNull Container inventory, @NotNull List<ItemStack> stacks) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter(stacks, (String)"stacks");
        Container actualInventory = this.getActualInventory(inventory);
        List remainingDrops = new ArrayList();
        Iterable $this$forEach$iv = stacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack stack = (ItemStack)element$iv;
            boolean bl = false;
            ItemStack itemStack = stack.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            ItemStack remaining = INSTANCE.insertStack(actualInventory, itemStack);
            if (remaining.isEmpty()) continue;
            remainingDrops.add(remaining);
        }
        return remainingDrops;
    }

    @NotNull
    public final ItemStack insertStack(@NotNull Container inventory, @NotNull ItemStack stack) {
        ItemStack remainingStack;
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.isEmpty()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack itemStack = remainingStack = stack.copy();
        Intrinsics.checkNotNull((Object)itemStack);
        remainingStack = this.fillExistingStacks(inventory, itemStack);
        if (!remainingStack.isEmpty()) {
            remainingStack = this.fillEmptySlots(inventory, remainingStack);
        }
        return remainingStack;
    }

    private final ItemStack fillEmptySlots(Container inventory, ItemStack stack) {
        int n = inventory.getContainerSize();
        for (int i = 0; i < n; ++i) {
            if (inventory.getItem(i).isEmpty()) {
                int toTransfer = Math.min(stack.getCount(), stack.getMaxStackSize());
                inventory.setItem(i, stack.split(toTransfer));
                inventory.setChanged();
            }
            if (!stack.isEmpty()) continue;
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        return stack;
    }

    private final ItemStack fillExistingStacks(Container inventory, ItemStack stack) {
        int n = inventory.getContainerSize();
        for (int i = 0; i < n; ++i) {
            ItemStack inventoryStack = inventory.getItem(i);
            if (inventoryStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int availableSpace = inventoryStack.getMaxStackSize() - inventoryStack.getCount();
            if (availableSpace > 0) {
                int toTransfer = Math.min(stack.getCount(), availableSpace);
                inventoryStack.grow(toTransfer);
                stack.shrink(toTransfer);
                inventory.setChanged();
            }
            if (!stack.isEmpty()) continue;
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        return stack;
    }

    public final void handleDepositing(@NotNull Level world, @NotNull BlockPos origin, @NotNull PokemonEntity pokemonEntity, @NotNull List<ItemStack> itemsToDeposit, @NotNull Map<UUID, Set<BlockPos>> failedDepositLocations, @NotNull Map<UUID, List<ItemStack>> heldItemsByPokemon) {
        Set triedPositions;
        BlockPos inventoryPos;
        Set set;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Intrinsics.checkNotNullParameter(itemsToDeposit, (String)"itemsToDeposit");
        Intrinsics.checkNotNullParameter(failedDepositLocations, (String)"failedDepositLocations");
        Intrinsics.checkNotNullParameter(heldItemsByPokemon, (String)"heldItemsByPokemon");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        Map<UUID, Set<BlockPos>> $this$getOrPut$iv = failedDepositLocations;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(pokemonId);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(pokemonId, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        if ((inventoryPos = this.findClosestInventory(world, origin, triedPositions = set)) == null) {
            if (DeferredBlockScanner.INSTANCE.isScanActive(origin)) {
                heldItemsByPokemon.put(pokemonId, itemsToDeposit);
                return;
            }
            Iterable $this$forEach$iv = itemsToDeposit;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack stack = (ItemStack)element$iv;
                boolean bl = false;
                Block.popResource((Level)world, (BlockPos)pokemonEntity.blockPosition(), (ItemStack)stack);
            }
            heldItemsByPokemon.remove(pokemonId);
            failedDepositLocations.remove(pokemonId);
            return;
        }
        if (CobbleworkersNavigationUtils.INSTANCE.isPokemonAtPosition(pokemonEntity, inventoryPos, 2.0)) {
            Container inventory;
            BlockEntity $i$f$forEach = world.getBlockEntity(inventoryPos);
            Container container = inventory = $i$f$forEach instanceof Container ? (Container)$i$f$forEach : null;
            if (inventory == null) {
                triedPositions.add(inventoryPos);
                return;
            }
            List<ItemStack> remainingDrops = this.insertStacks(inventory, itemsToDeposit);
            if (remainingDrops.size() == itemsToDeposit.size()) {
                triedPositions.add(inventoryPos);
            }
            if (!((Collection)remainingDrops).isEmpty()) {
                heldItemsByPokemon.put(pokemonId, remainingDrops);
            } else {
                heldItemsByPokemon.remove(pokemonId);
                failedDepositLocations.remove(pokemonId);
                pokemonEntity.getNavigation().stop();
            }
        } else {
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, inventoryPos, 0.0, 4, null);
        }
    }

    static {
        Object[] objectArray = new Block[]{Blocks.CHEST, Blocks.TRAPPED_CHEST, Blocks.BARREL, CobblemonBlocks.GILDED_CHEST, CobblemonBlocks.BLUE_GILDED_CHEST, CobblemonBlocks.PINK_GILDED_CHEST, CobblemonBlocks.BLACK_GILDED_CHEST, CobblemonBlocks.WHITE_GILDED_CHEST, CobblemonBlocks.GREEN_GILDED_CHEST, CobblemonBlocks.YELLOW_GILDED_CHEST};
        validInventoryBlocks = SetsKt.mutableSetOf((Object[])objectArray);
    }
}

