/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.utilities;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.jobs.LavaGenerator;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Laccieo/cobbleworkers/utilities/CobbleworkersCauldronUtils;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "origin", "findClosestCauldron", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "cauldronPos", "Laccieo/cobbleworkers/utilities/CobbleworkersCauldronUtils$CauldronFluid;", "fluid", "", "addFluid", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Laccieo/cobbleworkers/utilities/CobbleworkersCauldronUtils$CauldronFluid;)V", "CauldronFluid", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nCobbleworkersCauldronUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbleworkersCauldronUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersCauldronUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n774#2:51\n865#2,2:52\n2423#2,14:54\n*S KotlinDebug\n*F\n+ 1 CobbleworkersCauldronUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersCauldronUtils\n*L\n32#1:51\n32#1:52,2\n35#1:54,14\n*E\n"})
public final class CobbleworkersCauldronUtils {
    @NotNull
    public static final CobbleworkersCauldronUtils INSTANCE = new CobbleworkersCauldronUtils();

    private CobbleworkersCauldronUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BlockPos findClosestCauldron(@NotNull Level world, @NotNull BlockPos origin) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Set<BlockPos> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, JobType.CauldronGenerator);
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BlockPos pos = (BlockPos)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)LavaGenerator.INSTANCE.getBlockValidator().invoke((Object)world, (Object)pos) != false && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(pos, world))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BlockPos it = (BlockPos)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.distSqr((Vec3i)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    BlockPos it2 = (BlockPos)e$iv;
                    $i$a$-minByOrNull-CobbleworkersCauldronUtils$findClosestCauldron$2 = false;
                    double v$iv = it2.distSqr((Vec3i)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public final void addFluid(@NotNull Level world, @NotNull BlockPos cauldronPos, @NotNull CauldronFluid fluid) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)cauldronPos, (String)"cauldronPos");
        Intrinsics.checkNotNullParameter((Object)((Object)fluid), (String)"fluid");
        BlockState newState = switch (WhenMappings.$EnumSwitchMapping$0[fluid.ordinal()]) {
            case 1 -> (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
            case 2 -> Blocks.LAVA_CAULDRON.defaultBlockState();
            case 3 -> (BlockState)Blocks.POWDER_SNOW_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
            default -> throw new NoWhenBranchMatchedException();
        };
        world.setBlockAndUpdate(cauldronPos, newState);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Laccieo/cobbleworkers/utilities/CobbleworkersCauldronUtils$CauldronFluid;", "", "<init>", "(Ljava/lang/String;I)V", "WATER", "LAVA", "POWDER_SNOW", "cobbleworkers-common"})
    public static final class CauldronFluid
    extends Enum<CauldronFluid> {
        public static final /* enum */ CauldronFluid WATER = new CauldronFluid();
        public static final /* enum */ CauldronFluid LAVA = new CauldronFluid();
        public static final /* enum */ CauldronFluid POWDER_SNOW = new CauldronFluid();
        private static final /* synthetic */ CauldronFluid[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CauldronFluid[] values() {
            return (CauldronFluid[])$VALUES.clone();
        }

        public static CauldronFluid valueOf(String value) {
            return Enum.valueOf(CauldronFluid.class, value);
        }

        @NotNull
        public static EnumEntries<CauldronFluid> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cauldronFluidArray = new CauldronFluid[]{CauldronFluid.WATER, CauldronFluid.LAVA, CauldronFluid.POWDER_SNOW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CauldronFluid.values().length];
            try {
                nArray[CauldronFluid.WATER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CauldronFluid.LAVA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CauldronFluid.POWDER_SNOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

