/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.mixin;

import accieo.cobbleworkers.Cobbleworkers;
import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.jobs.WorkerDispatcher;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonPastureBlockEntity.class})
public class PokemonPastureBlockEntityMixin {
    @Inject(at={@At(value="TAIL")}, method={"TICKER$lambda$0(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/block/entity/PokemonPastureBlockEntity;)V"})
    private static void init(Level world, BlockPos blockPos, BlockState blockState, PokemonPastureBlockEntity pastureBlock, CallbackInfo ci) {
        if (world.isClientSide) {
            return;
        }
        try {
            WorkerDispatcher.INSTANCE.tickAreaScan(world, blockPos);
        }
        catch (Exception e) {
            Cobbleworkers.LOGGER.error("[Cobbleworkers] - Error processing WorkerDispatcher tickAreaScan", (Throwable)e);
        }
        pastureBlock.getTetheredPokemon().stream().filter(Objects::nonNull).forEach(tethering -> {
            Pokemon pokemon;
            try {
                pokemon = tethering.getPokemon();
            }
            catch (Exception e) {
                Cobbleworkers.LOGGER.error("[Cobbleworkers] - Failed to get Pok\u00e9mon from tethering: {}", (Object)e.getMessage());
                return;
            }
            if (pokemon == null || pokemon.isFainted()) {
                return;
            }
            PokemonEntity pokemonEntity = pokemon.getEntity();
            if (pokemonEntity == null) {
                return;
            }
            try {
                WorkerDispatcher.INSTANCE.tickPokemon(world, blockPos, pokemonEntity);
            }
            catch (Exception e) {
                Cobbleworkers.LOGGER.error("[Cobbleworkers] - Error processing WorkerDispatcher.tickPokemon {}", (Object)e.getMessage());
            }
        });
    }

    @Inject(method={"onBroken()V"}, at={@At(value="TAIL")}, remap=false)
    private void onPastureBroken(CallbackInfo ci) {
        PokemonPastureBlockEntity self = (PokemonPastureBlockEntity)this;
        Level world = self.getLevel();
        if (world != null && !world.isClientSide) {
            CobbleworkersCacheManager.INSTANCE.removePasture(self.getBlockPos());
        }
    }
}

