/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.jobs;

import accieo.cobbleworkers.cache.CobbleworkersCacheManager;
import accieo.cobbleworkers.config.CobbleworkersConfig;
import accieo.cobbleworkers.config.CobbleworkersConfigHolder;
import accieo.cobbleworkers.enums.JobType;
import accieo.cobbleworkers.interfaces.Worker;
import accieo.cobbleworkers.utilities.CobbleworkersInventoryUtils;
import accieo.cobbleworkers.utilities.CobbleworkersNavigationUtils;
import accieo.cobbleworkers.utilities.CobbleworkersTypeUtils;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ!\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\bR\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR&\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001cR&\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\"0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\u001cR\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010(\u001a\u00020'8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R,\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060,8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Laccieo/cobbleworkers/jobs/TumblestoneHarvester;", "Laccieo/cobbleworkers/interfaces/Worker;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "shouldRun", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "origin", "", "tick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "handleHarvesting", "findClosestTumblestone", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "tumblestonePos", "harvestTumblestone", "isDesignatedHarvester", "", "Lnet/minecraft/world/level/block/Block;", "VALID_TUMBLESTONE_BLOCKS", "Ljava/util/Set;", "", "REPLACEMENT_BLOCKS", "Ljava/util/Map;", "", "Ljava/util/UUID;", "", "Lnet/minecraft/world/item/ItemStack;", "heldItemsByPokemon", "", "failedDepositLocations", "Laccieo/cobbleworkers/config/CobbleworkersConfig$TumblestoneGroup;", "config", "Laccieo/cobbleworkers/config/CobbleworkersConfig$TumblestoneGroup;", "Laccieo/cobbleworkers/enums/JobType;", "jobType", "Laccieo/cobbleworkers/enums/JobType;", "getJobType", "()Laccieo/cobbleworkers/enums/JobType;", "Lkotlin/Function2;", "blockValidator", "Lkotlin/jvm/functions/Function2;", "getBlockValidator", "()Lkotlin/jvm/functions/Function2;", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nTumblestoneHarvester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TumblestoneHarvester.kt\naccieo/cobbleworkers/jobs/TumblestoneHarvester\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n774#2:167\n865#2,2:168\n2423#2,14:170\n1761#2,3:184\n*S KotlinDebug\n*F\n+ 1 TumblestoneHarvester.kt\naccieo/cobbleworkers/jobs/TumblestoneHarvester\n*L\n114#1:167\n114#1:168,2\n118#1:170,14\n164#1:184,3\n*E\n"})
public final class TumblestoneHarvester
implements Worker {
    @NotNull
    public static final TumblestoneHarvester INSTANCE = new TumblestoneHarvester();
    @NotNull
    private static final Set<Block> VALID_TUMBLESTONE_BLOCKS;
    @NotNull
    private static final Map<Block, Block> REPLACEMENT_BLOCKS;
    @NotNull
    private static final Map<UUID, List<ItemStack>> heldItemsByPokemon;
    @NotNull
    private static final Map<UUID, Set<BlockPos>> failedDepositLocations;
    @NotNull
    private static final CobbleworkersConfig.TumblestoneGroup config;
    @NotNull
    private static final JobType jobType;
    @NotNull
    private static final Function2<Level, BlockPos, Boolean> blockValidator;

    private TumblestoneHarvester() {
    }

    @Override
    @NotNull
    public JobType getJobType() {
        return jobType;
    }

    @Override
    @NotNull
    public Function2<Level, BlockPos, Boolean> getBlockValidator() {
        return blockValidator;
    }

    @Override
    public boolean shouldRun(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        if (!config.getTumblestoneHarvestersEnabled()) {
            return false;
        }
        return CobbleworkersTypeUtils.INSTANCE.isAllowedByType(config.getTypeHarvestsTumblestone(), pokemonEntity) || this.isDesignatedHarvester(pokemonEntity);
    }

    @Override
    public void tick(@NotNull Level world, @NotNull BlockPos origin, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        List<ItemStack> heldItems = heldItemsByPokemon.get(pokemonId);
        Collection collection = heldItems;
        if (collection == null || collection.isEmpty()) {
            failedDepositLocations.remove(pokemonId);
            this.handleHarvesting(world, origin, pokemonEntity);
        } else {
            CobbleworkersInventoryUtils.INSTANCE.handleDepositing(world, origin, pokemonEntity, heldItems, failedDepositLocations, heldItemsByPokemon);
        }
    }

    private final void handleHarvesting(Level world, BlockPos origin, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        BlockPos blockPos = this.findClosestTumblestone(world, origin);
        if (blockPos == null) {
            return;
        }
        BlockPos closestTumblestone = blockPos;
        Intrinsics.checkNotNull((Object)pokemonId);
        BlockPos currentTarget = CobbleworkersNavigationUtils.INSTANCE.getTarget(pokemonId, world);
        if (currentTarget == null) {
            if (!CobbleworkersNavigationUtils.INSTANCE.isTargeted(closestTumblestone, world) && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(closestTumblestone, world)) {
                CobbleworkersNavigationUtils.INSTANCE.claimTarget(pokemonId, closestTumblestone, world);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)currentTarget, (Object)closestTumblestone)) {
            CobbleworkersNavigationUtils.navigateTo$default(CobbleworkersNavigationUtils.INSTANCE, pokemonEntity, closestTumblestone, 0.0, 4, null);
        }
        if (CobbleworkersNavigationUtils.INSTANCE.isPokemonAtPosition(pokemonEntity, currentTarget, 1.5)) {
            this.harvestTumblestone(world, closestTumblestone, pokemonEntity);
            CobbleworkersNavigationUtils.INSTANCE.releaseTarget(pokemonId, world);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final BlockPos findClosestTumblestone(Level world, BlockPos origin) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set<BlockPos> possibleTargets = CobbleworkersCacheManager.INSTANCE.getTargets(origin, this.getJobType());
        if (possibleTargets.isEmpty()) {
            return null;
        }
        Iterable iterable = possibleTargets;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BlockPos pos = (BlockPos)element$iv$iv;
            boolean bl = false;
            BlockState state = world.getBlockState(pos);
            if (!((Boolean)INSTANCE.getBlockValidator().invoke((Object)world, (Object)pos) != false && !CobbleworkersNavigationUtils.INSTANCE.isRecentlyExpired(pos, world))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BlockPos it = (BlockPos)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.distSqr((Vec3i)origin);
                do {
                    Object e$iv = iterator$iv.next();
                    BlockPos it2 = (BlockPos)e$iv;
                    $i$a$-minByOrNull-TumblestoneHarvester$findClosestTumblestone$2 = false;
                    double v$iv = it2.distSqr((Vec3i)origin);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private final void harvestTumblestone(Level world, BlockPos tumblestonePos, PokemonEntity pokemonEntity) {
        UUID pokemonId = pokemonEntity.getPokemon().getUuid();
        BlockState tumblestoneState = world.getBlockState(tumblestonePos);
        if (!VALID_TUMBLESTONE_BLOCKS.contains(tumblestoneState.getBlock())) {
            return;
        }
        Intrinsics.checkNotNull((Object)world, (String)"null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
        LootParams.Builder lootParams = new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.ORIGIN, (Object)tumblestonePos.getCenter()).withParameter(LootContextParams.BLOCK_STATE, (Object)tumblestoneState).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)pokemonEntity);
        List drops = tumblestoneState.getDrops(lootParams);
        Intrinsics.checkNotNull((Object)drops);
        if (!((Collection)drops).isEmpty()) {
            heldItemsByPokemon.put(pokemonId, drops);
        }
        if (config.getShouldReplantTumblestone()) {
            Block originalBlock = tumblestoneState.getBlock();
            Block block = REPLACEMENT_BLOCKS.get(originalBlock);
            if (block == null) {
                return;
            }
            Block replacementBlock = block;
            BlockState replacementState = replacementBlock.defaultBlockState();
            DirectionProperty facingProperty = BlockStateProperties.FACING;
            if (replacementState.getProperties().contains(facingProperty) && tumblestoneState.hasProperty((Property)facingProperty)) {
                replacementState = (BlockState)replacementState.setValue((Property)facingProperty, tumblestoneState.getValue((Property)facingProperty));
            }
            v1 = world.setBlockAndUpdate(tumblestonePos, replacementState);
        } else {
            v1 = world.setBlockAndUpdate(tumblestonePos, Blocks.AIR.defaultBlockState());
        }
    }

    private final boolean isDesignatedHarvester(PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            String string = pokemonEntity.getPokemon().getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String speciesName = string2;
            Iterable $this$any$iv = config.getTumblestoneHarvesters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)speciesName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean blockValidator$lambda$0(Level world, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState state = world.getBlockState(pos);
        return VALID_TUMBLESTONE_BLOCKS.contains(state.getBlock());
    }

    static {
        Object[] objectArray = new Block[]{CobblemonBlocks.TUMBLESTONE_CLUSTER, CobblemonBlocks.BLACK_TUMBLESTONE_CLUSTER, CobblemonBlocks.SKY_TUMBLESTONE_CLUSTER};
        VALID_TUMBLESTONE_BLOCKS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)CobblemonBlocks.TUMBLESTONE_CLUSTER, (Object)CobblemonBlocks.SMALL_BUDDING_TUMBLESTONE), TuplesKt.to((Object)CobblemonBlocks.BLACK_TUMBLESTONE_CLUSTER, (Object)CobblemonBlocks.SMALL_BUDDING_BLACK_TUMBLESTONE), TuplesKt.to((Object)CobblemonBlocks.SKY_TUMBLESTONE_CLUSTER, (Object)CobblemonBlocks.SMALL_BUDDING_SKY_TUMBLESTONE)};
        REPLACEMENT_BLOCKS = MapsKt.mapOf((Pair[])objectArray);
        heldItemsByPokemon = new LinkedHashMap();
        failedDepositLocations = new LinkedHashMap();
        config = CobbleworkersConfigHolder.INSTANCE.getConfig().getTumblestone();
        jobType = JobType.TumblestoneHarvester;
        blockValidator = TumblestoneHarvester::blockValidator$lambda$0;
    }
}

