/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.Main;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class CropEvents {
    @SubscribeEvent
    public void onPlayerUse(PlayerInteractEvent.RightClickBlock event) {
        if (CropEvents.harvest(event.getHitVec(), event.getPos(), event.getEntity())) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static boolean harvest(BlockHitResult hitResult, BlockPos pos, Player player) {
        Level world = player.level();
        BlockState state = world.getBlockState(pos);
        Block blockClicked = state.getBlock();
        if (Main.SERVER_CONFIG.reapWhitelist.stream().noneMatch(tag -> tag.contains(state.getBlock()))) {
            return false;
        }
        BonemealableBlock growable = CropEvents.getGrowable(blockClicked);
        if (growable == null) {
            return false;
        }
        if (growable.isValidBonemealTarget((LevelReader)world, pos, state)) {
            return false;
        }
        if (world.isClientSide || !(world instanceof ServerLevel)) {
            return true;
        }
        LootParams.Builder context = new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
        if (((Boolean)Main.SERVER_CONFIG.considerTool.get()).booleanValue()) {
            context.withParameter(LootContextParams.TOOL, (Object)player.getMainHandItem());
        } else {
            context.withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY);
        }
        List drops = state.getDrops(context);
        BlockState newState = blockClicked.defaultBlockState();
        if (state.getProperties().stream().anyMatch(p -> p.equals((Object)BlockStateProperties.HORIZONTAL_FACING))) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }
        if (state.getProperties().stream().anyMatch(p -> p.equals((Object)BlockStateProperties.AGE_7))) {
            newState = (BlockState)state.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(0));
        }
        world.setBlockAndUpdate(pos, newState);
        ItemStack clickedBlockItem = state.getCloneItemStack((HitResult)hitResult, (LevelReader)world, pos, player);
        for (ItemStack stack : drops) {
            if (stack.is(clickedBlockItem.getItem())) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        }
        return true;
    }

    private static BonemealableBlock getGrowable(Block block) {
        if (block instanceof BonemealableBlock) {
            return (BonemealableBlock)block;
        }
        if (block instanceof NetherWartBlock) {
            return new BonemealableBlock(){

                public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos pos, BlockState state) {
                    return (Integer)state.getValue((Property)NetherWartBlock.AGE) < 3;
                }

                public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
                    return false;
                }

                public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
                }
            };
        }
        return null;
    }
}

