/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.everythingcopper.common.block.entity.WeatheringStationBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.model.data.ModelData;

public class WeatheringStationRenderer
implements BlockEntityRenderer<WeatheringStationBlockEntity> {
    public WeatheringStationRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WeatheringStationBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        ItemStack input = blockEntity.inventoryHandler.getStackInSlot(WeatheringStationBlockEntity.SLOT_INPUT);
        ItemStack output = blockEntity.inventoryHandler.getStackInSlot(WeatheringStationBlockEntity.SLOT_OUTPUT);
        if (!input.isEmpty()) {
            this.renderItem(blockEntity.getLevel(), input, true, !output.isEmpty(), poseStack, bufferSource, light, overlay);
        }
        if (!output.isEmpty()) {
            this.renderItem(blockEntity.getLevel(), output, false, !input.isEmpty(), poseStack, bufferSource, light, overlay);
        }
    }

    private void renderItem(Level level, ItemStack output, boolean isInput, boolean multiItems, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        poseStack.pushPose();
        Item item = output.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (multiItems) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
                if (isInput) {
                    poseStack.translate(0.3, 0.6, 0.3);
                } else {
                    poseStack.translate(0.75, 0.7, 0.75);
                }
            } else {
                poseStack.scale(0.625f, 0.625f, 0.625f);
                poseStack.translate(0.3, 0.4, 0.3);
            }
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockItem.getBlock().defaultBlockState(), poseStack, bufferSource, light, overlay, ModelData.EMPTY, null);
        } else {
            if (multiItems) {
                poseStack.translate(0.5, 0.6375, 0.5);
                if (isInput) {
                    poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                }
                poseStack.scale(0.7f, 0.7f, 0.7f);
            } else {
                poseStack.translate(0.5, 0.6375, 0.5);
                poseStack.scale(0.7f, 0.7f, 0.7f);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(output, ItemDisplayContext.FIXED, light, overlay, poseStack, bufferSource, level, 0);
        }
        poseStack.popPose();
    }
}

