/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.projectile;

import com.stal111.forbidden_arcanus.common.network.clientbound.SpawnParticlePayload;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class AurealMissile
extends Projectile {
    public double accelerationPower = 0.03;

    public AurealMissile(EntityType<? extends AurealMissile> entityType, Level level) {
        super(entityType, level);
    }

    public AurealMissile(LivingEntity livingEntity, Level level, double x, double y, double z) {
        super((EntityType)ModEntities.AUREAL_MISSILE.get(), level);
        this.setOwner((Entity)livingEntity);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    public void tick() {
        float f;
        super.tick();
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
        if (!this.isInWater()) {
            f = this.getInertia();
        } else {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
            f = this.getLiquidInertia();
        }
        this.setDeltaMovement(vec3.add(vec3.normalize().scale(this.accelerationPower)).scale((double)f));
        if (this.tickCount % 4 == 0) {
            this.level().addParticle((ParticleOptions)ModParticles.MAGIC_GLINT.get(), this.getX(), this.getY() + 0.2, this.getZ(), 0.0, 0.0, 0.0);
        }
        this.setPos(d0, d1, d2);
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            DamageSource damagesource;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = result.getEntity();
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                owner.setLastHurtMob(entity);
            }
            if (entity.hurt(damagesource = this.damageSources().magic(), 5.0f) && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)livingEntity, (DamageSource)damagesource);
            }
        }
    }

    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.blockPosition()), (CustomPacketPayload)new SpawnParticlePayload(this.getX(), this.getY(), this.getZ(), 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.discard();
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return false;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    private float getInertia() {
        return 0.95f;
    }

    private float getLiquidInertia() {
        return 0.8f;
    }
}

