/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.darktrader;

import com.mojang.serialization.Dynamic;
import com.stal111.forbidden_arcanus.common.entity.QuantumLightDoorAnimationProvider;
import com.stal111.forbidden_arcanus.common.entity.darktrader.DarkTraderAI;
import com.stal111.forbidden_arcanus.common.entity.darktrader.DarkTraderVariant;
import com.stal111.forbidden_arcanus.core.init.other.ModEntityDataSerializers;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DarkTrader
extends Mob
implements VariantHolder<Holder<DarkTraderVariant>>,
QuantumLightDoorAnimationProvider {
    private static final EntityDataAccessor<Holder<DarkTraderVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(DarkTrader.class, (EntityDataSerializer)((EntityDataSerializer)ModEntityDataSerializers.DARK_TRADER_VARIANT.get()));
    public final AnimationState portalAnimationState = new AnimationState();
    public final AnimationState spawnAnimationState = new AnimationState();

    public DarkTrader(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, DarkTraderVariant.BROOK);
    }

    @NotNull
    protected Brain<?> makeBrain(@NotNull Dynamic<?> dynamic) {
        return DarkTraderAI.makeBrain(this, dynamic);
    }

    @NotNull
    public Brain<DarkTrader> getBrain() {
        return super.getBrain();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        if (reason == MobSpawnType.MOB_SUMMONED) {
            this.setPose(Pose.EMERGING);
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.IS_EMERGING, (Object)Unit.INSTANCE, 60L);
        }
        return super.finalizeSpawn(level, difficulty, reason, spawnData);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.spawnAnimationState.animateWhen(this.getPose() == Pose.EMERGING && this.portalAnimationState.getAccumulatedTime() > 600L, this.tickCount);
        }
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        if (DATA_POSE.equals(key) && this.getPose() == Pose.EMERGING) {
            this.portalAnimationState.start(this.tickCount);
        }
        super.onSyncedDataUpdated(key);
    }

    @NotNull
    public Holder<DarkTraderVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(@NotNull Holder<DarkTraderVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("darkTraderBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        DarkTraderAI.updateActivity(this);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("variant", FARegistries.DARK_TRADER_VARIANT_REGISTRY.getKey((Object)((DarkTraderVariant)this.getVariant().value())).toString());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString("variant"))).flatMap(arg_0 -> FARegistries.DARK_TRADER_VARIANT_REGISTRY.getHolder(arg_0)).ifPresent(this::setVariant);
    }

    @Override
    public AnimationState getAnimationState() {
        return this.portalAnimationState;
    }
}

