/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.forge.TierPredicate;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesDefinition;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;

public record RitualRequirements(EssencesDefinition essences, TierPredicate tier, HolderSet<EnhancerDefinition> enhancers) {
    public static final RitualRequirements NONE = new RitualRequirements(EssencesDefinition.EMPTY, TierPredicate.ANY, (HolderSet<EnhancerDefinition>)HolderSet.empty());
    public static final MapCodec<RitualRequirements> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EssencesDefinition.CODEC.fieldOf("essences").forGetter(RitualRequirements::essences), (App)TierPredicate.CODEC.forGetter(RitualRequirements::tier), (App)EnhancerDefinition.LIST_CODEC.optionalFieldOf("enhancers", (Object)HolderSet.empty()).forGetter(RitualRequirements::enhancers)).apply((Applicative)instance, RitualRequirements::new));

    public static Builder builder(EssencesDefinition essences) {
        return new Builder(essences);
    }

    public boolean checkRequirements(int forgeTier, HolderSet<EnhancerDefinition> enhancers) {
        if (!this.tier.test(forgeTier)) {
            return false;
        }
        return this.enhancers.stream().allMatch(arg_0 -> enhancers.contains(arg_0));
    }

    public static class Builder {
        private final EssencesDefinition essences;
        private TierPredicate tier = TierPredicate.ANY;
        private HolderSet<EnhancerDefinition> enhancers = HolderSet.empty();

        private Builder(EssencesDefinition essences) {
            this.essences = essences;
        }

        public Builder tier(TierPredicate tier) {
            this.tier = tier;
            return this;
        }

        public Builder enhancer(Holder<EnhancerDefinition> enhancer) {
            this.enhancers = HolderSet.direct((Holder[])new Holder[]{enhancer});
            return this;
        }

        public Builder enhancers(HolderSet<EnhancerDefinition> enhancers) {
            this.enhancers = enhancers;
            return this;
        }

        public RitualRequirements build() {
            return new RitualRequirements(this.essences, this.tier, this.enhancers);
        }
    }
}

