/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class UpwindBlock
extends Block {
    private static final Predicate<BlockState> IS_VALID_SUPPORT = state -> state.is((Block)ModBlocks.WHIRLWIND.get()) || state.is((Block)ModBlocks.UPWIND.get());
    public static final int UPWIND_HEIGHT = 10;

    public UpwindBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void createUpwindAbove(LevelAccessor level, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            level.setBlock(pos.above(i + 1), ((UpwindBlock)((Object)ModBlocks.UPWIND.get())).defaultBlockState(), 2);
        }
    }

    private static boolean canExistIn(BlockState state) {
        return state.is((Block)ModBlocks.UPWIND.get()) || state.isAir();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return IS_VALID_SUPPORT.test(level.getBlockState(pos.below()));
    }

    public void entityInside(@NotNull BlockState state, Level level, BlockPos pos, @NotNull Entity entity) {
        BlockState aboveState = level.getBlockState(pos.above());
        if (aboveState.isAir()) {
            entity.onAboveBubbleCol(false);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 70));
            }
        } else {
            entity.onInsideBubbleColumn(false);
        }
    }

    public void animateTick(@NotNull BlockState state, Level level, BlockPos pos, RandomSource random) {
        double d0 = pos.getX();
        double d1 = pos.getY();
        double d2 = pos.getZ();
        level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.EFFECT, d0 + 0.5, d1, d2 + 0.5, 0.0, 0.1, 0.0);
        level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.EFFECT, d0 + (double)random.nextFloat(), d1 + (double)random.nextFloat(), d2 + (double)random.nextFloat(), 0.0, 0.1, 0.0);
        if (random.nextInt(200) == 0) {
            level.playLocalSound(d0, d1, d2, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }
}

