/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.particle;

import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.valueproviders.UniformInt;

public class AurealMoteParticle
extends TextureSheetParticle {
    private static final UniformInt DEFAULT_LIFE_TIME = UniformInt.of((int)60, (int)72);
    private float alpha = 0.0f;

    private AurealMoteParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.x = x;
        this.y = y;
        this.z = z;
        this.yd = ySpeed;
        if (xSpeed == 0.0) {
            this.xd = 0.0;
        }
        if (zSpeed == 0.0) {
            this.zd = 0.0;
        }
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.3f + 0.8f);
        this.lifetime = DEFAULT_LIFE_TIME.sample(this.random);
        this.setAlpha(this.alpha);
    }

    @Nonnull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void move(double x, double y, double z) {
        this.setBoundingBox(this.getBoundingBox().move(x, y, z));
        this.setLocationFromBoundingbox();
    }

    public float getQuadSize(float scaleFactor) {
        float f = ((float)this.age + scaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f * 0.5f);
    }

    public void tick() {
        if (this.alpha < 1.0f) {
            this.alpha += 0.05f;
            this.setAlpha(this.alpha);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            this.yd *= 0.91;
        }
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public record Factory(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(@Nonnull SimpleParticleType type, @Nonnull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AurealMoteParticle particle = new AurealMoteParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

