/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.event;

import com.mojang.datafixers.util.Either;
import com.stal111.forbidden_arcanus.client.tooltip.CapacityBucketTooltip;
import com.stal111.forbidden_arcanus.common.item.bucket.CapacityBucket;
import com.stal111.forbidden_arcanus.common.item.modifier.ModifierHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class TooltipEvents {
    @SubscribeEvent
    public static void onRenderTooltipColor(RenderTooltipEvent.Color event) {
        ItemStack stack = event.getItemStack();
        ModifierHelper.getModifier(stack).map(modifier -> modifier.displaySettings().tooltipColor()).ifPresent(color -> {
            event.setBorderStart(((Integer)color.getFirst()).intValue());
            event.setBorderEnd(((Integer)color.getSecond()).intValue());
        });
    }

    @SubscribeEvent
    public static void onGatherComponents(RenderTooltipEvent.GatherComponents event) {
        CapacityBucket capacityBucket;
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof CapacityBucket && (capacityBucket = (CapacityBucket)item).getCapacity(stack) != 0) {
            event.getTooltipElements().add(1, Either.right((Object)new CapacityBucketTooltip(stack, capacityBucket.getFullness(stack), capacityBucket.getCapacity(stack))));
        }
    }
}

