/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;

public enum JukeboxProvider implements IBlockComponentProvider,
StreamServerDataProvider<BlockAccessor, ItemStack>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Optional result = INSTANCE.decodeFromData(accessor);
        if (result.isEmpty()) {
            return;
        }
        ItemStack stack = (ItemStack)result.get();
        if (stack.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.empty"));
            return;
        }
        JukeboxPlayable playable = (JukeboxPlayable)stack.get(DataComponents.JUKEBOX_PLAYABLE);
        Component name = playable != null ? playable.song().unwrap((HolderLookup.Provider)accessor.getLevel().registryAccess()).map($ -> ((JukeboxSong)$.value()).description()).orElse(stack.getHoverName()) : stack.getHoverName();
        tooltip.add((Component)Component.translatable((String)"record.nowPlaying", (Object[])new Object[]{IDisplayHelper.get().stripColor(name)}));
    }

    @Override
    public boolean shouldRequestData(BlockAccessor accessor) {
        return (Boolean)accessor.getBlockState().getValue((Property)JukeboxBlock.HAS_RECORD);
    }

    @Override
    public ItemStack streamData(BlockAccessor accessor) {
        return ((JukeboxBlockEntity)accessor.getBlockEntity()).getTheItem();
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ItemStack> streamCodec() {
        return ItemStack.OPTIONAL_STREAM_CODEC;
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_JUKEBOX;
    }
}

