/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.neoforge.network;

import com.cobblemon.mod.common.battles.BattleFormat;
import com.necro.raid.dens.common.network.ClientPacket;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.network.ServerPacket;
import com.necro.raid.dens.common.network.packets.JoinRaidPacket;
import com.necro.raid.dens.common.network.packets.LeaveRaidPacket;
import com.necro.raid.dens.common.network.packets.RaidAspectPacket;
import com.necro.raid.dens.common.network.packets.RaidChallengePacket;
import com.necro.raid.dens.common.network.packets.RaidLogPacket;
import com.necro.raid.dens.common.network.packets.RequestPacket;
import com.necro.raid.dens.common.network.packets.RequestResponsePacket;
import com.necro.raid.dens.common.network.packets.ResizePacket;
import com.necro.raid.dens.common.network.packets.RewardPacket;
import com.necro.raid.dens.common.network.packets.RewardResponsePacket;
import com.necro.raid.dens.common.network.packets.SyncHealthPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="cobblemonraiddens")
public class NetworkMessages {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar payloadRegistrar = event.registrar("cobblemonraiddens").versioned("1.0.0").optional();
        payloadRegistrar.playToClient(SyncHealthPacket.PACKET_TYPE, SyncHealthPacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToClient(JoinRaidPacket.PACKET_TYPE, JoinRaidPacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToClient(RequestPacket.PACKET_TYPE, RequestPacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToClient(RewardPacket.PACKET_TYPE, RewardPacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToClient(ResizePacket.PACKET_TYPE, ResizePacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToClient(RaidAspectPacket.PACKET_TYPE, RaidAspectPacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToClient(RaidLogPacket.PACKET_TYPE, RaidLogPacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToServer(RaidChallengePacket.PACKET_TYPE, RaidChallengePacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToServer(LeaveRaidPacket.PACKET_TYPE, LeaveRaidPacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToServer(RequestResponsePacket.PACKET_TYPE, RequestResponsePacket.CODEC, NetworkMessages::handle);
        payloadRegistrar.playToServer(RewardResponsePacket.PACKET_TYPE, RewardResponsePacket.CODEC, NetworkMessages::handle);
    }

    public static void init() {
        RaidDenNetworkMessages.SYNC_HEALTH = (player, healthRatio) -> NetworkMessages.sendPacketToPlayer(player, new SyncHealthPacket(healthRatio.floatValue()));
        RaidDenNetworkMessages.JOIN_RAID = (player, isJoining) -> NetworkMessages.sendPacketToPlayer(player, new JoinRaidPacket((boolean)isJoining));
        RaidDenNetworkMessages.REQUEST_PACKET = (player, name) -> NetworkMessages.sendPacketToPlayer(player, new RequestPacket((String)name));
        RaidDenNetworkMessages.REWARD_PACKET = (player, isCatchable, pokemon) -> NetworkMessages.sendPacketToPlayer(player, new RewardPacket((boolean)isCatchable, (String)pokemon));
        RaidDenNetworkMessages.RESIZE = (level, entity, scale) -> NetworkMessages.sendPacketToLevel(level, new ResizePacket(entity.getId(), scale.floatValue()));
        RaidDenNetworkMessages.RAID_ASPECT = (player, entity) -> NetworkMessages.sendPacketToPlayer(player, new RaidAspectPacket(entity.getId()));
        RaidDenNetworkMessages.RAID_LOG = (player, pokemon, move) -> NetworkMessages.sendPacketToPlayer(player, new RaidLogPacket((String)pokemon, (String)move));
        RaidDenNetworkMessages.RAID_CHALLENGE = (pokemonEntity, pokemon) -> NetworkMessages.sendPacketToServer(new RaidChallengePacket(pokemonEntity.getId(), pokemon.getUuid(), BattleFormat.Companion.getGEN_9_SINGLES()));
        RaidDenNetworkMessages.LEAVE_RAID = () -> NetworkMessages.sendPacketToServer(new LeaveRaidPacket());
        RaidDenNetworkMessages.REQUEST_RESPONSE = (accept, player) -> NetworkMessages.sendPacketToServer(new RequestResponsePacket((boolean)accept, (String)player));
        RaidDenNetworkMessages.REWARD_RESPONSE = catchPokemon -> NetworkMessages.sendPacketToServer(new RewardResponsePacket((boolean)catchPokemon));
    }

    public static void sendPacketToServer(CustomPacketPayload packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendPacketToAll(CustomPacketPayload packet) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendPacketToLevel(ServerLevel level, CustomPacketPayload packet) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendPacketToPlayer(ServerPlayer player, CustomPacketPayload packet) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void handle(ClientPacket packet, IPayloadContext context) {
        context.enqueueWork(packet::handleClient);
    }

    private static void handle(ServerPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> packet.handleServer((ServerPlayer)context.player()));
    }
}

