/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.neoforge.events;

import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.registry.RaidBucketRegistry;
import com.necro.raid.dens.common.registry.RaidRegistry;
import com.necro.raid.dens.common.util.RaidUtils;
import com.necro.raid.dens.neoforge.events.reloader.BossAdditionsReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidBossReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidBucketReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidDenPoolReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidSupportReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidTagReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidTemplateReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.StatusEffectsReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="cobblemonraiddens")
public class ModEvents {
    @SubscribeEvent
    public static void commonTick(ServerTickEvent.Post event) {
        RaidHelper.commonTick();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        RaidHelper.teleportFromRaid(player2);
        if (RaidJoinHelper.isParticipatingOrInQueue((Player)player2, false)) {
            RaidDenNetworkMessages.JOIN_RAID.accept(player2, true);
        }
        if (RaidHelper.REWARD_QUEUE.containsKey(player2.getUUID())) {
            RaidHelper.REWARD_QUEUE.get(player2.getUUID()).sendRewardMessage();
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        RaidJoinHelper.onPlayerDisconnect(event.getEntity());
        RaidHelper.teleportFromRaid((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        RaidHelper.initHelper(server);
        RaidRegistry.initRaidBosses(server);
        RaidBucketRegistry.init(server);
    }

    @SubscribeEvent
    public static void onServerClose(ServerStoppingEvent event) {
        RaidJoinHelper.onServerClose();
        RaidHelper.onServerClose(event.getServer());
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (RaidUtils.cannotPlace(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (RaidUtils.cannotBreak(event.getPlayer(), (Level)event.getLevel())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        MinecraftServer server = event.getEntity().getServer();
        if (server == null) {
            return;
        }
        ModDimensions.onDimensionChange((ServerPlayer)event.getEntity(), server.getLevel(event.getFrom()), server.getLevel(event.getTo()));
    }

    @SubscribeEvent
    public static void onReloadDataPack(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RaidBossReloadListener());
        event.addListener((PreparableReloadListener)new RaidBucketReloadListener());
        event.addListener((PreparableReloadListener)new RaidDenPoolReloadListener());
        event.addListener((PreparableReloadListener)new RaidTemplateReloadListener());
        event.addListener((PreparableReloadListener)new RaidTagReloadListener());
        event.addListener((PreparableReloadListener)new BossAdditionsReloadListener());
        event.addListener((PreparableReloadListener)new StatusEffectsReloadListener());
        event.addListener((PreparableReloadListener)new RaidSupportReloadListener());
    }
}

